package com.yeejoin.amos.spc.business.controller;

import com.yeejoin.amos.op.core.common.query.DaoCriteria;
import com.yeejoin.amos.op.core.common.response.CommonResponse;
import com.yeejoin.amos.op.core.util.CommonResponseUtil;
import com.yeejoin.amos.spc.business.param.ReginParams;
import com.yeejoin.amos.spc.business.service.intfc.ISpcEvaluateModelService;
import com.yeejoin.amos.spc.core.common.request.CommonPageable;
import com.yeejoin.amos.spc.core.common.request.CommonRequest;
import com.yeejoin.amos.spc.dao.entity.SpcEvaluateModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@RestController
@RequestMapping(value = "/api/spcEvaluateModel")
@Api(tags = "风险评价模型")
public class SpcEvaluateModelController extends BaseController {

    @Autowired
    private ISpcEvaluateModelService iSpcEvaluateModelService;

    /**
     * 新增风险模型
     */
    @ApiOperation(httpMethod = "POST", value = "新增风险模型", notes = "新增风险模型")
    @PostMapping(value = "/save", produces = "application/json;charset=UTF-8")
    public CommonResponse saveSpcEvaluateModel(@RequestBody SpcEvaluateModel evaluateModel) {
    	List<SpcEvaluateModel> evaluateModels = iSpcEvaluateModelService.queryEvaluateModelByName(evaluateModel.getName());
    	Long curId = evaluateModel.getId();
    	if(null != curId) {//为编辑时过滤自己
    		evaluateModels = evaluateModels.stream().filter(e -> e.getId() != curId).collect(Collectors.toList());
    	}
    	if(evaluateModels != null && evaluateModels.size()>0) {
    		return CommonResponseUtil.failure("风险模型已存在！");
    	}
        ReginParams reginParams = getSelectedOrgInfo();
        evaluateModel.setCreatorId(getUserId());
        evaluateModel.setOrgCode(getLoginOrgCode(reginParams));
        evaluateModel.setUpdateDate(new Date());
        evaluateModel = iSpcEvaluateModelService.save(evaluateModel);
        return CommonResponseUtil.success(evaluateModel);
    }

    /**
     * 删除模型
     */
    @ApiOperation(httpMethod = "DELETE", value = "删除模型", notes = "删除模型")
    @DeleteMapping(value = "/delete/{ids}", produces = "application/json;charset=UTF-8")
    public CommonResponse delete(@PathVariable String ids) {
        String[] idArray = ids.split(",");
        iSpcEvaluateModelService.delete(idArray);
        return CommonResponseUtil.success();
    }


    /**
     * 模型列表页面查询
     */
    @ApiOperation(httpMethod = "POST", value = "模型列表页面查询", notes = "模型列表页面查询")
    @PostMapping(value = "/list", produces = "application/json;charset=UTF-8")
    public CommonResponse queryPage(
            @ApiParam(value = "查询条件")
            @RequestBody(required = false) List<CommonRequest> queryRequests,
            @ApiParam(value = "分页参数", required = true) CommonPageable commonPageable) {
        if (commonPageable.getPageSize() == -1) {
            List<SpcEvaluateModel> allList = iSpcEvaluateModelService.listAll();
            return CommonResponseUtil.success(allList);
        } else {
            List<DaoCriteria> criterias = buildDaoCriterias(queryRequests);
            Page<SpcEvaluateModel> list = iSpcEvaluateModelService.list(criterias, commonPageable);
            return CommonResponseUtil.success(list);
        }
    }
    
}
