package com.yeejoin.amos.spc.business.controller;

import com.yeejoin.amos.op.core.common.response.CommonResponse;
import com.yeejoin.amos.op.core.util.CommonResponseUtil;
import com.yeejoin.amos.spc.business.param.ReginParams;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value = "/api/region")
@Api(tags = "公司选择")
public class SpcReginController extends BaseController {

    @ApiOperation(httpMethod = "POST", value = "保存选择公司", notes = "保存选择公司")
    @RequestMapping(value = "/selected", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse selected(@RequestBody ReginParams reginParams) {
        this.saveSelectedOrgInfo(reginParams);
        return CommonResponseUtil.success();
    }

    @ApiOperation(httpMethod = "GET", value = "获取所选择公司", notes = "获取所选择公司")
    @RequestMapping(value = "/current", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse selected() {
        ReginParams region = this.getSelectedOrgInfo();
        return CommonResponseUtil.success(region);
    }
}
