package com.yeejoin.amos.spc.business.controller;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.yeejoin.amos.op.core.common.query.DaoCriteria;
import com.yeejoin.amos.op.core.common.response.CommonResponse;
import com.yeejoin.amos.op.core.util.CommonResponseUtil;
import com.yeejoin.amos.spc.business.service.intfc.ISpcRiskLevelService;
import com.yeejoin.amos.spc.core.common.request.CommonPageable;
import com.yeejoin.amos.spc.core.common.request.CommonRequest;
import com.yeejoin.amos.spc.dao.entity.SpcRiskLevel;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@RestController
@RequestMapping(value = "/api/spcRiskLevel")
@Api(tags = "风险等级")
public class SpcRiskLevelController extends BaseController {


    @Autowired
    private ISpcRiskLevelService spcRiskLevelService;

    /**
     * 新增风险等级
     */
    @ApiOperation(httpMethod = "POST", value = "新增风险等级", notes = "新增风险等级")
    @PostMapping(value = "/save", produces = "application/json;charset=UTF-8")
    public CommonResponse saveSpcEvaluateModel(@RequestBody SpcRiskLevel riskLevel) {
    	List<SpcRiskLevel> riskLevels = spcRiskLevelService.queryModelByLevelAndEvaluateId(riskLevel.getLevel(),riskLevel.getEvaluateModelId());
    	Long curId = riskLevel.getId();
    	if(null != curId) {//为编辑时过滤自己
    		riskLevels = riskLevels.stream().filter(e -> e.getId() != curId).collect(Collectors.toList());
    	}
    	if(riskLevels != null && riskLevels.size()>0) {
    		return CommonResponseUtil.failure("风险等级已存在！");
    	}
        riskLevel.setCreatorId(getUserId());
        riskLevel.setUpdateDate(new Date());
        riskLevel = spcRiskLevelService.save(riskLevel);
        return CommonResponseUtil.success(riskLevel);
    }

    /**
     * 删除风险等级
     */
    @ApiOperation(httpMethod = "DELETE", value = "删除风险等级", notes = "删除风险等级")
    @DeleteMapping(value = "/delete/{ids}", produces = "application/json;charset=UTF-8")
    public CommonResponse delete(@PathVariable String ids) {
        String[] idArray = ids.split(",");
        spcRiskLevelService.delete(idArray);
        return CommonResponseUtil.success();
    }


    /**
     * 风险等级列表页面查询
     */
    @ApiOperation(httpMethod = "POST", value = "风险等级列表页面查询", notes = "风险等级列表页面查询")
    @PostMapping(value = "/list", produces = "application/json;charset=UTF-8")
    public CommonResponse queryPage(
            @ApiParam(value = "查询条件")
            @RequestBody(required = false) List<CommonRequest> queryRequests,
            @ApiParam(value = "分页参数", required = true) CommonPageable commonPageable) {
        List<DaoCriteria> criterias = buildDaoCriterias(queryRequests);
        Page<SpcRiskLevel> list = spcRiskLevelService.list(criterias, commonPageable);
        return CommonResponseUtil.success(list);
    }
    

    /**
     * 风险等级列表不分页
     */
    @ApiOperation(httpMethod = "GET", value = "风险等级列表页面查询", notes = "风险等级列表页面查询")
    @GetMapping(value = "/list", produces = "application/json;charset=UTF-8")
    public CommonResponse findAll() {
        List<SpcRiskLevel> list = spcRiskLevelService.findAll();
        return CommonResponseUtil.success(list);
    }
    
    @ApiOperation(httpMethod = "GET", value = "风险等级列表页面查询", notes = "风险等级列表页面查询")
    @GetMapping(value = "/{evModelId}/list", produces = "application/json;charset=UTF-8")
    public CommonResponse findByEvaluateModelId(@PathVariable Long evModelId) {
    	List<SpcRiskLevel> list = spcRiskLevelService.findByEvaluateModelId(evModelId);
    	return CommonResponseUtil.success(list);
    }
    
    @ApiOperation(httpMethod = "GET", value = "风险等级树查询", notes = "风险等级树查询")
    @GetMapping(value = "/tree", produces = "application/json;charset=UTF-8")
    public CommonResponse getRiskLevelTree() {
    	return CommonResponseUtil.success(spcRiskLevelService.getRiskLevelTree());
    }
}
