package com.yeejoin.amos.spc.business.controller;

import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.yeejoin.amos.op.core.common.response.CommonResponse;
import com.yeejoin.amos.op.core.util.CommonResponseUtil;
import com.yeejoin.amos.spc.business.param.PageParam;
import com.yeejoin.amos.spc.business.service.intfc.ISpcRiskListService;
import com.yeejoin.amos.spc.core.common.response.DangerListResponse;
import com.yeejoin.amos.spc.core.util.FileHelper;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@RestController
@RequestMapping(value = "/api/riskList")
@Api(tags = "风险清单相关")
public class SpcRiskListController extends BaseController {

    @Autowired
    private ISpcRiskListService iSpcRiskListService;

    @ApiOperation(value = "风险清单-风险源", notes = "风险清单-风险源")
    @PostMapping(value = "/source/list")
    public CommonResponse listSource(@ApiParam(value = "查询条件", required = true) @RequestBody PageParam pageParam) {
        return iSpcRiskListService.listSource(pageParam);
    }

    @ApiOperation(value = "风险清单-设备", notes = "风险清单-设备")
    @PostMapping(value = "/equipment/list")
    public CommonResponse listEquipment(@ApiParam(value = "查询条件", required = true) @RequestBody PageParam pageParam) {
        return iSpcRiskListService.listSourceEquipments(pageParam);
    }

    @ApiOperation(value = "风险清单-风险因素", notes = "风险清单-风险因素")
    @PostMapping(value = "/factor/list")
    public CommonResponse listFactor(@ApiParam(value = "查询条件", required = true) @RequestBody PageParam pageParam) {
        return iSpcRiskListService.listFactor(pageParam);
    }
    
    @ApiOperation(value = "风险清单-作业活动", notes = "风险清单-设备")
    @PostMapping(value = "/taskwork/list")
    public CommonResponse listTaskwork(@ApiParam(value = "查询条件", required = true) @RequestBody PageParam pageParam) {
        return iSpcRiskListService.listSourceTaskworks(pageParam);
    }
    
    /**
     * 隐患清单
     * @param pageParam
     * @return
     */
    @ApiOperation(value = "隐患清单", notes = "隐患清单")
    @PostMapping(value = "/danger/list")
    public CommonResponse listDanger(@ApiParam(value = "查询条件", required = true) @RequestBody PageParam pageParam) {
    	Page<DangerListResponse> result = iSpcRiskListService.listDanger(pageParam);
    	return CommonResponseUtil.success(result);
    }
    
    /**
     * 导出隐患清单
     * @param pageParam
     * @return
     */
    @ApiOperation(value = "导出隐患清单", notes = "导出隐患清单")
    @RequestMapping(value = "/danger/exportList", method = RequestMethod.POST, produces = "application/vnd.ms-excel;charset=UTF-8")
    public void exportDangerlist(
            @ApiParam(value = "查询条件", required = false) @RequestBody PageParam pageParam,
            HttpServletResponse response) {
    	pageParam.setPageSize(Integer.MAX_VALUE);
    	List<DangerListResponse> list = iSpcRiskListService.danger(pageParam);
        String fileName = "隐患清单" + new Date().getTime();
        FileHelper.exportExcel(list, "隐患清单", "隐患清单", DangerListResponse.class, fileName + ".xls", response);
    }

}
