package com.yeejoin.amos.spc.business.controller;

import com.yeejoin.amos.op.core.common.response.CommonResponse;
import com.yeejoin.amos.op.core.util.CommonResponseUtil;
import com.yeejoin.amos.spc.business.service.intfc.ISpcStatisticsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value = "/api/statistics")
@Api(tags = "统计相关")
public class SpcStatisticsController extends BaseController {

    private final Logger logger = LoggerFactory.getLogger(SpcStatisticsController.class);

    @Autowired
    private ISpcStatisticsService iSpcStatisticsService;

    @ApiOperation(value = "统计风险因素上升率-饼图", notes = "统计风险因素上升率")
    @GetMapping(value = "/pie/riskFactor/riseRate")
    public CommonResponse riskFactorRiseRate() {
        try {
            return iSpcStatisticsService.riskFactorRiseRate();
        } catch (Exception e) {
            logger.error("统计风险因素上升率异常", e);
            return CommonResponseUtil.failure("系统繁忙，请稍后再试");
        }
    }

    @ApiOperation(value = "根据部门统计风险源-柱图", notes = "根据部门统计风险源-柱图")
    @GetMapping(value = "/bar/riskSource/groupByDepartment")
    public CommonResponse riskSourceGroupByDepartment() {
        try {
            return iSpcStatisticsService.riskSourceGroupByDepartment();
        } catch (Exception e) {
            logger.error("根据部门统计风险源异常", e);
            return CommonResponseUtil.failure("系统繁忙，请稍后再试");
        }
    }

    @ApiOperation(value = "根据部门统计隐患-柱图", notes = "根据部门统计隐患-柱图")
    @GetMapping(value = "/bar/latentDanger/groupByDepartment")
    public CommonResponse latentDangerGroupByDepartment() {
        try {
            return iSpcStatisticsService.latentDangerGroupByDepartment();
        } catch (Exception e) {
            logger.error("根据部门统计隐患异常", e);
            return CommonResponseUtil.failure("系统繁忙，请稍后再试");
        }
    }

    @ApiOperation(value = "根据部门统计隐患占比-饼图", notes = "根据部门统计隐患占比-饼图")
    @GetMapping(value = "/pie/latentDanger/rateGroupByDepartment")
    public CommonResponse latentDangerRateGroupByDepartment() {
        try {
            return iSpcStatisticsService.latentDangerRateGroupByDepartment();
        } catch (Exception e) {
            logger.error("根据部门统计风险源异常", e);
            return CommonResponseUtil.failure("系统繁忙，请稍后再试");
        }
    }

    @ApiOperation(value = "巡检计划执行情况列表", notes = "巡检计划执行情况列表")
    @GetMapping(value = "/patrol/plan/list")
    public CommonResponse patrolPlanList(@ApiParam(value = "当前页数", required = true) @RequestParam Integer pageIndex,
                                         @ApiParam(value = "每页条数", required = true) @RequestParam Integer pageSize,
                                         @ApiParam(value = "部门编号") @RequestParam(required = false) String deptId) {
        try {
            return iSpcStatisticsService.patrolPlanList(pageIndex, pageSize, deptId);
        } catch (Exception e) {
            logger.error("巡检计划执行情况列表异常", e);
            return CommonResponseUtil.failure("系统繁忙，请稍后再试");
        }
    }
}