package com.yeejoin.amos.spc.business.dao.repository;

import java.util.List;

import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.yeejoin.amos.spc.dao.entity.SpcMajorHazardInstallation;

@Repository("iSpcMajorHazardInstallationDao")
public interface ISpcMajorHazardInstallationDao extends BaseDao<SpcMajorHazardInstallation, Long> {

	@Modifying
    @Transactional
    @Query(value = "delete from spc_major_hazard_installation where id in (?1)", nativeQuery = true)
	void deleteByIds(List<Long> ids);
	
	@Query(value = "SELECT COUNT(1) FROM spc_major_hazard_installation WHERE risk_level = ?1", nativeQuery = true)
	int countByRiskLevelId(String id);

}
