package com.yeejoin.amos.spc.business.dao.repository;

import java.util.List;

import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.yeejoin.amos.spc.dao.entity.SpcMeasuresContent;

@Repository("iSpcMeasuresContentDao")
public interface ISpcMeasuresContentDao extends BaseDao<SpcMeasuresContent, Long> {

	int countByControlMeasuresId(Long id);

	List<SpcMeasuresContent> findByControlMeasuresId(Long id);
	
	@Modifying
	@Transactional
	@Query(value="delete from spc_measures_content where control_measures_id in (?1)",nativeQuery = true)
	void deleteBatchByIds(String[] ids);

}
