package com.yeejoin.amos.spc.business.dao.repository;

import java.util.List;

import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import com.yeejoin.amos.spc.dao.entity.SpcRiskSource;

@Repository("iSpcRiskSourceDao")
public interface ISpcRiskSourceDao extends BaseDao<SpcRiskSource, Long>{
	
	/**
	 * 根据组织机构编码及名称查询危险源个数
	 * @param orgCode
	 * @param name
	 * @param parentId 
	 * @return
	 */
	public int countByOrgCodeAndNameAndParentId(String orgCode,String name, Long parentId);
	
	/**
	 * 根据组织机构编码及编码查询危险源个数
	 * @param orgCode
	 * @param name
	 * @return
	 */
	public int countByOrgCodeAndCode(String orgCode,String code);
	
	/**
	 * 根据组织编码获取危险源列表
	 * @param orgCode
	 * @return
	 */
	List<SpcRiskSource> findAllByOrgCode(String orgCode);


	/**
	 * 根据父id查询列表
	 * @param parentId
	 * @return
	 */
	List<SpcRiskSource> findByParentId(Long parentId);

	//SpcRiskSource findById(Long id);

	@Query(value = "SELECT COUNT(1) FROM spc_risk_source WHERE identification_method_id = ?1", nativeQuery = true)
	public int countByIdentificationMethodId(Long id);

	public List<SpcRiskSource> findByRiskType(String type);

	public List<SpcRiskSource> findByFloor3d(String Floor3d);

	@Modifying
	@Query(value = "UPDATE r_risk_source SET position3d = ?1 WHERE id = ?2", nativeQuery = true)
	void updatePosition3dById(String position3d, Long id);
}
