package com.yeejoin.amos.spc.business.remote;


import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.typroject.tyboot.core.foundation.context.RequestContext;


/**
 * feign请求header设置
 * @author DELL
 *
 */
@Aspect
@Component
public class FeignAop {


    /**
     * 定义切入点，切入点为com.yeejoin.amos.spc.business.remote.RemoteSecurityService下的所有函数
     */
    @Pointcut("execution(public * com.yeejoin.amos.spc.business.remote.RemoteSecurityService.*(..))"
      + "||execution(public * com.yeejoin.amos.bank.remote.RemoteDeviceService.*(..))"
      + "||execution(public * com.yeejoin.amos.bank.remote.RemoteAlarmTiggerService.*(..))")
    public void webLog(){}

    /**
     * 前置通知：在连接点之前执行的通知
     * @param joinPoint
     * @throws Throwable
     */
    @Before("webLog()")
    public void doBefore(JoinPoint joinPoint) throws Throwable {
        // 接收到请求，记录请求内容
    	System.out.println("开始处理");
        ServletRequestAttributes attributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        String token = request.getHeader("token");
        String product = request.getHeader("product");
        String appKey = request.getHeader("appKey");
    	RequestContext.setToken(token);
    	RequestContext.setProduct(product);
    	RequestContext.setAppKey(appKey);
    }

    @AfterReturning(returning = "ret",pointcut = "webLog()")
    public void doAfterReturning(Object ret) throws Throwable {
        // 处理完请求，返回内容
       System.out.println("处理完毕");
    }
}

