//package com.yeejoin.amos.spc.business.remote;
//
//import java.util.Map;
//
//import org.slf4j.Logger;
//import org.slf4j.LoggerFactory;
//import org.springframework.beans.factory.annotation.Value;
//import org.springframework.stereotype.Service;
//import org.springframework.util.StringUtils;
//
//import com.alibaba.fastjson.JSON;
//import com.alibaba.fastjson.JSONObject;
//import com.google.common.collect.Maps;
//import com.yeejoin.amos.spc.business.constants.FasConstant;
//import com.yeejoin.amos.spc.common.enums.PatrolSynOperationTypeEnum;
//import com.yeejoin.amos.spc.common.enums.PatrolSynUriEnum;
//
//@Service("remotePatrolService")
//public class RemotePatrolService {
//
//    private final Logger logger = LoggerFactory.getLogger(RemotePatrolService.class);
//
//    @Value("${params.patrol.address}")
//    private String address;
//
//    private static final String success = "SUCCESS";
//
//    private String buildUrl(String address, PatrolSynUriEnum patrolSynUriEnum, Map<String, String> map) {
//        String uri = patrolSynUriEnum.getUri();
//        String params = patrolSynUriEnum.getParams();
//        if (!StringUtils.isEmpty(params) && map != null) {
//            String[] paramsArr = params.split(",");
//            for (String param : paramsArr) {
//                uri = uri.replace("{" + param + "}", map.get(param));
//            }
//        }
//        return address + uri;
//    }
//
//    private JSONObject handleResult(String resultStr) {
//        if (resultStr == null) {
//            return null;
//        }
//        JSONObject json = JSON.parseObject(resultStr);
//        if (success.equals(json.getString("result"))) {
//            return json;
//        }
//        return null;
//    }
//
//    public JSONObject synDataToPatrol(PatrolSynUriEnum patrolSynUriEnum, PatrolSynOperationTypeEnum operationType, String body, String token) {
//        Map<String, String> map = Maps.newHashMap();
//        map.put("operationType", operationType.getOperationType());
//        String url = buildUrl(address, patrolSynUriEnum, map);
//        Map<String, String> headerMap = Maps.newHashMap();
//        headerMap.put(FasConstant.TOKEN_KEY, token);
//        String resultStr = HttpUtil.sendHttpPostJsonWithHeader(url, body, headerMap);
//        logger.info("\r\n请求路径=======================>" + url + "\r\n请求参数=======================>" + body + "\r\n返回参数=======================>" + resultStr);
//        return handleResult(resultStr);
//    }
//
//    public JSONObject saveLatentDanger(PatrolSynUriEnum patrolSynUriEnum, String body, String token) {
//        String url = buildUrl(address, patrolSynUriEnum, null);
//        Map<String, String> headerMap = Maps.newHashMap();
//        headerMap.put(FasConstant.TOKEN_KEY, token);
//        String resultStr = HttpUtil.sendHttpPostJsonWithHeader(url, body, headerMap);
//        logger.info("\r\n请求路径=======================>" + url + "\r\n请求参数=======================>" + body + "\r\n返回参数=======================>" + resultStr);
//        return handleResult(resultStr);
//    }
//
//}
