package com.yeejoin.amos.spc.business.remote;

import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.context.RequestContext;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.yeejoin.amos.component.feign.config.InnerInvokException;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.CompanyModel;
import com.yeejoin.amos.feign.privilege.model.DepartmentModel;
import com.yeejoin.amos.feign.systemctl.Systemctl;
import com.yeejoin.amos.feign.systemctl.model.DictionarieValueModel;
import com.yeejoin.amos.op.core.common.response.CommonResponse;

@Service("remoteSecurityService")
public class RemoteSecurityService {
	
    private static final Logger log = org.apache.log4j.Logger.getLogger(RemoteSecurityService.class);

	
    public DepartmentModel getDepartmentByDeptId(String deparmentId) {
    	try {
			DepartmentModel result = Privilege.departmentClient.seleteOne(Long.valueOf(deparmentId)).getResult();
			return result;
		} catch (InnerInvokException e) {
			log.error("getDepartmentByDeptIdf fail " + e.getMessage());
		}
    	return null;
    }

    public List<AgencyUserModel> listUserByRoleIds(String roleIds) {
    	try {
			List<AgencyUserModel> result = Privilege.agencyUserClient.queryByRoleId(roleIds).getResult();
			return result;
		} catch (InnerInvokException e) {
			log.error("listUserByRoleIds fail " + e.getMessage());
		}
    	
    	return null;
    }

    public List<AgencyUserModel> listUserByUserIds(String userIds)  {
    	try {
			List<AgencyUserModel> result = Privilege.agencyUserClient.queryByIds(userIds).getResult();
			return result;
		} catch (InnerInvokException e) {
			log.error("listUserByUserIds fail " + e.getMessage());
		}
    	return null;
    }

    public AgencyUserModel getUserById(String userId)  {
    	try {
			AgencyUserModel result = Privilege.agencyUserClient.queryByUserId(userId).getResult();
			return result;
		} catch (InnerInvokException e) {
			log.error("getUserById fail " + e.getMessage());
		}
    	return null;
    }



    public List<DepartmentModel> getDepartmentTreeByCompanyId(String companyId) {
    	try {
			List<DepartmentModel> result = (List<DepartmentModel>) Privilege.departmentClient.queryDeptTree(null, Long.valueOf(companyId)).getResult();
			return result;
		} catch (NumberFormatException e) {
			log.error("getDepartmentTreeByCompanyId fail " + e.getMessage());
		} catch (InnerInvokException e) {
			log.error("getDepartmentTreeByCompanyId fail " + e.getMessage());
		}
    	return null;
    }
    
    
    
    public List<DepartmentModel> querySubAgencyTree(String departmentid) {
    	try {
			List<DepartmentModel> result = (List<DepartmentModel>) Privilege.departmentClient.querySubAgencyTree( Long.valueOf(departmentid)).getResult();
			return result;
		} catch (NumberFormatException e) {
			log.error("getDepartmentTreeByCompanyId fail " + e.getMessage());
		} catch (InnerInvokException e) {
			log.error("getDepartmentTreeByCompanyId fail " + e.getMessage());
		}
    	return null;
    }
    
    
    
    
    
    
    
    

    public List<DepartmentModel> listDepartmentByDeptIds(String departmentIds)  {
    	try {
			List<DepartmentModel> result = Privilege.departmentClient.queryDeptByIds(departmentIds).getResult();
			return result;
		} catch (InnerInvokException e) {
			log.error("getDepartmentTreeByCompanyId fail " + e.getMessage());
		}
    	
    	return null;
    }

    /**
     * 根据单位id查询单位信息
     * @param id
     * @return
     */
    public CompanyModel getCompanyById(String id) {
    	try {
			CompanyModel result = Privilege.companyClient.seleteOne(Long.valueOf(id)).getResult();
			return result;
		} catch (NumberFormatException e) {
			log.error("getCompanyById fail " + e.getMessage());
		} catch (InnerInvokException e) {
			log.error("getCompanyById fail " + e.getMessage());
		}
    	return null;
    }


    /**
     * 根据单位id查询部门及用户树
     * @param companyId
     * @return
     */
    public Object getUserAndDepartmentTreeByCompanyId(String companyId) {
    	try {
			CompanyModel result = Privilege.companyClient.withDeptAndUsers(Long.valueOf(companyId)).getResult();
			return result;
		} catch (NumberFormatException e) {
			log.error("getUserAndDepartmentTreeByCompanyId fail " + e.getMessage());
		} catch (InnerInvokException e) {
			log.error("InnerInvokException fail " + e.getMessage());
		}
    	return null;
    }
    
    
    /**
     * 根据单位id查询部门及用户树
     * @param companyId
     * @return
     */
    public Object queryByOrgcode(String code) {
    	try {
    		FeignClientResult result = Privilege.companyClient.queryByOrgcode(code);
			return result.getResult();
		} catch (NumberFormatException e) {
			log.error("getUserAndDepartmentTreeByCompanyId fail " + e.getMessage());
		} catch (InnerInvokException e) {
			log.error("InnerInvokException fail " + e.getMessage());
		}
    	return null;
    }
    
    
    
    
    
    
    
    
    

    private <T> List<T> handleArray(CommonResponse commonResponse, Class<T> t) {
        if (commonResponse != null && commonResponse.isSuccess()) {
            String jsonStr = JSON.toJSONString(commonResponse.getDataList());
            return JSONArray.parseArray(jsonStr, t);
        }
        return Lists.newArrayList();
    }

    public List<DictionarieValueModel> getDictValues(String dictCode) {
    	try {
			List<DictionarieValueModel> result = Systemctl.dictionarieClient.dictValues(dictCode).getResult();
			return result;
		} catch (InnerInvokException e) {
			e.printStackTrace();
		}
    	return null;
    }

    public Map getDictValue(String dictCode, String dictDataKey) {
    	try {
			DictionarieValueModel result = Systemctl.dictionarieClient.value(dictCode, dictDataKey).getResult();
			return (Map) result;
		} catch (InnerInvokException e) {
			log.error("getDictValue fail " + e.getMessage());
		}
    	return null;
    }

    private <T> T handleObj(CommonResponse commonResponse, Class<T> t) {
        if (commonResponse != null && commonResponse.isSuccess()) {
            String jsonStr = JSON.toJSONString(commonResponse.getDataList());
            return JSONObject.parseObject(jsonStr, t);
        }
        return null;
    }
    
    public AgencyUserModel getUser() throws InnerInvokException {
    	AgencyUserModel result = Privilege.agencyUserClient.getme().getResult();
    	return  result;
    }
    
    
    //查询指定部门数
    public List<DepartmentModel> listDepartmentsByCompanyId(Long companyId) {
        if (companyId == null || companyId.equals("")) {
            return null;
        }     
    	 List<DepartmentModel> departmentModel=null;
    	FeignClientResult feignClientResult;
		try {
			feignClientResult = Privilege.departmentClient.queryDeptTree(null,companyId);
			departmentModel = ( List<DepartmentModel>) feignClientResult.getResult();

		} catch (InnerInvokException e) {
			e.printStackTrace();
		}
        return departmentModel;
      
    }
    
    
    
    
    
    
    
    
    
	public List<DictionarieValueModel> listDictionaryByDictCode(String dictCode) {
		List<DictionarieValueModel> dictionarieModel = null;
		try {
			dictionarieModel = Systemctl.dictionarieClient.dictValues(dictCode).getResult();
		} catch (InnerInvokException e) {
			log.error("listDictionaryByDictCode fail " + e.getMessage());
		}
		return dictionarieModel;
	}

}
