package com.yeejoin.amos.spc.business.service.impl;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.google.common.base.Joiner;
import com.yeejoin.amos.op.core.common.query.DaoCriteria;
import com.yeejoin.amos.spc.business.dao.repository.ISpcCameraDao;
import com.yeejoin.amos.spc.business.dao.repository.ISpcEquipmentCameraBindDao;
import com.yeejoin.amos.spc.business.service.intfc.ISpcCameraService;
import com.yeejoin.amos.spc.common.enums.CamerasEnum;
import com.yeejoin.amos.spc.core.common.request.CommonPageable;
import com.yeejoin.amos.spc.core.util.query.BaseQuerySpecification;
import com.yeejoin.amos.spc.dao.entity.SpcCameras;
import com.yeejoin.amos.spc.dao.entity.SpcEquipmentCameraBind;
import com.yeejoin.amos.spc.exception.YeeException;

@Service("iCameraService")
public class SpcCameraServiceImpl implements ISpcCameraService {

    @Autowired
    ISpcCameraDao iSpcCameraDao;

    @Autowired
    ISpcEquipmentCameraBindDao iSpcEquipmentCameraBindDao;

    @Override
    public Page<SpcCameras> queryCameraByPage(List<DaoCriteria> criterias, CommonPageable commonPageable) {
        BaseQuerySpecification<SpcCameras> spec = new BaseQuerySpecification<>(criterias);
        Page<SpcCameras> cameraPage = iSpcCameraDao.findAll(spec, commonPageable);
        cameraPage.getContent().forEach(action -> {
            action.setType(CamerasEnum.getEnumName(action.getType()));
        });
        return cameraPage;
    }

    @Override
    public SpcCameras saveCamera(SpcCameras cameraParam) {
        return iSpcCameraDao.save(cameraParam);
    }


    @Transactional
    @Override
    public List<String> deleteCameraById(List<Long> ids) {
        // 绑定到设备设施中的摄像头不允许删除
        List<String> cameraNameList = new ArrayList<>();//在使用中的摄像头名称
        List<Long> removedIds = new ArrayList<>();
        for (Long id : ids) {
        	SpcEquipmentCameraBind ecBind = iSpcEquipmentCameraBindDao.findByCameraId(id);
        	if (null != ecBind) {
        		SpcCameras camera = iSpcCameraDao.findById(ecBind.getCameraId()).get();
        		cameraNameList.add(camera.getName());
        		removedIds.add(id);
        	}
        }
        ids.removeAll(removedIds);
        if (null != ids && ids.size() > 0) {
        	iSpcCameraDao.deleteBatchByIds(ids);//可删除摄像头ID
        }
        if (cameraNameList.size() > 0) {
        	throw new YeeException("摄像头【" + Joiner.on(",").join(cameraNameList) + "】正在使用中，删除失败！");
        }
        return cameraNameList;
    }

}
