package com.yeejoin.amos.spc.business.service.impl;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.feign.systemctl.model.DictionarieValueModel;
import com.yeejoin.amos.op.core.common.query.DaoCriteria;
import com.yeejoin.amos.spc.business.dao.repository.ISpcControlMeasureDao;
import com.yeejoin.amos.spc.business.dao.repository.ISpcMeasuresContentDao;
import com.yeejoin.amos.spc.business.dao.repository.ISpcRiskFactorsCmDao;
import com.yeejoin.amos.spc.business.remote.RemoteSecurityService;
import com.yeejoin.amos.spc.business.service.intfc.ISpcControlMeasureService;
import com.yeejoin.amos.spc.business.service.intfc.ISpcMeasureContentService;
import com.yeejoin.amos.spc.common.enums.DictTypeEnum;
import com.yeejoin.amos.spc.core.common.request.CommonPageable;
import com.yeejoin.amos.spc.core.util.query.BaseQuerySpecification;
import com.yeejoin.amos.spc.dao.entity.SpcControlMeasure;
import com.yeejoin.amos.spc.dao.entity.SpcMeasuresContent;
import com.yeejoin.amos.spc.exception.YeeException;

@Service("spcControlMeasureService")
public class SpcControlMeasureServiceImpl implements ISpcControlMeasureService {

    @Autowired
    private ISpcControlMeasureDao iSpcControlMeasureDao;
    
    @Autowired
    private ISpcMeasuresContentDao iSpcMeasuresContentDao;
    
//    @Autowired
//    private RemotePatrolService remotePatrolService;
    
    @Autowired
    private ISpcMeasureContentService iSpcMeasureContentService;
    
    @Autowired
    private ISpcRiskFactorsCmDao iSpcRiskFactorCmDao;

    @Autowired
    private RemoteSecurityService remoteSecurityService;

    @Override
    public Page<SpcControlMeasure> queryEntryByCondition(List<DaoCriteria> criterias, CommonPageable commonPageable) {
        BaseQuerySpecification<SpcControlMeasure> specification = new BaseQuerySpecification<>(criterias);
        Sort sort = new Sort(Sort.Direction.DESC,"id");
        commonPageable.setSort(sort);
        Page<SpcControlMeasure> list = iSpcControlMeasureDao.findAll(specification, commonPageable);
        List<DictionarieValueModel> types = remoteSecurityService.getDictValues(DictTypeEnum.controlMeasuresType.getCode());
        List<DictionarieValueModel> categorys = remoteSecurityService.getDictValues(DictTypeEnum.controlMeasuresCategory.getCode());
        Map<String, String> typeMap = dictValue(types);
        Map<String, String> categoryMap = dictValue(categorys);
        list.getContent().forEach(SpcControlMeasure -> {
            SpcControlMeasure.setCategory(categoryMap.get(SpcControlMeasure.getCategory()));
            SpcControlMeasure.setType(typeMap.get(SpcControlMeasure.getType()));
            int num = iSpcMeasuresContentDao.countByControlMeasuresId(SpcControlMeasure.getId());
            SpcControlMeasure.setMeasureNum(num);
        });
        return list;
    }

    private Map<String, String> dictValue(List<DictionarieValueModel> date) {
        Map<String, String> dictMap = date.stream().collect(Collectors.toMap(DictionarieValueModel::getDictDataKey, DictionarieValueModel::getDictDataValue));
        return dictMap;
    }

    @Override
    public SpcControlMeasure getDetailById(Long id) {
        SpcControlMeasure measure = iSpcControlMeasureDao.findById(id).get();
        List<SpcMeasuresContent> detailCxt = iSpcMeasuresContentDao.findByControlMeasuresId(id);
        if (measure != null) {
            measure.setDetailCxt(detailCxt);
        }
        return measure;
    }

    @Transactional
    @Override
    public void saveEntry(SpcControlMeasure entry, String token) {
        SpcControlMeasure measure = iSpcControlMeasureDao.saveAndFlush(entry);
        List<SpcMeasuresContent> cxtList = entry.getDetailCxt();
        for (SpcMeasuresContent spcMeasuresContent : cxtList) {
            if (spcMeasuresContent.getIsDelete() != null && spcMeasuresContent.getIsDelete()) {
                iSpcMeasuresContentDao.delete(spcMeasuresContent);
            } else {
                spcMeasuresContent.setControlMeasuresId(measure.getId());
                iSpcMeasuresContentDao.save(spcMeasuresContent);
//                String body = buildItemRequest(spcMeasuresContent);
//                JSONObject json = remotePatrolService.synDataToPatrol(PatrolSynUriEnum.同步巡检项, PatrolSynOperationTypeEnum.新增, body, token);
//                if (json == null) {
//                    TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
//                    throw new YeeException("风险源同步失败");
//                }
            }
        }
    }

    private String buildItemRequest(SpcMeasuresContent content) {
        JSONObject json = new JSONObject();
        json.put("basisJson", content.getBasis());
        json.put("itemName", content.getContent());
        json.put("itemType", "选择");
        json.put("originalId", content.getId());
        return json.toJSONString();
    }

    @Override
    public void delEntryById(String[] ids) {
//        iSpcMeasuresContentDao.deleteBatchByIds(ids);
    	if (null != ids && ids.length > 0) {
    		//先尝试删除管控措施的内容，删除成功再删除管控措施
    		Long count = 0l;
    		for (String id : ids) {
    			List<SpcMeasuresContent> mcList = iSpcMeasuresContentDao.findByControlMeasuresId(Long.valueOf(id));
    			for (SpcMeasuresContent mc : mcList) {    				
    				iSpcMeasureContentService.deleteMeasureContentById(mc.getId());
    			}
    		}
    		count = iSpcRiskFactorCmDao.countByControlMeasureId(ids);
    		if (count > 0) {
    			throw new YeeException("控制措施正在使用，刪除失敗！");
    		}
    		iSpcControlMeasureDao.deleteBatchByIds(ids);
    	}
    }

	@Override
	public List<SpcControlMeasure> queryControlMeasureByName(String name) {
		return iSpcControlMeasureDao.findByName(name);
	}

}
