package com.yeejoin.amos.spc.business.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

import com.yeejoin.amos.spc.business.dao.repository.*;
import com.yeejoin.amos.spc.dao.entity.*;
import org.assertj.core.util.Sets;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Sort;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.util.CollectionUtils;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.op.core.common.query.DaoCriteria;
import com.yeejoin.amos.spc.bo.RiskSourceBo;
import com.yeejoin.amos.spc.business.constants.FasConstant;
import com.yeejoin.amos.spc.business.dao.mapper.RiskFactorMapper;
import com.yeejoin.amos.spc.business.dao.mapper.RiskSourceMapper;
import com.yeejoin.amos.spc.business.dao.mapper.View3DMapper;
import com.yeejoin.amos.spc.business.feign.RemoteRuleServer;
import com.yeejoin.amos.spc.business.param.CommonPageInfoParam;
import com.yeejoin.amos.spc.business.remote.RemoteSecurityService;
import com.yeejoin.amos.spc.business.remote.RemoteWebSocketServer;
import com.yeejoin.amos.spc.business.service.intfc.ISpcRiskSourceService;
import com.yeejoin.amos.spc.business.service.model.ContingencyRo;
import com.yeejoin.amos.spc.common.enums.RiskFactorsStatusEnum;
import com.yeejoin.amos.spc.common.enums.RiskSourceTypeEnum;
import com.yeejoin.amos.spc.core.common.request.CommonPageable;
import com.yeejoin.amos.spc.core.common.request.RiskFactorAddRequest;
import com.yeejoin.amos.spc.core.util.StringUtil;
import com.yeejoin.amos.spc.core.util.query.BaseQuerySpecification;
import com.yeejoin.amos.spc.exception.YeeException;

@Service("spcRiskSourceService")
public class SpcRiskSourceServiceImpl implements ISpcRiskSourceService {

    @Autowired
    private ISpcRiskSourceDao iSpcRiskSourceDao;

    @Autowired
    private IRRiskSourceDao irRiskSourceDao;

    @Autowired
    private ISpcRiskFactorDao iSpcRiskFactorDao;

    @Autowired
    private RiskFactorMapper riskFactorMapper;

//    @Autowired
//    private RemotePatrolService remotePatrolService;

    @Autowired
    private ISpcEquipmentDao iSpcEquipmentDao;

    @Autowired
    private ISpcTaskworkDao iSpcTaskworkDao;

    @Autowired
    private ISpcTaskworkContentDao iSpcTaskworkContentDao;

    @Autowired
    private RemoteSecurityService remoteSecurityService;

    @Autowired
    private ISpcIdentificationMethodDao iIdentificationMethodDao;

    @Autowired
    private ISpcRiskLevelDao iSpcRiskLevelDao;

    @Autowired
    private RiskSourceMapper riskSourceMapper;
    
    @Autowired
    private RemoteWebSocketServer remoteWebSocketServer;


    @Autowired
    IContingencyOriginalDataDao iContingencyOriginalDataDao;

	@Autowired
	private View3DMapper view3DMapper;

    @Autowired
    private RemoteRuleServer remoteRuleServer;




    @Transactional
    @Override
    public SpcRiskSource save(SpcRiskSource spcRiskSource, String token) {
    	Long parentId = spcRiskSource.getParentId();
        int codeCount = iSpcRiskSourceDao.countByOrgCodeAndCode(spcRiskSource.getOrgCode(), spcRiskSource.getCode());
        int nameCount = iSpcRiskSourceDao.countByOrgCodeAndNameAndParentId(spcRiskSource.getOrgCode(), spcRiskSource.getName(),parentId);
        String message = "";
        if (StringUtil.isNotEmpty(spcRiskSource.getId())) {//编辑
            if (StringUtil.isNotEmpty(spcRiskSource.getCode()) && codeCount > 1) {
                message = "编码已存在，请核实后再添加！";
            }
            if (nameCount > 1) {
                message = "名称已存在，请核实后再添加！";
            }
        } else {
            if (StringUtil.isNotEmpty(spcRiskSource.getCode()) && codeCount > 0) {
                message = "编码已存在，请核实后再添加！";
            }
            if (nameCount > 0) {
                message = "名称已存在，请核实后再添加！";
            }
        }
        if (StringUtil.isNotEmpty(message)) {
            throw new YeeException(message);
        } else {
            JSONObject json = null;
            Boolean isSyn = false;
            iSpcRiskSourceDao.save(spcRiskSource);
//            if (StringUtils.isEmpty(spcRiskSource.getId())) {
//                spcRiskSource.setIsDanger(false);
//                iSpcRiskSourceDao.save(spcRiskSource);
//                if(RiskSourceTypeEnum.risk.getCode().equals(spcRiskSource.getRiskType())){      	
//                	isSyn = true;
//                	String body = buildPointRequest(spcRiskSource);
//                	json = remotePatrolService.synDataToPatrol(PatrolSynUriEnum.同步巡检点, PatrolSynOperationTypeEnum.新增, body, token);
//                }
//                remoteWebSocketServer.wsDataRefresh("riskSource");
//            } else {
//                iSpcRiskSourceDao.save(spcRiskSource);
//                if(RiskSourceTypeEnum.risk.getCode().equals(spcRiskSource.getRiskType())){
//                	isSyn = true;
//                	String body = buildPointRequest(spcRiskSource);
//                	json = remotePatrolService.synDataToPatrol(PatrolSynUriEnum.同步巡检点, PatrolSynOperationTypeEnum.修改, body, token);
//                }
//            }
            if (isSyn && json == null) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                throw new YeeException("风险源同步失败");
            }
        }
        return spcRiskSource;
    }

    private String buildPointRequest(SpcRiskSource spcRiskSource) {
        JSONObject jsonObject = new JSONObject();
        String strPosition3d = spcRiskSource.getPosition3d();
        jsonObject.put("coordinates", strPosition3d);
        jsonObject.put("pointNo", spcRiskSource.getCode());
        if (spcRiskSource.getRiskLevel() != null) {
            SpcRiskLevel riskLevel = iSpcRiskLevelDao.getOne(spcRiskSource.getRiskLevel());
            if (riskLevel != null) {
                jsonObject.put("level", riskLevel.getLevel());
            }
        }
        jsonObject.put("chargePersonId", spcRiskSource.getUserId());
        jsonObject.put("originalId", spcRiskSource.getId());
        jsonObject.put("pointName", spcRiskSource.getName());
        return jsonObject.toJSONString();
    }

    @Override
    public List<SpcRiskSource> list(String orgCode) {
        return iSpcRiskSourceDao.findAllByOrgCode(orgCode);
    }

    @Override
    public void delete(String[] ids) {
        if (ids.length > 0) {
            for (String id : ids) {
                Long riskSourceId = Long.valueOf(id);
                if (iSpcRiskSourceDao.existsById(riskSourceId)) {
                    int riskFactorCount = iSpcRiskFactorDao.countByRiskSourceId(riskSourceId);
                    if (riskFactorCount > 0) {
                        throw new YeeException("该风险点正在使用，无法删除！");
                    } else {
                        iSpcRiskSourceDao.deleteById(riskSourceId);
                        remoteWebSocketServer.wsDataRefresh("riskSource");
                    }
                }
            }
        } else {
            throw new YeeException("请选择需要删除的数据！");
        }

    }

    @Override
    public SpcRiskSource getRiskSourceDetailsById(Long id) {
        return iSpcRiskSourceDao.findById(id).get();
    }

    @Override
    public Boolean isExistFactorByName(Long riskSourceId, String name) {
        int count = iSpcRiskFactorDao.countByRiskSourceIdAndName(riskSourceId, name);
        return count > 0;
    }

    @Override
    public void saveRiskFactor(RiskFactorAddRequest riskFactors) {
        Long riskSourceId = riskFactors.getRiskSourceId();
        Long riskFactorId = riskFactors.getId();
        if (StringUtil.isNotEmpty(riskFactorId)) {
            String name = riskFactors.getNames().get(0);
            SpcRiskFactor rf = iSpcRiskFactorDao.findByRiskSourceIdAndName(riskSourceId, name);
            if (rf != null && rf.getId() != riskFactorId) {
                throw new YeeException("危险因素名称重复，请重新填写！");
            }
            SpcRiskFactor riskFactor = iSpcRiskFactorDao.findById(riskFactorId).get();
            riskFactor.setName(name);
            riskFactor.setUserIds(riskFactors.getUserIds());
            riskFactor.setUserNames(riskFactors.getUserNames());
            riskFactor.setIdentificationMethodIds(riskFactors.getIdentificationMethodIds());
            riskFactor.setIdentificationMethodNames(riskFactors.getIdentificationMethodNames());
            riskFactor.setCreatorId(riskFactors.getCreatorId());
            riskFactor.setType(riskFactors.getType());
            iSpcRiskFactorDao.save(riskFactor);
        } else {
            List<String> names = riskFactors.getNames();
            List<SpcRiskFactor> list = new ArrayList<>();
            for (String name : names) {
                int count = iSpcRiskFactorDao.countByRiskSourceIdAndName(riskSourceId, name);
                if (count > 0) {
                    throw new YeeException("【" + name + "】重复，请重新填写！");
                }
                SpcRiskFactor riskFactor = new SpcRiskFactor();
                riskFactor.setName(name);
                riskFactor.setType(riskFactors.getType());
                riskFactor.setUserIds(riskFactors.getUserIds());
                riskFactor.setUserNames(riskFactors.getUserNames());
                riskFactor.setIdentificationMethodIds(riskFactors.getIdentificationMethodIds());
                riskFactor.setIdentificationMethodNames(riskFactors.getIdentificationMethodNames());
                riskFactor.setRiskSourceId(riskFactors.getRiskSourceId());
                riskFactor.setCreatorId(riskFactors.getCreatorId());
                list.add(riskFactor);
            }
            iSpcRiskFactorDao.saveAll(list);
        }
    }

    @Override
    public Page<HashMap<String, Object>> queryRiskFactorByPage(CommonPageInfoParam param) {
        long total = riskFactorMapper.countPageData(param);
        List<HashMap<String, Object>> content = riskFactorMapper.queryRiskFactorPage(param);
        return new PageImpl<>(content, param, total);
    }

    @Override
    public HashMap<String, Object> queryControlObjectDetailById(Long riskFactorId) {
        HashMap<String, Object> result = null;
        SpcRiskFactor riskFactor = iSpcRiskFactorDao.findById(riskFactorId).get();
        String type = riskFactor.getType(); //作业活动或设备设施
        Long controlObjectId = riskFactor.getControlObjectId();
        if (type.equals(FasConstant.CONTROL_OBJECT_EQUIPMENT)) {
            SpcEquipment equipment = iSpcEquipmentDao.findById(controlObjectId).get();
            if (equipment != null) {
                result = new HashMap<>();
                result.put("name", riskFactor.getName());
                result.put("regionId", equipment.getRegionId());
                result.put("departmentId", equipment.getDepartmentId());
                result.put("workshopSection", equipment.getWorkshopSection());
                result.put("controlObjectId", equipment.getId());
                result.put("code", equipment.getCode());
            }
        } else if (type.equals(FasConstant.CONTROL_OBJECT_TASKWORK)) {
            SpcTaskwork taskwork = iSpcTaskworkDao.findById(controlObjectId).get();
            List<SpcTaskworkContent> taskContentList = iSpcTaskworkContentDao.findAllByTaskworkId(controlObjectId);
            if (taskwork != null) {
                result = new HashMap<>();
                result.put("name", riskFactor.getName());
                result.put("regionId", taskwork.getRegionId());
                result.put("departmentId", taskwork.getDepartmentId());
                result.put("groupId", taskwork.getGroupId());
                result.put("controlObjectId", taskwork.getName());
                result.put("post", taskwork.getPost());
                result.put("part", taskwork.getPart());
                result.put("content", taskContentList);
            }
        }
        return result;
    }

    @Override
    public void deleteRiskFactor(String[] ids) {
        if (ids.length > 0) {
        	List<SpcRiskFactor> deleteRiskFactors = new ArrayList<>();
        	List<SpcRiskFactor> useRiskFactors = new ArrayList<>();
            for (String id : ids) {
                Long riskFactorId = Long.valueOf(id);
                if (iSpcRiskFactorDao.existsById(riskFactorId)) {
                	SpcRiskFactor riskFactor = iSpcRiskFactorDao.findById(riskFactorId).get();
                    if (RiskFactorsStatusEnum.notStarted.getCode().equals(riskFactor.getStatus())) {
                    	deleteRiskFactors.add(riskFactor);
                    } else {
                    	useRiskFactors.add(riskFactor);
                    }
                }
            }
            if(deleteRiskFactors.size()>0){
                iSpcRiskFactorDao.deleteAll(deleteRiskFactors);
            }
            if(useRiskFactors.size()>0){
            	throw new YeeException("风险因素正在使用，无法删除！");
            }
        } else {
            throw new YeeException("请选择需要删除的数据！");
        }

    }

    @Override
    public List<HashMap<String, Object>> queryControlMeasureDetailByRiskFactorId(Long riskFactorId, Long evaluateId) {
        // TODO Auto-generated method stub
        return riskFactorMapper.queryControlMeasureDetailByRiskFactorIdAndEvaluateId(riskFactorId, evaluateId);
    }

    @Override
    public Page<HashMap<String, Object>> listRegion(CommonPageInfoParam commonPageInfoParam) {
        return null;
    }

    @Override
    public Page<SpcRiskSource> querySpcRiskSourceByPage(List<DaoCriteria> criterias, CommonPageable commonPageable) {
        BaseQuerySpecification<SpcRiskSource> specification = new BaseQuerySpecification<>(criterias);
        Sort sort = new Sort(Sort.Direction.DESC,"id");
        commonPageable.setSort(sort);
        Page<SpcRiskSource> page = iSpcRiskSourceDao.findAll(specification, commonPageable);
        List<SpcRiskSource> list = page.getContent();
        List<SpcIdentificationMethod> idMethodList = iIdentificationMethodDao.findAll();
        Map<Long, String> idMethodMap = idMethodList.stream().collect(Collectors.toMap(SpcIdentificationMethod::getId, SpcIdentificationMethod::getName));
        if (!CollectionUtils.isEmpty(list)) {
            Set<String> userIdSets = Sets.newHashSet();
            list.forEach(e -> {
                userIdSets.add(e.getUserId());
                userIdSets.add(e.getCreatorId());
            });
            userIdSets.removeAll(Collections.singleton(null));
            List<AgencyUserModel> AgencyUserModels = remoteSecurityService.listUserByUserIds(Joiner.on(",").join(userIdSets));
            Map<String, AgencyUserModel> AgencyUserModelMap = Maps.uniqueIndex(AgencyUserModels, AgencyUserModel::getUserId);
            list.forEach(e -> {
                AgencyUserModel AgencyUserModel = AgencyUserModelMap.get(e.getUserId());
                AgencyUserModel createAgencyUserModel = AgencyUserModelMap.get(e.getCreatorId());
                if (AgencyUserModel != null) {
                    e.setUsername(AgencyUserModel.getRealName());
                }
                if (createAgencyUserModel != null) {
                    e.setCreateUserName(createAgencyUserModel.getRealName());
                }
                e.setRiskType(RiskSourceTypeEnum.getEnumName(e.getRiskType()));
                if (idMethodMap.containsKey(e.getIdentificationMethodId())) {
                    e.setIdentificationMethodName(idMethodMap.get(e.getIdentificationMethodId()));
                }
            });
        }
        return page;
    }

    @Override
    public List<RiskSourceBo> listAll(String orgCode) {
        Map<String, Object> paramsMap = new HashMap<>();
        paramsMap.put("orgCode", orgCode);
        List<RiskSourceBo> riskSourceList = riskSourceMapper.listByCondition(paramsMap);
        return riskSourceList;
    }

    @Override
    public RiskSourceBo getRiskSourceBoDetailById(Long id) {
        Map<String, Object> paramsMap = new HashMap<>();
        paramsMap.put("id", id);
        List<RiskSourceBo> list = riskSourceMapper.listByCondition(paramsMap);
        if (list.size() > 0) {        	
        	RiskSourceBo riskSourceBo = list.get(0);
        	return riskSourceBo;
        }
        return null;
    }

	@Override
    public List<SpcRiskSource> getRiskSourceByType(String type) {
        List<SpcRiskSource> list = iSpcRiskSourceDao.findByRiskType(type);
        return list;
    }

    @Override
    public List<RRiskSource> getRiskSourceByFloor(String floor, String orgCode) {
        List<RRiskSource> list = irRiskSourceDao.findByFloor3d(floor, orgCode);
        return list;
    }

    /**
     * 更新风险点三维坐标
     *
     * @param spcRiskSource
     */
    @Override
    @Transactional
    public void updatePosition3dById(SpcRiskSource spcRiskSource) {
        if (spcRiskSource == null) {
            throw new YeeException("参数不能为空！");
        }
        if (spcRiskSource.getId() != null && StringUtil.isNotEmpty(spcRiskSource.getPosition3d())) {
            iSpcRiskSourceDao.updatePosition3dById(spcRiskSource.getPosition3d(), spcRiskSource.getId());
        }
    }

    @Async
    @SuppressWarnings("unchecked")
    public String  processFireEqumtData(String equipId) throws Exception
    {
        String batchNo = UUID.randomUUID().toString();

		Map<String, Object> fireEquipment = view3DMapper.queryForEquipPositionById(equipId);
		if (fireEquipment != null)
		{
			alermContingency(batchNo, fireEquipment);
			return "SUCCESS";
		}

        return "设备不存在！";
    }


    public void alermContingency(String batchNo, Map<String, Object> fireEquipment) throws Exception
    {
        ContingencyRo contingencyRo = new ContingencyRo();
		/**
		 * start 预案业务数据，交大模型点数据
		 */
        contingencyRo.setEquipmentId(fireEquipment.get("equippositioninfoid") != null? fireEquipment.get("equippositioninfoid").toString() : "");
        contingencyRo.setEquipmentName(fireEquipment.get("equipname") != null? fireEquipment.get("equipname").toString() : "");
        contingencyRo.setEquippositionnum(fireEquipment.get("equippositionnum") != null? fireEquipment.get("equippositionnum").toString() : "");
        contingencyRo.setArea(fireEquipment.get("area") != null? fireEquipment.get("area").toString() : "");
        contingencyRo.setDept(fireEquipment.get("dept") != null? fireEquipment.get("dept").toString() : "");
        contingencyRo.setSection(fireEquipment.get("section") != null? fireEquipment.get("section").toString() : "");
        contingencyRo.setEquipmentDesc(fireEquipment.get("remark") != null? fireEquipment.get("remark").toString() : "");
        contingencyRo.setX(fireEquipment.get("x") != null? fireEquipment.get("x").toString() : "");
        contingencyRo.setY(fireEquipment.get("y") != null? fireEquipment.get("y").toString() : "");
        contingencyRo.setZ(fireEquipment.get("z") != null? fireEquipment.get("z").toString() : "");
		/**
		 * end
		 */
        contingencyRo.setBatchNo(batchNo);
        contingencyRo.setStep("0");
        contingencyRo.setConfirm("NONE");
        contingencyRo.setRunstep(false);

        //执行预案规则
        remoteRuleServer.fireRuleFlow(contingencyRo,"专项预案/converter1","压缩机组超速");

        ContingencyOriginalData contingencyOriginalData = new ContingencyOriginalData();
        BeanUtils.copyProperties(contingencyRo,contingencyOriginalData);
        iContingencyOriginalDataDao.save(contingencyOriginalData);
    }
}
