package com.yeejoin.amos.spc.business.service.intfc;

import java.util.List;
import java.util.Map;

import org.springframework.data.domain.Page;

import com.yeejoin.amos.op.core.common.query.DaoCriteria;
import com.yeejoin.amos.spc.bo.EvaluateModelBo;
import com.yeejoin.amos.spc.core.common.request.CommonPageable;
import com.yeejoin.amos.spc.dao.entity.SpcRiskLevel;

public interface ISpcRiskLevelService {
	
	/**
	 * 新增接口
	 * @param SpcRiskLevel
	 * @return
	 */
	public SpcRiskLevel save(SpcRiskLevel spcEvaluateModel);
	
	/**
	 * 删除
	 * @param ids
	 */
	public void delete(String [] ids);
	
	public Page<SpcRiskLevel> list(List<DaoCriteria> criterias,CommonPageable commonPageable);
	
	List<SpcRiskLevel>  findAll();
	
	/**
	 * 根据模型ID获取模型下的等级列表
	 * @param evModelId	模型ID
	 * @return	等级列表
	 */
	List<SpcRiskLevel> findByEvaluateModelId(Long evModelId);

	public List<EvaluateModelBo> getRiskLevelTree();
	
	/**
	 * 根据等级和evaluateModelId 查询
	 * @param level
	 * @param evaluateModelId
	 * @return
	 */
	public List<SpcRiskLevel> queryModelByLevelAndEvaluateId(String level, Long evaluateModelId);
	
}
