package com.yeejoin.amos.spc.framework;

import java.io.File;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

import com.yeejoin.amos.spc.business.constants.FasConstant;;

@Configuration
public class FasApplicationConfig extends WebMvcConfigurerAdapter{
	
	@Value("${windows.img.path}")
	private String winImgPath;
	@Value("${linux.img.path}")
	private String linuxImgPath;
	
    @Override
    public void addResourceHandlers(ResourceHandlerRegistry registry) {
    	String localPath = "";
    	if ("\\".equals(File.separator)) {
    		localPath += winImgPath;
    	} else if ("/".equals(File.separator)) {
    		localPath += linuxImgPath;
    	}    	
        registry.addResourceHandler("/upload/**").addResourceLocations("file:"+localPath.trim()+FasConstant.UPLOAD_ROOT_PATH + File.separator);
//        registry.addResourceHandler("/upload/video/**").addResourceLocations("file:G:/upload/video/");
        super.addResourceHandlers(registry);
    }
}
