package com.yeejoin.amos;

import java.io.IOException;
import java.net.URISyntaxException;

import org.apache.log4j.Logger;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.eureka.EnableEurekaClient;
import org.springframework.cloud.netflix.hystrix.EnableHystrix;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.env.Environment;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.transaction.annotation.EnableTransactionManagement;

import com.yeejoin.amos.bank.webSocket.AlarmWebSocketClient;
import com.yeejoin.amos.bank.webSocket.FireDetectionWebSocketClient;
import com.yeejoin.amos.bank.webSocket.InspectionWebSocketClient;
import com.yeejoin.amos.bank.webSocket.MonitorAlarmWebSocketClient;
import com.yeejoin.amos.bank.webSocket.ShiduAlarmWebSocketClient;

import springfox.documentation.swagger2.annotations.EnableSwagger2;

/**
 * <pre>
 *  服务启动类
 * </pre>
 *
 * @author amos
 * @version $Id: AmosOPStart.java, v 0.1 2018年11月26日 下午4:56:29 amos Exp $
 */
@SpringBootApplication
@EnableTransactionManagement
@EnableConfigurationProperties
@EnableSwagger2
@EnableAsync
@ServletComponentScan
@EnableDiscoveryClient
@EnableHystrix
@EnableFeignClients
@EnableEurekaClient
// @Configuration
// @EnableApolloConfig
@EnableJpaAuditing
@EnableScheduling
@MapperScan(basePackages = {"com.yeejoin.amos.spc.business.dao.mapper", "com.yeejoin.amos.bank.dao.mapper"})
@ComponentScan({"org.typroject", "com.yeejoin.amos", "com.yeejoin.amos.bank"})
public class AmosBankStart {

    private static final Logger log = Logger.getLogger(AmosBankStart.class);

    /**
     * 启动amosop-server
     *
     * @param args
     * @throws IOException
     * @throws URISyntaxException
     */
    public static void main(String[] args) {
        log.info("start xian bank Service..........");
        try {
            SpringApplication application = new SpringApplication(AmosBankStart.class);
            ConfigurableApplicationContext run = application.run(args);
            //websocketClinet 设置application
            AlarmWebSocketClient.setAllpicationContext(run);
            MonitorAlarmWebSocketClient.setAllpicationContext(run);
            ShiduAlarmWebSocketClient.setAllpicationContext(run);
            InspectionWebSocketClient.setAllpicationContext(run);
            FireDetectionWebSocketClient.setAllpicationContext(run);
            Environment environment = run.getEnvironment();
            log.info("SwaggerUI: 	http://localhost:"
                    + environment.getProperty("server.port") + "/swagger-ui.html");

            log.info("动环告警websocket监听");
            MonitorAlarmWebSocketClient.synMonitorAlarmPoint();
            log.info("湿度告警websocket监听");
            ShiduAlarmWebSocketClient.synMonitorAlarmPoint();
            log.info("设备告警websocket监听");
            AlarmWebSocketClient.synAlarmPoint();
            log.info("自动巡检websocket监听");
            InspectionWebSocketClient.synInspectionAlarm();
            log.info("火探websocket监听");
            FireDetectionWebSocketClient.synFireDetection();
        } catch (Exception e) {
            System.out.println("error xian bank occur when run server! " + e);
        }
    }
}