/*
Navicat MySQL Data Transfer

Source Server         : 172.16.10.99
Source Server Version : 50717
Source Host           : 172.16.10.99:3306
Source Database       : amos_spc_new

Target Server Type    : MYSQL
Target Server Version : 50717
File Encoding         : 65001

Date: 2019-10-21 10:18:06
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for spc_aftermath
-- ----------------------------
DROP TABLE IF EXISTS `spc_aftermath`;
CREATE TABLE `spc_aftermath` (
  `id` bigint(19) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL COMMENT '名称',
  `creator_id` varchar(255) NOT NULL,
  `org_code` varchar(255) NOT NULL COMMENT '组织编码',
  `create_date` datetime NOT NULL,
  `update_date` datetime DEFAULT NULL,
  `describe` varchar(500) NOT NULL COMMENT '描述',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='可能造成的后果';

-- ----------------------------
-- Table structure for spc_cameras
-- ----------------------------
DROP TABLE IF EXISTS `spc_cameras`;
CREATE TABLE `spc_cameras` (
  `id` bigint(19) NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL COMMENT '摄像机编号',
  `name` varchar(255) NOT NULL COMMENT '摄像机名称',
  `type` varchar(255) NOT NULL COMMENT '摄像机类型：01 枪型02半球03筒型04球型',
  `ip` varchar(255) NOT NULL COMMENT '摄像机IP',
  `username` varchar(255) NOT NULL COMMENT '用户名',
  `password` varchar(255) NOT NULL COMMENT '密码',
  `port` int(10) NOT NULL COMMENT '端口',
  `channel` int(10) NOT NULL COMMENT '通道',
  `create_date` datetime NOT NULL COMMENT '创建时间',
  `update_date` datetime NOT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `creator_id` varchar(255) NOT NULL,
  `org_code` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for spc_control_measures
-- ----------------------------
DROP TABLE IF EXISTS `spc_control_measures`;
CREATE TABLE `spc_control_measures` (
  `id` bigint(19) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL COMMENT '措施名称',
  `category` varchar(255) NOT NULL COMMENT '类别：01工程技术措施；02管理措施；03个体防护措施；04应急处置措施；05教育培训措施',
  `type` varchar(255) NOT NULL COMMENT '类型：01设备设施；02作业活动；03设备设施和作业活动',
  `org_code` varchar(255) NOT NULL,
  `creator_id` varchar(255) NOT NULL,
  `create_date` datetime NOT NULL,
  `update_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='管控措施';

-- ----------------------------
-- Table structure for spc_dic_kv
-- ----------------------------
DROP TABLE IF EXISTS `spc_dic_kv`;
CREATE TABLE `spc_dic_kv` (
  `key_pre` varchar(255) DEFAULT NULL COMMENT '键前缀',
  `key_core` varchar(255) DEFAULT NULL COMMENT '键成分',
  `dic_key` varchar(500) DEFAULT NULL COMMENT '字典表唯一键（key_pre+"_"+key_core）',
  `dic_value` varchar(500) DEFAULT NULL COMMENT '字典表值',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  UNIQUE KEY `index_dic_key` (`dic_key`) USING HASH COMMENT '唯一索引'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='系统字典表';

-- ----------------------------
-- Table structure for spc_equipment
-- ----------------------------
DROP TABLE IF EXISTS `spc_equipment`;
CREATE TABLE `spc_equipment` (
  `id` bigint(19) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL COMMENT '名称',
  `code` varchar(255) NOT NULL COMMENT '位号(机构内唯一)',
  `region_id` varchar(255) NOT NULL COMMENT '所在分区id',
  `department_id` varchar(255) NOT NULL COMMENT '部门id',
  `workshop_section` varchar(255) NOT NULL COMMENT '所属工段',
  `height` varchar(255) DEFAULT NULL COMMENT '高度',
  `type` varchar(255) NOT NULL COMMENT '设备类型（01生产设备/02应急设备）',
  `org_code` varchar(255) NOT NULL COMMENT '所属机构编码',
  `position3d` varchar(255) NOT NULL COMMENT '3D坐标',
  `floor3d` varchar(255) NOT NULL COMMENT '楼层信息',
  `is_indoor` bit(1) DEFAULT b'1' COMMENT '是否室内',
  `leader_user_id` varchar(255) DEFAULT NULL COMMENT '责任人',
  `leader_department_id` varchar(255) DEFAULT NULL COMMENT '责任部门',
  `creator_id` varchar(255) NOT NULL,
  `create_date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='设备设施';

-- ----------------------------
-- Table structure for spc_equipment_camera_bind
-- ----------------------------
DROP TABLE IF EXISTS `spc_equipment_camera_bind`;
CREATE TABLE `spc_equipment_camera_bind` (
  `id` bigint(19) NOT NULL AUTO_INCREMENT,
  `equipment_id` bigint(19) NOT NULL COMMENT '设备设施id',
  `camera_id` bigint(19) NOT NULL COMMENT '摄像机id',
  `create_date` datetime NOT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for spc_evaluate_model
-- ----------------------------
DROP TABLE IF EXISTS `spc_evaluate_model`;
CREATE TABLE `spc_evaluate_model` (
  `id` bigint(19) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL COMMENT '名称',
  `creator_id` varchar(255) NOT NULL COMMENT '维护人id',
  `create_date` date NOT NULL COMMENT '维护时间',
  `org_code` varchar(255) NOT NULL COMMENT '组织结构编码',
  `update_date` date NOT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='风险评价方法';

-- ----------------------------
-- Table structure for spc_evaluate_norm
-- ----------------------------
DROP TABLE IF EXISTS `spc_evaluate_norm`;
CREATE TABLE `spc_evaluate_norm` (
  `id` bigint(19) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL COMMENT '名称',
  `content` text NOT NULL COMMENT '内容：[{"des":"严重","norm":"1-2人死亡","value":7}...]',
  `evaluate_model_id` bigint(19) NOT NULL COMMENT '所属风险评价方法',
  `creator_id` varchar(255) NOT NULL COMMENT '创建者',
  `create_date` date NOT NULL COMMENT '创建时间',
  `update_date` date NOT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='评价准则';

-- ----------------------------
-- Table structure for spc_hazard_source_classify
-- ----------------------------
DROP TABLE IF EXISTS `spc_hazard_source_classify`;
CREATE TABLE `spc_hazard_source_classify` (
  `id` bigint(19) NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL COMMENT '类型（物/人/环境/管理）',
  `name` varchar(255) NOT NULL COMMENT '名称',
  `org_code` varchar(255) NOT NULL COMMENT '组织编码',
  `creator_id` varchar(255) NOT NULL COMMENT '创建人',
  `create_date` datetime NOT NULL COMMENT '创建时间',
  `update_date` datetime DEFAULT NULL COMMENT '修改时间',
  `describe` varchar(500) DEFAULT NULL COMMENT '详情',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='危险源分类';

-- ----------------------------
-- Table structure for spc_identification_method
-- ----------------------------
DROP TABLE IF EXISTS `spc_identification_method`;
CREATE TABLE `spc_identification_method` (
  `id` bigint(19) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL COMMENT '名称',
  `code` varchar(255) NOT NULL COMMENT '编号',
  `creator_id` varchar(255) NOT NULL COMMENT '维护人员id',
  `create_date` date NOT NULL COMMENT '创建时间',
  `org_code` varchar(255) NOT NULL COMMENT '组织结构编码',
  `update_date` date NOT NULL COMMENT '更新时间',
  `description` varchar(500) DEFAULT NULL COMMENT '适配对象',
  PRIMARY KEY (`id`),
  KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='风险辨识方法';

-- ----------------------------
-- Table structure for spc_measures_content
-- ----------------------------
DROP TABLE IF EXISTS `spc_measures_content`;
CREATE TABLE `spc_measures_content` (
  `id` bigint(19) NOT NULL AUTO_INCREMENT,
  `content` varchar(500) NOT NULL COMMENT '内容',
  `control_measures_id` bigint(19) NOT NULL COMMENT '管控措施id',
  `basis` text NOT NULL COMMENT '依据:[{"id":1,"name":"内容"}]',
  `create_date` datetime NOT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='管控内容';

-- ----------------------------
-- Table structure for spc_risk_factors
-- ----------------------------
DROP TABLE IF EXISTS `spc_risk_factors`;
CREATE TABLE `spc_risk_factors` (
  `id` bigint(19) NOT NULL AUTO_INCREMENT,
  `name` varchar(500) NOT NULL COMMENT '危险因素名称',
  `user_ids` varchar(500) NOT NULL COMMENT '辨识人id（多个用逗号隔开）',
  `user_names` varchar(255) DEFAULT NULL COMMENT '风险辨识人名称',
  `identification_method_ids` varchar(500) NOT NULL COMMENT '风险辨识方法id（多个用逗号隔开）',
  `identification_method_names` varchar(255) DEFAULT NULL COMMENT '风险辨识方法名称',
  `type` varchar(255) NOT NULL COMMENT '管控对象类型（1设备设施/2作业活动）',
  `control_object_id` bigint(19) NOT NULL COMMENT '管控对象id（设备equipmentid/作业活动步骤id）',
  `level_id` bigint(20) DEFAULT NULL COMMENT '等级编号',
  `rf_value` varchar(500) DEFAULT NULL COMMENT '值：{"L":1,"S":5,.....}',
  `hazard_source_classify_id` bigint(19) NOT NULL COMMENT '危险源分类id',
  `aftermath_ids` varchar(500) NOT NULL COMMENT '可能造成得后果id（多个用逗号隔开）',
  `risk_source_id` bigint(19) NOT NULL COMMENT '风险源id',
  `evaluate_id` bigint(19) DEFAULT NULL COMMENT '评价流程id',
  `start_flow_time` datetime DEFAULT NULL COMMENT '工单发起时间',
  `start_flow_user_id` varchar(255) DEFAULT NULL COMMENT '工单发起人',
  `start_flow_department_id` varchar(255) DEFAULT NULL COMMENT '工单发起部门编号',
  `flow_order_no` varchar(255) DEFAULT NULL COMMENT '流程工单号',
  `status` varchar(255) NOT NULL DEFAULT '0' COMMENT '状态：流程状态（0：未启动；1：执行中；3：执行完成；4：撤销）',
  `control_object_name` varchar(255) DEFAULT NULL COMMENT '风险管控对象名称',
  `control_status` varchar(255) DEFAULT NULL COMMENT '安全管控状态',
  `evaluate_result` varchar(50) DEFAULT NULL COMMENT '评价结果',
  `first_evaluate_user_id` varchar(255) DEFAULT NULL COMMENT '初评人',
  `first_evaluate_mothod_name` varchar(255) DEFAULT NULL COMMENT '初评方法',
  `second_evaluate_user_id` varchar(255) DEFAULT NULL COMMENT '复评人',
  `second_evaluate_mothod_name` varchar(255) DEFAULT NULL COMMENT '复评方法',
  `is_acceptable` tinyint(4) DEFAULT NULL COMMENT '是否可接受（0：否；1：是）',
  `creator_id` varchar(255) NOT NULL COMMENT '创建人',
  `create_date` date NOT NULL,
  `update_date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='危险因素';

-- ----------------------------
-- Table structure for spc_risk_factors_cm
-- ----------------------------
DROP TABLE IF EXISTS `spc_risk_factors_cm`;
CREATE TABLE `spc_risk_factors_cm` (
  `id` bigint(19) NOT NULL AUTO_INCREMENT,
  `control_measures_id` bigint(19) NOT NULL COMMENT '管控措施id',
  `measures_content_id` bigint(19) NOT NULL COMMENT '管控措施内容id',
  `risk_factors_id` bigint(19) NOT NULL COMMENT '危险因素id',
  `create_date` datetime NOT NULL,
  `evaluate_id` bigint(19) DEFAULT NULL COMMENT '评价流程id',
  `status` varchar(255) DEFAULT NULL COMMENT '管控措施状态（1受控；2失控；3一般隐患；4重大隐患）',
  `check_status` varchar(255) DEFAULT '1' COMMENT '隐患排查状态：1 合格2不合格3漏检',
  `update_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='危险因素管控措施';

-- ----------------------------
-- Table structure for spc_risk_factors_level_log
-- ----------------------------
DROP TABLE IF EXISTS `spc_risk_factors_level_log`;
CREATE TABLE `spc_risk_factors_level_log` (
  `id` bigint(19) NOT NULL AUTO_INCREMENT,
  `risk_factors_id` bigint(19) NOT NULL,
  `evaluate_id` int(10) NOT NULL COMMENT '评价流程id',
  `old_level_id` bigint(20) DEFAULT NULL COMMENT '原等级',
  `current_level_id` bigint(20) DEFAULT NULL COMMENT '修改后得等级',
  `type` int(10) DEFAULT NULL,
  `value` varchar(500) DEFAULT NULL COMMENT '值：{"L":1,"S":5,.....}',
  `is_acceptable` tinyint(4) DEFAULT NULL COMMENT '是否可接受（0：否；1：是）',
  `create_date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='危险因素等级变化历史记录';

-- ----------------------------
-- Table structure for spc_risk_judgment_fill_record
-- ----------------------------
DROP TABLE IF EXISTS `spc_risk_judgment_fill_record`;
CREATE TABLE `spc_risk_judgment_fill_record` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键自增',
  `task_id` bigint(20) NOT NULL COMMENT '风险研判任务编号',
  `item_id` bigint(20) NOT NULL COMMENT '风险研判项编号',
  `select_result` varchar(255) DEFAULT NULL COMMENT '选择结果',
  `input_result` varchar(255) DEFAULT NULL COMMENT '填写结果',
  `remark_result` varchar(255) DEFAULT NULL COMMENT '备注结果',
  `photo_result` varchar(500) DEFAULT NULL COMMENT '拍照结果',
  `item_finish` tinyint(4) NOT NULL DEFAULT '0' COMMENT '选项是否提交（0：否；1：是）',
  `org_code` varchar(255) DEFAULT NULL COMMENT '组织机构编号',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT '是否删除（0：否；1：是）',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '记录创建时间',
  `update_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '记录修改时间',
  PRIMARY KEY (`id`),
  KEY `index_task_id` (`task_id`) COMMENT '研判任务索引',
  KEY `index_item_id` (`item_id`) COMMENT '内容项索引'
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='风险研判填写记录表';

-- ----------------------------
-- Table structure for spc_risk_judgment_item
-- ----------------------------
DROP TABLE IF EXISTS `spc_risk_judgment_item`;
CREATE TABLE `spc_risk_judgment_item` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键自增',
  `item_flag` varchar(50) DEFAULT NULL COMMENT '唯一标识',
  `item_level` int(10) DEFAULT NULL COMMENT '风险研判项级别',
  `item_type` tinyint(4) DEFAULT NULL COMMENT '风险研判项类型（1：风险研判表；2：风险研判采集表）',
  `item_name` varchar(255) DEFAULT NULL COMMENT '节点名称',
  `item_parent_id` bigint(20) DEFAULT NULL COMMENT '父节点编号',
  `item_can_copy` tinyint(4) NOT NULL DEFAULT '0' COMMENT '是否可拷贝（0：否；1：是）',
  `select_name` varchar(255) DEFAULT NULL COMMENT '选项名称',
  `select_is_need` tinyint(4) NOT NULL DEFAULT '0' COMMENT '选项是否需要（0：否；1：是）',
  `select_is_required` tinyint(4) NOT NULL DEFAULT '0' COMMENT '选项是否必选（0：否；1：是）',
  `select_json` text COMMENT '选项json[{"id":1,"name":"否"}]',
  `input_name` varchar(255) DEFAULT NULL COMMENT '输入项名称',
  `input_is_need` tinyint(4) NOT NULL DEFAULT '0' COMMENT '输入是否需要（0：否；1：是）',
  `input_is_required` tinyint(4) NOT NULL DEFAULT '0' COMMENT '输入项是否必填（0：否；1：是）',
  `remark_is_need` tinyint(4) NOT NULL DEFAULT '0' COMMENT '备注是否需要（0：否；1：是）',
  `remark_is_required` tinyint(4) NOT NULL DEFAULT '0' COMMENT '备注是否必填（0：否；1：是）',
  `photo_is_need` tinyint(4) NOT NULL DEFAULT '0' COMMENT '拍照是否需要（0：否；1：是）',
  `photo_is_required` tinyint(4) NOT NULL DEFAULT '0' COMMENT '拍照是否必填（0：否；1：是）',
  `org_code` varchar(255) DEFAULT NULL COMMENT '组织机构编号',
  `department_id` varchar(255) DEFAULT NULL COMMENT '部门编号',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT '是否删除（0：否；1：是）',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '记录创建时间',
  `update_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '记录修改时间',
  PRIMARY KEY (`id`),
  KEY `index_item_parent_id` (`item_parent_id`) COMMENT '父节点索引'
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='风险研判项表';

-- ----------------------------
-- Table structure for spc_risk_judgment_task
-- ----------------------------
DROP TABLE IF EXISTS `spc_risk_judgment_task`;
CREATE TABLE `spc_risk_judgment_task` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键自增',
  `task_name` varchar(255) NOT NULL COMMENT '风险研判名称',
  `department_id` varchar(255) NOT NULL COMMENT '部门编号',
  `task_status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '状态（0：未开始；1：进行中；2：已超时；3：已提交）',
  `task_date` date NOT NULL COMMENT '风险研判日期（今天8:00-明天8:00）',
  `task_commit_date` datetime DEFAULT NULL COMMENT '提交时间',
  `business_key` varchar(255) DEFAULT NULL COMMENT '业务唯一标识',
  `flow_user_ids` varchar(500) DEFAULT NULL COMMENT '可执行用户（多个逗号隔开）',
  `flow_instance_id` varchar(50) DEFAULT NULL COMMENT '工作流实例编号',
  `org_code` varchar(255) DEFAULT NULL COMMENT '组织机构编号',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT '是否删除（0：否；1：是）',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '记录创建时间',
  `update_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '记录修改时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='风险研判任务表';

-- ----------------------------
-- Table structure for spc_risk_level
-- ----------------------------
DROP TABLE IF EXISTS `spc_risk_level`;
CREATE TABLE `spc_risk_level` (
  `id` bigint(19) NOT NULL AUTO_INCREMENT,
  `level` varchar(255) NOT NULL COMMENT '等级（一级，二级，三级，四级）',
  `upper` int(10) NOT NULL COMMENT '上线',
  `lower` int(10) NOT NULL COMMENT '下线',
  `evaluate_model_id` bigint(19) NOT NULL COMMENT '风险评价方法id',
  `describe` varchar(500) NOT NULL COMMENT '结果描述',
  `is_acceptable` tinyint(4) DEFAULT NULL COMMENT '是否可接受（0：否；1：是）',
  `creator_id` varchar(255) DEFAULT NULL COMMENT '创建者',
  `create_date` date DEFAULT NULL,
  `update_date` date DEFAULT NULL,
  `code` varchar(255) DEFAULT NULL COMMENT '等级编码1一级，2二级3三级4四级5五级',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='风险等级';

-- ----------------------------
-- Table structure for spc_risk_source
-- ----------------------------
DROP TABLE IF EXISTS `spc_risk_source`;
CREATE TABLE `spc_risk_source` (
  `id` bigint(19) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL COMMENT '名称',
  `risk_level` bigint(19) DEFAULT NULL COMMENT '等级id',
  `risk_level_value` varchar(255) DEFAULT NULL COMMENT '风险等级值：{"L":1,"S":5,.....}',
  `code` varchar(255) DEFAULT NULL COMMENT '编号',
  `risk_type` varchar(255) NOT NULL COMMENT '类型（01厂区/02区域/03位置/04风险）',
  `user_id` varchar(255) NOT NULL COMMENT '辨识人id',
  `identification_method_id` bigint(19) NOT NULL COMMENT '辨识方法id',
  `position3d` varchar(255) DEFAULT NULL COMMENT '三维坐标信息：{"x":168.4586,"y":1.1004,"z":30.3959}',
  `floor3d` varchar(255) DEFAULT NULL COMMENT '信息楼层',
  `is_indoor` bit(1) DEFAULT NULL COMMENT '室内室外：1 为室内，0为室外',
  `classify` varchar(255) NOT NULL COMMENT '分类：固定/移动。',
  `creator_id` varchar(255) DEFAULT NULL COMMENT '创建人id',
  `create_date` date DEFAULT NULL COMMENT '创建时间',
  `org_code` varchar(255) DEFAULT NULL COMMENT '所属组织编码',
  `update_date` date DEFAULT NULL,
  `parent_id` bigint(20) NOT NULL,
  `check_status` varchar(255) DEFAULT '1' COMMENT '隐患排查状态：1 合格2不合格3漏检',
  `is_danger` bit(1) DEFAULT NULL COMMENT '是否有隐患',
  `danger_level` varchar(255) DEFAULT NULL COMMENT '1一般隐患，2重大隐患',
  `flicker_frequency` int(11) DEFAULT '0' COMMENT '风险点闪烁频率',
  `belong_department_id` varchar(255) DEFAULT NULL COMMENT '存在部门',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='风险源';

-- ----------------------------
-- Table structure for spc_risk_source_level_log
-- ----------------------------
DROP TABLE IF EXISTS `spc_risk_source_level_log`;
CREATE TABLE `spc_risk_source_level_log` (
  `id` bigint(19) NOT NULL AUTO_INCREMENT,
  `risk_source_id` bigint(19) NOT NULL COMMENT '风险点id',
  `risk_factors_id` bigint(19) NOT NULL COMMENT '触发得风险因素id',
  `old_level` varchar(255) NOT NULL COMMENT '修改前等级',
  `current_level` varchar(255) NOT NULL COMMENT '修改后等级',
  `type` int(10) NOT NULL COMMENT '变化类型：0上升；1下降',
  `value` varchar(255) DEFAULT NULL COMMENT '值：{"L":1,"S":5,.....}',
  `create_date` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FKspc_risk_s981503` (`risk_source_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='风险点等级变化历史记录';

-- ----------------------------
-- Table structure for spc_risk_study
-- ----------------------------
DROP TABLE IF EXISTS `spc_risk_study`;
CREATE TABLE `spc_risk_study` (
  `id` bigint(19) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL COMMENT '项目名称',
  `serial_num` int(10) NOT NULL COMMENT '序号',
  `level` int(10) DEFAULT NULL COMMENT '排序',
  `status` varchar(255) DEFAULT NULL COMMENT '状态',
  `creator_id` varchar(255) DEFAULT NULL COMMENT '执行人',
  `create_date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='风险研判';

-- ----------------------------
-- Table structure for spc_risk_study_content
-- ----------------------------
DROP TABLE IF EXISTS `spc_risk_study_content`;
CREATE TABLE `spc_risk_study_content` (
  `id` bigint(19) DEFAULT NULL,
  `risk_study_id` bigint(19) NOT NULL,
  `content` varchar(500) DEFAULT NULL COMMENT '检查内容',
  `score` int(10) DEFAULT NULL COMMENT '评分',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_date` date DEFAULT NULL,
  KEY `FKspc_risk_s349841` (`risk_study_id`),
  CONSTRAINT `FKspc_risk_s349841` FOREIGN KEY (`risk_study_id`) REFERENCES `spc_risk_study` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='研判内容';

-- ----------------------------
-- Table structure for spc_taskwork
-- ----------------------------
DROP TABLE IF EXISTS `spc_taskwork`;
CREATE TABLE `spc_taskwork` (
  `id` bigint(19) NOT NULL AUTO_INCREMENT COMMENT '主键编号',
  `name` varchar(255) NOT NULL COMMENT '作业活动名称',
  `type` varchar(255) NOT NULL COMMENT '类型',
  `post` varchar(255) NOT NULL COMMENT '岗位',
  `part` varchar(255) NOT NULL COMMENT '部位',
  `region_id` varchar(255) NOT NULL COMMENT '所在分区',
  `department_id` varchar(255) DEFAULT NULL COMMENT '部门',
  `group_id` varchar(255) DEFAULT NULL COMMENT '班组',
  `status` int(11) NOT NULL DEFAULT '1' COMMENT '作业活动状态（1：未启动；2：待班组审核；3：待车间/部门审核；4：待公司审核；5：待执行；6：待确认验收；7：完成）',
  `risk_level_id` bigint(20) DEFAULT '0' COMMENT '风险等级id',
  `creator_id` varchar(255) DEFAULT NULL COMMENT '创建人',
  `is_monitor` bit(1) DEFAULT NULL COMMENT '是否被监控',
  `org_code` varchar(255) DEFAULT NULL COMMENT '组织编码',
  `current_flow_record_id` bigint(20) DEFAULT NULL COMMENT '当前工作流记录编号',
  `instance_id` varchar(50) DEFAULT NULL COMMENT '工作流实例编号',
  `business_key` varchar(255) DEFAULT NULL COMMENT '业务唯一标识',
  `apply_user_id` varchar(255) NOT NULL COMMENT '申请人',
  `apply_department_id` varchar(255) DEFAULT NULL COMMENT '申请人部门编号',
  `apply_date` datetime DEFAULT NULL COMMENT '申请时间',
  `create_date` date DEFAULT NULL,
  `update_date` date DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='作业活动';

-- ----------------------------
-- Table structure for spc_taskwork_audit_log
-- ----------------------------
DROP TABLE IF EXISTS `spc_taskwork_audit_log`;
CREATE TABLE `spc_taskwork_audit_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键编号',
  `taskwork_id` bigint(20) NOT NULL COMMENT '作业活动编号',
  `action_flag` varchar(50) NOT NULL COMMENT '执行标志',
  `flow_task_name` varchar(255) DEFAULT NULL COMMENT '当前节点名称',
  `flow_task_user_ids` varchar(500) DEFAULT NULL COMMENT '当前节点可执行人（多个逗号分开）',
  `flow_task_id` varchar(255) DEFAULT NULL COMMENT '当前节点编号',
  `excute_state` tinyint(4) NOT NULL DEFAULT '1' COMMENT '执行状态（1：未执行；2：通过；3：驳回）',
  `excute_user_id` varchar(255) DEFAULT NULL COMMENT '执行人',
  `excute_department_id` varchar(255) DEFAULT NULL COMMENT '执行部门编号',
  `excute_result` varchar(255) DEFAULT NULL COMMENT '执行结果',
  `remark` varchar(500) DEFAULT NULL COMMENT '备注',
  `flow_json` text COMMENT '上传数据',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT '是否删除（0：否；1：是）',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '记录创建时间',
  `update_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '记录修改时间',
  PRIMARY KEY (`id`),
  KEY `index_taskwork_id` (`taskwork_id`) COMMENT '作业活动编号索引'
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='作业活动工作流审核日志';

-- ----------------------------
-- Table structure for spc_taskwork_content
-- ----------------------------
DROP TABLE IF EXISTS `spc_taskwork_content`;
CREATE TABLE `spc_taskwork_content` (
  `id` bigint(19) NOT NULL AUTO_INCREMENT,
  `taskwork_id` bigint(19) NOT NULL COMMENT '作业活动id',
  `serial_num` int(10) NOT NULL DEFAULT '1' COMMENT '序号',
  `content` varchar(255) DEFAULT NULL COMMENT '内容',
  `risk_level_id` bigint(20) DEFAULT NULL COMMENT '风险等级id',
  `execute_state` tinyint(4) DEFAULT '0' COMMENT '作业活动步骤执行状态：0-未执行；1-已执行',
  `img` text COMMENT '照片',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_date` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `index_taskwork_id` (`taskwork_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='作业活动步骤';

-- ----------------------------
-- Table structure for spc_taskwork_measures
-- ----------------------------
DROP TABLE IF EXISTS `spc_taskwork_measures`;
CREATE TABLE `spc_taskwork_measures` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `taskwork_content_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '作业活动步骤编号',
  `risk_factors_cm_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '危险因素管控措施id',
  `measures_content_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '控制措施内容id',
  `execute_state` tinyint(4) DEFAULT '0' COMMENT '执行状态:0-未执行；1-已执行',
  `violate_state` tinyint(4) DEFAULT '0' COMMENT '违章状态：0-未确认；1-无违章；2-一般违章；3-严重违章',
  `remerk` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`),
  KEY `index_taskwork_content_id` (`taskwork_content_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='作业活动管控措施表';
SET FOREIGN_KEY_CHECKS=1;
