package com.yeejoin.amos.bank;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

import org.hibernate.annotations.GenericGenerator;

import com.yeejoin.amos.op.core.entity.BusinessEntity;

/**
 * 拓扑图
 * @author zhangzhihui
 *
 */
@Entity
@Table(name = "b_topography_node")
public class TopographyNode extends BusinessEntity{

	/**
     * id
     */
    @Id
    @GeneratedValue(generator = "uuid")
    @GenericGenerator(name = "uuid", strategy = "uuid2")
    @Column(name = "id", nullable = false, length = 36)
    protected String id;
	/**
     * 
     */
    @Column(name = "`key`", columnDefinition = "varchar(32) COMMENT 'key'")
    private String key;
    /**
     * 
     */
    @Column(name = "category", columnDefinition = "varchar(32) COMMENT '类别'")
    private String category;
    /**
     * 
     */
    @Column(name = "`group`", columnDefinition = "varchar(32) COMMENT '分组'")
    private String group;
    /**
     * 
     */
    @Column(name = "loc", columnDefinition = "varchar(32) COMMENT '位置'")
    private String loc;
    /**
     * 
     */
    @Column(name = "text", columnDefinition = "varchar(32) COMMENT '文本'")
    private String text;
    /**
     * 
     */
    @Column(name = "size", columnDefinition = "varchar(32) COMMENT '大小'")
    private String size;
    /**
     * 
     */
    @Column(name = "is_group", columnDefinition = "bit COMMENT '是否是组'")
    private Boolean isGroup;
    /**
     * 
     */
    @Column(name = "source", columnDefinition = "varchar(32) COMMENT '图片'")
    private String source;
    /**
     * 
     */
    @Column(name = "treeid", columnDefinition = "varchar(32) COMMENT '树id'")
    private String treeid;
    /**
     * 
     */
    @Column(name = "state", columnDefinition = "int COMMENT '异常状态'")
    private int state;
    /**
     * 
     */
    @Column(name = "number", columnDefinition = "int COMMENT '异常数量'")
    private Integer number;
    /**
     * 
     */
    @Column(name = "type", columnDefinition = "int COMMENT '类型：1-网络拓扑图，2-PAMS'")
    private Integer type;
    /**
     * 
     */
    @Column(name = "left_port", columnDefinition = "varchar(32) COMMENT '左端口'")
    private String leftPort;
    /**
     * 
     */
    @Column(name = "right_port", columnDefinition = "varchar(32) COMMENT '右端口'")
    private String rightPort;
    /**
     * 
     */
    @Column(name = "single_port", columnDefinition = "varchar(32) COMMENT '单个端口'")
    private String singlePort;
    
    /**
     * 
     */
    @Column(name = "equip_type", columnDefinition = "int COMMENT '设备类型:2:防火墙;3.交换机;4:暂定为路由器;1:其余,代表负载均衡'")
    private Integer equipType;
       
    /**
     * 对接设备id
     */
    @Column(name = "sourceId", columnDefinition = "varchar(255) COMMENT '对接设备id'")
    private String sourceId;
    
    /**
     * 多个端口列表json
     */
    @Column(name = "ports", columnDefinition = "text COMMENT '多个端口列表json'")
    private String ports;
    
    @Column(name = "org_code", columnDefinition = "varchar(255) COMMENT '单位'")
   	private String orgCode;
   	
   	public String getOrgCode() {
   		return orgCode;
   	}

   	public void setOrgCode(String orgCode) {
   		this.orgCode = orgCode;
   	}
    
	public Integer getEquipType() {
		return equipType;
	}
	public void setEquipType(Integer equipType) {
		this.equipType = equipType;
	}
	public String getId() {
		return id;
	}
	public void setId(String id) {
		this.id = id;
	}
	public String getKey() {
		return key;
	}
	public void setKey(String key) {
		this.key = key;
	}
	public String getCategory() {
		return category;
	}
	public void setCategory(String category) {
		this.category = category;
	}
	public String getGroup() {
		return group;
	}
	public void setGroup(String group) {
		this.group = group;
	}
	public String getLoc() {
		return loc;
	}
	public void setLoc(String loc) {
		this.loc = loc;
	}
	public String getText() {
		return text;
	}
	public void setText(String text) {
		this.text = text;
	}
	public String getSize() {
		return size;
	}
	public void setSize(String size) {
		this.size = size;
	}
	public Boolean getIsGroup() {
		return isGroup;
	}
	public void setIsGroup(Boolean isGroup) {
		this.isGroup = isGroup;
	}
	public String getSource() {
		return source;
	}
	public void setSource(String source) {
		this.source = source;
	}
	public String getTreeid() {
		return treeid;
	}
	public void setTreeid(String treeid) {
		this.treeid = treeid;
	}
	public int getState() {
		return state;
	}
	public void setState(int state) {
		this.state = state;
	}
	public Integer getNumber() {
		return number;
	}
	public void setNumber(Integer number) {
		this.number = number;
	}
	public Integer getType() {
		return type;
	}
	public void setType(Integer type) {
		this.type = type;
	}
	public String getLeftPort() {
		return leftPort;
	}
	public void setLeftPort(String leftPort) {
		this.leftPort = leftPort;
	}
	public String getRightPort() {
		return rightPort;
	}
	public void setRightPort(String rightPort) {
		this.rightPort = rightPort;
	}
	public String getSinglePort() {
		return singlePort;
	}
	public void setSinglePort(String singlePort) {
		this.singlePort = singlePort;
	}
	public String getSourceId() {
		return sourceId;
	}
	public void setSourceId(String sourceId) {
		this.sourceId = sourceId;
	}
	public String getPorts() {
		return ports;
	}
	public void setPorts(String ports) {
		this.ports = ports;
	}
	@Override
	public String toString() {
		return "TopographyNode [id=" + id + ", key=" + key + ", category=" + category + ", group=" + group + ", loc="
				+ loc + ", text=" + text + ", size=" + size + ", isGroup=" + isGroup + ", source=" + source
				+ ", treeid=" + treeid + ", state=" + state + ", number=" + number + ", type=" + type + ", leftPort="
				+ leftPort + ", rightPort=" + rightPort + ", singlePort=" + singlePort + ", equipType=" + equipType
				+ "]";
	}
	
	
}
