package com.yeejoin.amos.bank.common.enums;

/**
 * 
 * <pre>
 * 告警状态
 * </pre>
 *
 * @author zhangzhihui
 */
public enum AbnormalStateEnum{

	N("正常", 0, "#00FF00", ""),
	W("警告告警", 1, "#0000FF", "W"),
	S("次要告警", 2, "#00FF00", "S"),
	M("重要告警", 3, "#DF7400", "M"),
	E("紧急告警", 4, "#FF0000", "E");

	/**
	 * 名称
	 */
	private String name;

	/**
	 * 值
	 */
	private int code;
	
	/**
	 * 状态颜色
	 */
	private String color;
	/**
	 * 文本
	 */
	private String text;

	// 构造方法
	private AbnormalStateEnum(String name, int code, String color, String text) {
		this.name = name;
		this.code = code;
		this.color = color;
		this.text = text;
	}

	/**
	 * 
	 * <pre>
	 * 获取索引名称
	 * </pre>
	 *
	 * @param code
	 * @return
	 */
	public static String getText(int code) {
		for (AbnormalStateEnum c : AbnormalStateEnum.values()) {
			if (c.getCode() == code) {
				return c.text;
			}
		}
		return null;
	}

	/**
	 * 
	 * <pre>
	 * 获取索引
	 * </pre>
	 *
	 * @param code
	 * @return
	 */
	public static AbnormalStateEnum getEnum(int code) {
		for (AbnormalStateEnum c : AbnormalStateEnum.values()) {
			if (c.getCode() == code) {
				return c;
			}
		}
		return null;
	}

	/**
	 * 
	 * <pre>
	 * 获取索引
	 * </pre>
	 *
	 * @param name
	 * @return
	 */
	public static AbnormalStateEnum getEnum(String name) {
		for (AbnormalStateEnum c : AbnormalStateEnum.values()) {
			if (c.getName().equals(name)) {
				return c;
			}
		}
		return null;
	}
	
	public static String getAbnormalName(int code) {
		for (AbnormalStateEnum c : AbnormalStateEnum.values()) {
			if (c.getCode() == code) {
				return c.name;
			}
		}
		return null;
	}

	/**
	 * Getter method for property <tt>name</tt>.
	 * 
	 * @return property code of name
	 */
	public String getName() {
		return name;
	}

	/**
	 * Setter method for property <tt>name</tt>.
	 * 
	 * @param name
	 *            code to be assigned to property name
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * Getter method for property <tt>code</tt>.
	 * 
	 * @return property code of code
	 */
	public int getCode() {
		return code;
	}

	/**
	 * Setter method for property <tt>code</tt>.
	 * 
	 * @param code
	 *            code to be assigned to property code
	 */
	public void setCode(int code) {
		this.code = code;
	}

	public String getColor()
	{
		return color;
	}

	public void setColor(String color)
	{
		this.color = color;
	}

	public String getText() {
		return text;
	}

	public void setText(String text) {
		this.text = text;
	}

}
