package com.yeejoin.amos.bank.common.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 设备类型
 *
 */
public enum EquipmentTypeEnum {
	网络设备("网络设备", "01"),
    服务器("服务器", "02");
    /**
     * 名称，描述
     */
    private String name;
    /**
     * 编码
     */
    private String code;

    EquipmentTypeEnum(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public static EquipmentTypeEnum getEnum(String code) {
        EquipmentTypeEnum instance = null;
        for (EquipmentTypeEnum type : EquipmentTypeEnum.values()) {
            if (type.getCode().equals(code)) {
                instance = type;
                break;
            }
        }

        return instance;
    }

    public static String getEnumName(String code) {
        String name = "";
        for (EquipmentTypeEnum type : EquipmentTypeEnum.values()) {
            if (type.getCode().equals(code)) {
                name = type.getName();
                break;
            }
        }

        return name;
    }

    public static List<Map<String, String>> getEnumList() {
        List<Map<String, String>> list = new ArrayList<>();
        for (EquipmentTypeEnum e : EquipmentTypeEnum.values()) {
            Map<String, String> map = new HashMap<String, String>();
            map.put("code", e.getCode());
            map.put("name", e.getName());
            list.add(map);
        }
        return list;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
}
