package com.yeejoin.amos.spc.common.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 管控措施类型
 * @author maoying
 *
 */
public enum ControlMeasuresTypeEnum {
	equipment("设备设施","01"),
	taskwork("作业活动","02"),
	equipmentAndtaskwork("设备设施和作业活动","01");
	
	/**
	 * 名称，描述
	 */
	private String name;
	/**
	 * 编码
	 */
	private String code;
	
	private ControlMeasuresTypeEnum(String name,String code){
		this.name = name;
		this.code = code;
	}
	
	public static ControlMeasuresTypeEnum getEnum(String code) {
		ControlMeasuresTypeEnum instance = null;
		for(ControlMeasuresTypeEnum type: ControlMeasuresTypeEnum.values()) {
			if (type.getCode().equals(code)) {
				instance = type;
				break;
			}
		}
		
		return instance;
	}
	
	public static List<Map<String,String>> getEnumList() {
		List<Map<String,String>> list = new ArrayList<>();
		for(ControlMeasuresTypeEnum e : ControlMeasuresTypeEnum.values()) {
			Map<String, String> map = new HashMap<String, String>();
			map.put("code", e.getCode());
			map.put("name", e.getName());
			list.add(map);
		}
		return list;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}
}
