package com.yeejoin.amos.spc.common.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 设备类型
 *
 * @author maoying
 */
public enum EquipmentTypeEnum {
    炉类("炉类", "01"),
    塔类("塔类", "02"),
    反应器类("反应器类", "03"),
    储罐及容器类("储罐及容器类", "04"),
    换热设备类("换热设备类", "05"),
    动力类("动力类", "06"),
    起重运输类("起重运输类", "07"),
    其他设备类("其他设备类", "08");
    /**
     * 名称，描述
     */
    private String name;
    /**
     * 编码
     */
    private String code;

    EquipmentTypeEnum(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public static EquipmentTypeEnum getEnum(String code) {
        EquipmentTypeEnum instance = null;
        for (EquipmentTypeEnum type : EquipmentTypeEnum.values()) {
            if (type.getCode().equals(code)) {
                instance = type;
                break;
            }
        }

        return instance;
    }

    public static String getEnumName(String code) {
        String name = "";
        for (EquipmentTypeEnum type : EquipmentTypeEnum.values()) {
            if (type.getCode().equals(code)) {
                name = type.getName();
                break;
            }
        }

        return name;
    }

    public static List<Map<String, String>> getEnumList() {
        List<Map<String, String>> list = new ArrayList<>();
        for (EquipmentTypeEnum e : EquipmentTypeEnum.values()) {
            Map<String, String> map = new HashMap<String, String>();
            map.put("code", e.getCode());
            map.put("name", e.getName());
            list.add(map);
        }
        return list;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
}
