package com.yeejoin.amos.spc.common.enums;

public enum ExcelModelEnum {
    设备设施("设备设施", "equipment"),
    作业活动("作业活动", "taskwork"),
    风险区域清单("风险区域清单", "riskRegionList"),
    风险点清单("风险点清单", "riskPointList"),
    危险源设备设施及控制措施清单("危险源设备设施及控制措施清单", "equipmentMeasureList"),
    危险源作业活动及控制措施清单("危险源作业活动及控制措施清单", "taskworkMeasureList"),
    重大安全风险及控制措施清单("重大安全风险及控制措施清单", "coreRiskList");

    /**
     * 名称，描述
     */
    private String name;
    /**
     * 编码
     */
    private String code;

    ExcelModelEnum(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public static ExcelModelEnum getByCode(String code) {
        for (ExcelModelEnum modelEnum : ExcelModelEnum.values()) {
            if (modelEnum.code.equals(code)) {
                return modelEnum;
            }
        }
        return null;
    }
}
