package com.yeejoin.amos.spc.common.enums;

public enum RiskLevelEnum {
	level_1("1级","1"),
	level_2("2级","2"),
	level_3("3级","3"),
	level_4("4级","4"),
	level_5("5级","5");
	
	/**
	 * 名称
	 */
	private String name;
	/**
	 * 编码
	 */
	private String code;
	
	private RiskLevelEnum(String name,String code){
		this.setName(name);
		this.setCode(code);
	}
	
	public static RiskLevelEnum getEnum(String code) {
		RiskLevelEnum instance = null;
		for(RiskLevelEnum type: RiskLevelEnum.values()) {
			if (type.getCode().equals(code)) {
				instance = type;
				break;
			}
		}
		
		return instance;
	}
	
	public static String getEnumName(String code) {
		String name = "";
		for(RiskLevelEnum type: RiskLevelEnum.values()) {
			if (type.getCode().equals(code)) {
				name = type.getName();
				break;
			}
		}
		
		return name;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}
}
