package com.yeejoin.amos.spc.dao.entity;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;

import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import com.yeejoin.amos.op.core.entity.Resource;

/**
 * <pre>
 * 基本实体类
 * </pre>
 *
 */

@MappedSuperclass

@EntityListeners(AuditingEntityListener.class) 
public class BasicEntity extends Resource implements Serializable{

	private static final long serialVersionUID = -5464322936854328207L;
	
	/**
	 * id
	 */
	private Long id;

	private String createUserName;

	@CreatedDate
	@Column(name="create_date")
	private Date createDate= new Date();

	@Id
	@GeneratedValue(strategy=GenerationType.IDENTITY)
	@Column(name = "id",nullable=false,unique=true)
	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Date getCreateDate() {
		return createDate;
	}

	public void setCreateDate(Date createDate) {
		this.createDate = createDate;
	}

	@Transient
	public String getCreateUserName() {
		return createUserName;
	}

	public void setCreateUserName(String createUserName) {
		this.createUserName = createUserName;
	}
}
