package com.yeejoin.amos.spc.dao.entity;


import com.yeejoin.amos.op.core.util.DateUtil;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.io.Serializable;
import java.util.Date;

/**
 * 
 * <pre>
 * 三维节点与规则消息实体视图
 * </pre>
 *
 * @author amos
 * @version $Id: NodeMessageView.java, v 0.1 2019年1月2日 下午2:39:52 amos Exp $
 */
@Entity
@Table(name = "toip_biz_message")
public class NodeMessageView implements Serializable
{

	/**
	 * <pre>
	 * 
	 * </pre>
	 */
	private static final long serialVersionUID = 292329658525267887L;

	@Id
	private String id;
	/**
	 * 时间
	 */
	private Date time;
	
	@Transient
	private String timeStr;
	/**
	 * 标题
	 */
	private String title;
	/**
	 * 内容
	 */
	private String content;
	/**
	 * 类型
	 */
	private String type;
	/**
	 * 发送者
	 */
	private String sender;
	/**
	 * 接收者
	 */
	private String receiver;
	/**
	 * 已读者
	 */
	private String reader;
	/**
	 * 业务id
	 */
	private String bizId;
	/**
	 * 业务员实体名，例如com.yeejoin.amos.toip.bizrulebridge.entity.Fire
	 */
	private String bizclassName;
	/**
	 * 组织机构（公司+部门），多个通过“，”进行隔开
	 */
	private String orgCode;

	public String getId()
	{
		return id;
	}

	public void setId(String id)
	{
		this.id = id;
	}

	public Date getTime()
	{
		return time;
	}

	public void setTime(Date time)
	{
		this.time = time;
	}

	public String getTitle()
	{
		return title;
	}

	public void setTitle(String title)
	{
		this.title = title;
	}

	public String getContent()
	{
		return content;
	}

	public void setContent(String content)
	{
		this.content = content;
	}

	public String getType()
	{
		return type;
	}

	public void setType(String type)
	{
		this.type = type;
	}

	public String getSender()
	{
		return sender;
	}

	public void setSender(String sender)
	{
		this.sender = sender;
	}

	public String getReceiver()
	{
		return receiver;
	}

	public void setReceiver(String receiver)
	{
		this.receiver = receiver;
	}

	public String getReader()
	{
		return reader;
	}

	public void setReader(String reader)
	{
		this.reader = reader;
	}

	public String getBizId()
	{
		return bizId;
	}

	public void setBizId(String bizId)
	{
		this.bizId = bizId;
	}

	public String getTimeStr()
	{
		return DateUtil.getDateTimeFormat(this.time);
	}

	public String getBizclassName()
	{
		return bizclassName;
	}

	public void setBizclassName(String bizclassName)
	{
		this.bizclassName = bizclassName;
	}

	public String getOrgCode()
	{
		return orgCode;
	}

	public void setOrgCode(String orgCode)
	{
		this.orgCode = orgCode;
	}

}
