package com.yeejoin.amos.spc.dao.entity;

import java.math.BigInteger;
import java.util.Date;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;


/**
 * The persistent class for the spc_taskwork database table.
 * 
 */
@Entity
@Table(name="spc_taskwork")
@NamedQuery(name="SpcTaskwork.findAll", query="SELECT s FROM SpcTaskwork s")
public class SpcTaskwork extends BasicEntity  {
	private static final long serialVersionUID = 1L;

	/**
	 * 申请时间
	 */
	@Temporal(TemporalType.TIMESTAMP)
	@Column(name="apply_date")
	private Date applyDate;

	/**
	 * 申请人部门编号
	 */
	@Column(name="apply_department_id")
	private String applyDepartmentId;

	/**
	 * 申请人
	 */
	@Column(name="apply_user_id")
	private String applyUserId;

	/**
	 * 创建人
	 */
	@Column(name="creator_id")
	private String creatorId;

	/**
	 * 当前工作流记录编号
	 */
	@Column(name="current_flow_record_id")
	private BigInteger currentFlowRecordId;

	/**
	 * 部门编号
	 */
	@Column(name="department_id")
	private String departmentId;
	
	/**
	 * 违章状态1-无违章；2-一般违章；3-严重违章
	 */
	@Column(name="violate_state")
	private Long violateState = 1L;

	public Long getViolateState() {
		return violateState;
	}

	public void setViolateState(Long violateState) {
		this.violateState = violateState;
	}

	/**
	 * 班组
	 */
	@Column(name="group_id")
	private String groupId;

	/**
	 * 工作流实例编号
	 */
	@Column(name="instance_id")
	private String instanceId;

	/**
	 * 是否被监控 
	 */
	@Column(name="is_monitor")
	private Boolean isMonitor = false;

	/**
	 * 作业活动名称
	 */
	private String name;

	/**
	 * 机构
	 */
	@Column(name="org_code")
	private String orgCode;

	/**
	 * 部位
	 */
	private String part;

	/**
	 * 岗位
	 */
	private String post;

	/**
	 * 所在分区
	 */
	@Column(name="region_id")
	private String regionId;

	/**
	 * 风险等级id
	 */
	@Column(name="risk_level_id")
	private Long riskLevelId;

	/**
	 * 作业活动状态（0：未启动；1：待作业活动申请；2：待班组审核；3：待车间/部门审核；4：待公司审核；5：待执行；6：待确认验收；7：完成）
	 */
	private int status =0;

	/**
	 * 作业活动类型
	 */
	private String type;
	
	/**
	 * 更新时间
	 */
	@Temporal(TemporalType.DATE)
	@Column(name="update_date")
	private Date updateDate;
	
	/**
	 * 楼层
	 */
	private String floor3d;
	
	/**
	 * -177.0789,0,21.6566(x,y,z)
	 */
	private String position3d;

	@Column(name = "is_indoor")
	private Boolean isIndoor = true;

	private String applyDepartmentName;
	
	private String applyUserName;
	
	private String departmentName;
	
	private String groupName;
	
	private String regionName;

	@Column(name="taskwork_substance")
	private String taskworkSubstance;

	@Column(name="work_rate")
	private String workRate;

	@Column(name="equipment_id")
	private Long equipmentId;

	@Column(name="taskwork_address")
	private String taskworkAddress;
	
	private List<SpcTaskworkContent> contentList;

	private String equipmentName;

	private String workshopSection;

	private String equipmentCode;
	
	public SpcTaskwork() {
	}

	public Date getApplyDate() {
		return this.applyDate;
	}

	public void setApplyDate(Date applyDate) {
		this.applyDate = applyDate;
	}

	public String getApplyDepartmentId() {
		return this.applyDepartmentId;
	}

	public void setApplyDepartmentId(String applyDepartmentId) {
		this.applyDepartmentId = applyDepartmentId;
	}

	public String getApplyUserId() {
		return this.applyUserId;
	}

	public void setApplyUserId(String applyUserId) {
		this.applyUserId = applyUserId;
	}

	public String getCreatorId() {
		return this.creatorId;
	}

	public void setCreatorId(String creatorId) {
		this.creatorId = creatorId;
	}

	public BigInteger getCurrentFlowRecordId() {
		return this.currentFlowRecordId;
	}

	public void setCurrentFlowRecordId(BigInteger currentFlowRecordId) {
		this.currentFlowRecordId = currentFlowRecordId;
	}

	public String getDepartmentId() {
		return this.departmentId;
	}

	public void setDepartmentId(String departmentId) {
		this.departmentId = departmentId;
	}

	public String getGroupId() {
		return this.groupId;
	}

	public void setGroupId(String groupId) {
		this.groupId = groupId;
	}

	public String getInstanceId() {
		return this.instanceId;
	}

	public void setInstanceId(String instanceId) {
		this.instanceId = instanceId;
	}

	public Boolean getIsMonitor() {
		return this.isMonitor;
	}

	public void setIsMonitor(Boolean isMonitor) {
		this.isMonitor = isMonitor;
	}

	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getOrgCode() {
		return this.orgCode;
	}

	public void setOrgCode(String orgCode) {
		this.orgCode = orgCode;
	}

	public String getPart() {
		return this.part;
	}

	public void setPart(String part) {
		this.part = part;
	}

	public String getPost() {
		return this.post;
	}

	public void setPost(String post) {
		this.post = post;
	}

	public String getRegionId() {
		return this.regionId;
	}

	public void setRegionId(String regionId) {
		this.regionId = regionId;
	}

	public Long getRiskLevelId() {
		return this.riskLevelId;
	}

	public void setRiskLevelId(Long riskLevelId) {
		this.riskLevelId = riskLevelId;
	}

	public int getStatus() {
		return this.status;
	}

	public void setStatus(int status) {
		this.status = status;
	}

	public String getType() {
		return this.type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public Date getUpdateDate() {
		return this.updateDate;
	}

	public void setUpdateDate(Date updateDate) {
		this.updateDate = updateDate;
	}
	
	@Transient
	public List<SpcTaskworkContent> getContentList() {
		return contentList;
	}

	public void setContentList(List<SpcTaskworkContent> contentList) {
		this.contentList = contentList;
	}

	@Transient
	public String getApplyDepartmentName() {
		return applyDepartmentName;
	}

	public void setApplyDepartmentName(String applyDepartmentName) {
		this.applyDepartmentName = applyDepartmentName;
	}

	@Transient
	public String getApplyUserName() {
		return applyUserName;
	}

	public void setApplyUserName(String applyUserName) {
		this.applyUserName = applyUserName;
	}

	@Transient
	public String getDepartmentName() {
		return departmentName;
	}

	public void setDepartmentName(String departmentName) {
		this.departmentName = departmentName;
	}

	@Transient
	public String getGroupName() {
		return groupName;
	}

	public void setGroupName(String groupName) {
		this.groupName = groupName;
	}

	@Transient
	public String getRegionName() {
		return regionName;
	}

	public void setRegionName(String regionName) {
		this.regionName = regionName;
	}
	
	public String getFloor3d() {
		return floor3d;
	}

	public void setFloor3d(String floor3d) {
		this.floor3d = floor3d;
	}

	public String getPosition3d() {
		return position3d;
	}

	public void setPosition3d(String position3d) {
		this.position3d = position3d;
	}

	public Boolean getIsIndoor() {
		return isIndoor;
	}

	public void setIsIndoor(Boolean isIndoor) {
		this.isIndoor = isIndoor;
	}

	public String getTaskworkSubstance() {
		return taskworkSubstance;
	}

	public void setTaskworkSubstance(String taskworkSubstance) {
		this.taskworkSubstance = taskworkSubstance;
	}

	public String getWorkRate() {
		return workRate;
	}

	public void setWorkRate(String workRate) {
		this.workRate = workRate;
	}

	public Long getEquipmentId() {
		return equipmentId;
	}

	public void setEquipmentId(Long equipmentId) {
		this.equipmentId = equipmentId;
	}

	public String getTaskworkAddress() {
		return taskworkAddress;
	}

	public void setTaskworkAddress(String taskworkAddress) {
		this.taskworkAddress = taskworkAddress;
	}

	@Transient
	public String getEquipmentName() {
		return equipmentName;
	}

	public void setEquipmentName(String equipmentName) {
		this.equipmentName = equipmentName;
	}

	@Transient
	public String getWorkshopSection() {
		return workshopSection;
	}

	public void setWorkshopSection(String workshopSection) {
		this.workshopSection = workshopSection;
	}

	@Transient
	public String getEquipmentCode() {
		return equipmentCode;
	}

	public void setEquipmentCode(String equipmentCode) {
		this.equipmentCode = equipmentCode;
	}
}