package com.yeejoin.amos.bank.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.bank.dao.BankInfoDao;
import com.yeejoin.amos.bank.dao.mapper.BankInfoMapper;
import com.yeejoin.amos.bank.entity.BankInfo;
import com.yeejoin.amos.bank.webSocket.AmosWsClient;
import com.yeejoin.amos.bank.webSocket.WebsocketParam;
import com.yeejoin.amos.spc.core.util.StringUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.component.emq.EmqKeeper;
import org.typroject.tyboot.component.emq.EmqxListener;

import java.util.Map;

@Component
public class EquipmentListener extends EmqxListener implements InitializingBean {

    private final Logger logger = LogManager.getLogger(EquipmentListener.class);

    @Autowired
    private EmqKeeper emqKeeper;

    @Autowired
    private BankInfoMapper bankInfoMapper;

    @Autowired
    private AmosWsClient client;

    /**
     * 监听主题
     */
    @Override
    public void afterPropertiesSet() throws Exception {
        emqKeeper.subscript(CommTopic.AISLE_DEVICE.getTopic(), 2, this);
    }

    /**
     * 接收主题下的消息
     */
    @Override
    public void processMessage(String s, MqttMessage mqttMessage) throws Exception {
        blueprintMsgtransfer(mqttMessage);
    }


    /**
     * 消息处理
     *
     * @param mqttMessage
     */
    private void blueprintMsgtransfer(MqttMessage mqttMessage) {
        try {
            String jsonStr = new String(mqttMessage.getPayload());
            logger.info(">>>>>>>>>>>>>>>>>jsonStr", jsonStr);
            JSONArray jsonArray = JSON.parseObject(jsonStr).getJSONArray("metricDatas");
            if (ObjectUtils.isEmpty(jsonArray)) {
                return;
            }
//            JSONArray eqpConfig = parseObject.getJSONArray("eqpConfigMap");
//            JSONObject eqpConfigValue = JSONObject.parseObject(eqpConfig.getString(0));
//            String sourceName = eqpConfigValue.getString("valueStr");

            jsonArray.forEach(e -> {
                JSONObject object = (JSONObject) e;
                Long eqpId = object.getLong("eqpId");
                String string = object.getString("metricJson");
                if (!StringUtil.isNotEmpty(string)) {
                    return;
                }
                logger.error(">>>>>>>>>>>>>>>>>string", string);
                JSONObject metricJson = JSONObject.parseObject(string);
                String communication = metricJson.get("communication").toString();
                int status = communication.equals("正常") ? 0 : 1;
                int sourceIdStatus = bankInfoMapper.findBySourceId(eqpId);
                if (status != sourceIdStatus) {
                    bankInfoMapper.updateBySourceId(status, eqpId);

                    Map<String, Object> resultMap = bankInfoMapper.selectBankInfoBySourceId(eqpId);
                    resultMap.put("eqpId", eqpId);
                    pushAisleAlarm(resultMap);
                    logger.info("=======aisle状态有变化=====");
                }
            });
        } catch (Exception e) {
            logger.error("消息流转报错.");
            logger.error(e.getMessage(), e);
            e.printStackTrace();
        }
    }

    /**
     * 发送通道刷新标识
     */
    public void pushAisleAlarm(Map<String, Object> result) {
        WebsocketParam param = new WebsocketParam("aisleAlarm", JSON.toJSONString(result));
        client.sendMessage(param);
    }
}
