package com.yeejoin.amos.bank.controller;

import com.yeejoin.amos.bank.dao.mapper.mo.MaintenanceDutyMo;
import com.yeejoin.amos.bank.entity.MaintenanceDuty;
import com.yeejoin.amos.bank.params.WarnParam;
import com.yeejoin.amos.bank.service.MaintenanceDutyService;
import com.yeejoin.amos.op.core.common.response.CommonResponse;
import com.yeejoin.amos.op.core.util.CommonResponseUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.List;

/**
 * @Author: xinglei
 * @Description: 运维值班API
 * @Date: 2019/12/9 16:17
 */
@RestController
@RequestMapping(value = "/bank/duty")
@Api(value = "/bank/duty", tags = {"运维值班API"})
public class MaintenanceDutyController {

    @Autowired
    private MaintenanceDutyService dutyService;

    @GetMapping(value = "/dutyList", produces = "application/json;charset=UTF-8")
    @ApiOperation(value = "获取今日值班列表", notes = "获取今日值班列表")
    public CommonResponse getDutyList() {
        List<MaintenanceDuty> todayDuty = dutyService.getTodayDuty();
        return CommonResponseUtil.success(todayDuty);
    }
    
    @GetMapping(value = "/middleHeader", produces = "application/json;charset=UTF-8")
    @ApiOperation(value = "获取首页值班信息", notes = "获取首页值班信息")
    public CommonResponse middleHeader() {
        HashMap<String, Object> data = dutyService.getMiddleHeader();
        return CommonResponseUtil.success(data);
    }
    
    @GetMapping(value = "/middleTableList", produces = "application/json;charset=UTF-8")
    @ApiOperation(value = "获取首页二级人员值班信息列表", notes = "获取首页二级人员值班信息列表")
    public CommonResponse middleTableList(@ApiParam(value = "", required = false) Integer pageNumber,
    									@ApiParam(value = "", required = false) Integer pageSize) {
    	HashMap<String, Object> data = dutyService.middleTableList(pageNumber,pageSize);
        return CommonResponseUtil.success(data);
    }
}
