package com.yeejoin.amos.bank.controller;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.typroject.tyboot.core.foundation.context.RequestContext;

import com.yeejoin.amos.component.feign.config.InnerInvokException;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.op.core.common.response.CommonResponse;
import com.yeejoin.amos.op.core.util.CommonResponseUtil;
import com.yeejoin.amos.spc.business.controller.BaseController;
import com.yeejoin.amos.spc.business.remote.RemoteSecurityService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

@RestController
@RequestMapping(value = "/bank")
@Api(value = "/bank", tags = {"新平台请求数据API测试"})
public class TestController extends BaseController {

    private final Logger log = LoggerFactory.getLogger(TestController.class);

//    @Autowired
//    RemoteSecurityService service;

    /**
     * 请求数据API测试
     *
     * @return API测试
     * @throws InnerInvokException 
     */
    @GetMapping(value = "/test", produces = "application/json;charset=UTF-8")
    @ApiOperation(value = "API测试", notes = "API测试")
    public CommonResponse getAlarms() throws InnerInvokException {
    	ServletRequestAttributes attributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        String token = request.getHeader("token");
        String product = request.getHeader("product");
        String appKey = request.getHeader("appKey");
        RequestContext.setToken(token);
    	RequestContext.setProduct(product);
    	RequestContext.setAppKey(appKey);
        AgencyUserModel result = Privilege.agencyUserClient.getme().getResult();
        return CommonResponseUtil.success(result);
    }

    
}
