package com.yeejoin.amos.bank.controller;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.bank.common.enums.TopoNodeTypeEnum;
import com.yeejoin.amos.bank.dto.TopographyEventDTO;
import com.yeejoin.amos.bank.dto.TopographyLineDTO;
import com.yeejoin.amos.bank.dto.TopographyNodeDTO;
import com.yeejoin.amos.bank.dto.TopographyTreeDTO;
import com.yeejoin.amos.bank.param.AbnormalParam;
import com.yeejoin.amos.bank.service.ITopographyService;
import com.yeejoin.amos.op.core.common.response.CommonResponse;
import com.yeejoin.amos.op.core.util.CommonResponseUtil;
import com.yeejoin.amos.spc.business.controller.BaseController;
import com.yeejoin.amos.spc.business.param.ReginParams;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

/**
 * 拓扑图Controller
 *
 * @author zhangzhihui
 */
@RestController
@RequestMapping(value = "/bank/topography")
@Api(value = "/bank/topography", tags = {"拓扑图API"})
public class TopographyController extends BaseController {

    @Autowired
    private ITopographyService topographyService;
    
    /**
     * 拓扑图-树
     *
     * @param type 节点类型
     * @return 
     */
    @GetMapping(value = "/tree", produces = "application/json;charset=UTF-8")
    @ApiOperation(value = "拓扑图-树", notes = "拓扑图-树")
    public CommonResponse tree() {
    	//获取当前登录人的公司code
    	ReginParams reginParams	=getSelectedOrgInfo();
    	List<TopographyTreeDTO> list = topographyService.getTree(reginParams.getCompany().getOrgCode(),TopoNodeTypeEnum.PAMS.getType());
        return CommonResponseUtil.success(list);
    }
    
    
    /**
     * 拓扑图
     *
     * @param type 节点类型
     * @return 
     */
    @GetMapping(value = "/nodes/{treeid}", produces = "application/json;charset=UTF-8")
    @ApiOperation(value = "拓扑图", notes = "拓扑图")
    public CommonResponse getNodesByTreeid(@ApiParam(value = "树id", required = false) @PathVariable String treeid) {
    	//获取当前登录人的公司code
    	ReginParams reginParams	=getSelectedOrgInfo();	
    	List<TopographyNodeDTO> nodes = topographyService.getNodes(reginParams.getCompany().getOrgCode(),treeid,TopoNodeTypeEnum.PAMS.getType());
    	List<TopographyLineDTO> links = topographyService.getLinks(reginParams.getCompany().getOrgCode(),treeid,TopoNodeTypeEnum.PAMS.getType());
    	Map<String,Object> results = new HashMap<>();
    	results.put("nodeData", nodes);
    	results.put("linkData", links);
    	return CommonResponseUtil.success(results);
    }
    
    /**
     * 自建系统树
     *
     * @param type 节点类型
     * @return 
     */
    @GetMapping(value = "/selftree", produces = "application/json;charset=UTF-8")
    @ApiOperation(value = "拓扑图-树", notes = "拓扑图-树")
    public CommonResponse selfTree() {
    	//获取当前登录人的公司code
    	ReginParams reginParams	=getSelectedOrgInfo();
    	List<TopographyTreeDTO> list = topographyService.getTree(reginParams.getCompany().getOrgCode(),TopoNodeTypeEnum.自建系统.getType());
        return CommonResponseUtil.success(list);
    }
    
    /**
     * 自建系统拓扑图
     *
     * @param type 节点类型
     * @return 
     */
    @GetMapping(value = "/selfnodes/{treeid}", produces = "application/json;charset=UTF-8")
    @ApiOperation(value = "拓扑图", notes = "拓扑图")
    public CommonResponse getSelfNodesByTreeid(@ApiParam(value = "树id", required = false) @PathVariable String treeid) {
    	//获取当前登录人的公司code
    	ReginParams reginParams	=getSelectedOrgInfo();	
    	List<TopographyNodeDTO> nodes = topographyService.getNodes("%#"+reginParams.getCompany().getOrgCode(),treeid,TopoNodeTypeEnum.自建系统.getType());
    	List<TopographyLineDTO> links = topographyService.getLinks(reginParams.getCompany().getOrgCode(),treeid,TopoNodeTypeEnum.自建系统.getType());
    	Map<String,Object> results = new HashMap<>();
    	results.put("nodeData", nodes);
    	results.put("linkData", links);
    	return CommonResponseUtil.success(results);
    }
    
    
    /**
     * 保存自建系统
     *
     * @param type 节点类型
     * @return 
     */
    @PostMapping(value = "/selfnodes", produces = "application/json;charset=UTF-8")
    @ApiOperation(value = "保存动环拓扑图", notes = "保存动环拓扑图")
    public CommonResponse saveselfnodes(@ApiParam(value = "", required = false) @RequestBody JSONObject topography) {
    	JSONArray nodes = topography.getJSONArray("nodeData");
    	List<TopographyNodeDTO> nodeData = JSON.parseArray(JSON.toJSONString(nodes), TopographyNodeDTO.class);
    	
    	        //获取当前登录人的公司code
    			ReginParams reginParams	=getSelectedOrgInfo();
    			if(reginParams.getDepartment()!=null){
    				topographyService.saveNodes(topographyService.getSelfOrgCode(),nodeData);
    			}else{
    				topographyService.saveNodes(topographyService.getSelfOrgCode(),nodeData);
    				
    			}
    	
    	return CommonResponseUtil.success();
    }
    
    
    /**
     * 保存拓扑图
     *
     * @param type 节点类型
     * @return 
     */
    @PostMapping(value = "/nodes", produces = "application/json;charset=UTF-8")
    @ApiOperation(value = "保存拓扑图", notes = "保存拓扑图")
    public CommonResponse saveNodes(@ApiParam(value = "", required = false) @RequestBody JSONObject topography) {
    	JSONArray nodes = topography.getJSONArray("nodeData");
    	List<TopographyNodeDTO> nodeData = JSON.parseArray(JSON.toJSONString(nodes), TopographyNodeDTO.class);
    	 //获取当前登录人的公司code
		ReginParams reginParams	=getSelectedOrgInfo();
		if(reginParams.getDepartment()!=null){
			topographyService.saveNodes(reginParams.getDepartment().getOrgCode(),nodeData);
		}else{
			topographyService.saveNodes(reginParams.getCompany().getOrgCode(),nodeData);
			
		}    	
		return CommonResponseUtil.success();
    }
    
    /**
     * 异常
     *
     * @return 
     * @throws Exception 
     */
    @PostMapping(value = "/testAbnormal", produces = "application/json;charset=UTF-8")
    @ApiOperation(value = "推送异常", notes = "推送异常")
    public CommonResponse testAbnormal(@RequestBody AbnormalParam param) throws Exception {
    	topographyService.testAbnormal(param);
        return CommonResponseUtil.success();
    }
    
    /**
     * 拓扑图-事件
     *
     * @return 
     */
    @GetMapping(value = "/events", produces = "application/json;charset=UTF-8")
    @ApiOperation(value = "拓扑图-事件", notes = "拓扑图-事件")
    public CommonResponse events() {
    	List<TopographyEventDTO> list = topographyService.getEvents();
    	return CommonResponseUtil.success(list);
    }
    
    /**
     * 网络拓扑图-树
     *
     * @param type 节点类型
     * @return 
     */
    @GetMapping(value = "/webTree", produces = "application/json;charset=UTF-8")
    @ApiOperation(value = "网络拓扑图-树", notes = "网络拓扑图-树")
    public CommonResponse webTree() {  	
    	//获取当前登录人的公司code
		ReginParams reginParams	=getSelectedOrgInfo();	
    	List<TopographyTreeDTO> list = topographyService.getTree(reginParams.getCompany().getOrgCode(),TopoNodeTypeEnum.网络拓扑图.getType());
        return CommonResponseUtil.success(list);
    }
    
    /**
     * 网络拓扑图
     *
     * @param type 节点类型
     * @return 
     */
    @GetMapping(value = "/webNodes/{treeid}", produces = "application/json;charset=UTF-8")
    @ApiOperation(value = "网络拓扑图", notes = "拓扑图")
    public CommonResponse webNodes(@ApiParam(value = "树id", required = false) @PathVariable String treeid) {
    	
    	//获取当前登录人的公司code
    			ReginParams reginParams	=getSelectedOrgInfo();	
    	
    	List<TopographyNodeDTO> nodes = topographyService.getNodes(reginParams.getCompany().getOrgCode(),treeid,1);
    	List<TopographyLineDTO> links = topographyService.getLinks(reginParams.getCompany().getOrgCode(),treeid,1);
    	Map<String,Object> results = new HashMap<>();
    	results.put("nodeData", nodes);
    	results.put("linkData", links);
    	return CommonResponseUtil.success(results);
    }
    
    @DeleteMapping("/webTree/{treeid}")
	@ApiOperation(value = "删除树数据", notes = "删除树数据")
	public CommonResponse delWebTree(@ApiParam(value = "树id", required = false) @PathVariable String treeid) {
    	topographyService.delWebTree(treeid);
    	//获取当前登录人的公司code
    	ReginParams reginParams	=getSelectedOrgInfo();
		return CommonResponseUtil.success(topographyService.getTree(reginParams.getCompany().getOrgCode(),TopoNodeTypeEnum.网络拓扑图.getType()));
	}
	
	@PostMapping("/addWebTree")
	@ApiOperation(value = "添加树数据", notes = "添加树数据")
	public CommonResponse addWebTree(@RequestBody TopographyTreeDTO tree) {
		//获取当前登录人的公司code
		ReginParams reginParams	=getSelectedOrgInfo();
		if(reginParams.getDepartment()!=null){
			tree.setOrgCode(reginParams.getDepartment().getOrgCode());
		}else{
			tree.setOrgCode(reginParams.getCompany().getOrgCode());
		}
		
		topographyService.addWebTree(tree);
		
		return CommonResponseUtil.success(topographyService.getTree(reginParams.getCompany().getOrgCode(),TopoNodeTypeEnum.网络拓扑图.getType()));
	}
	
	/**
     * 保存网络拓扑图
     *
     * @param type 节点类型
     * @return 
     */
    @PostMapping(value = "/webNodes", produces = "application/json;charset=UTF-8")
    @ApiOperation(value = "保存网络拓扑图", notes = "保存网络拓扑图")
    public CommonResponse saveWebNodes(@ApiParam(value = "", required = false) @RequestBody JSONObject topography) {
    	JSONArray nodes = topography.getJSONArray("nodeData");
    	List<TopographyNodeDTO> nodeData = JSON.parseArray(JSON.toJSONString(nodes), TopographyNodeDTO.class);
    	 //获取当前登录人的公司code
		ReginParams reginParams	=getSelectedOrgInfo();
		if(reginParams.getDepartment()!=null){
			topographyService.saveNodes(reginParams.getDepartment().getOrgCode(),nodeData);
		}else{
			topographyService.saveNodes(reginParams.getCompany().getOrgCode(),nodeData);
			
		}
    	return CommonResponseUtil.success();
    }
    
    /**
     * 节点详情
     *
     * @param type 节点类型
     * @return 
     */
    @GetMapping(value = "/nodeDetail/{nodeid}", produces = "application/json;charset=UTF-8")
    @ApiOperation(value = "节点详情", notes = "节点详情")
    public CommonResponse nodeDetail(@ApiParam(value = "nodeid", required = false) @PathVariable String nodeid) {
    	Object nodeDetail = topographyService.getNodeDetail(nodeid);
    	return CommonResponseUtil.success(nodeDetail);
    }
    
    /**
     * 动环拓扑图-树
     *
     * @param type 节点类型
     * @return 
     */
    @GetMapping(value = "/donghuanTree", produces = "application/json;charset=UTF-8")
    @ApiOperation(value = "动环拓扑图-树", notes = "动环拓扑图-树")
    public CommonResponse donghuanTree() {
    	//获取当前登录人的公司code
    	ReginParams reginParams	=getSelectedOrgInfo();
    	List<TopographyTreeDTO> list = topographyService.getTree("%#"+reginParams.getCompany().getOrgCode(),TopoNodeTypeEnum.动环监控.getType());
        return CommonResponseUtil.success(list);
    }
    
    /**
     * 动环拓扑图
     *
     * @param type 节点类型
     * @return 
     */
    @GetMapping(value = "/donghuanNodes/{treeid}", produces = "application/json;charset=UTF-8")
    @ApiOperation(value = "动环拓扑图", notes = "拓扑图")
    public CommonResponse donghuanNodes(@ApiParam(value = "树id", required = false) @PathVariable String treeid) {
    	//获取当前登录人的公司code
    	ReginParams reginParams	=getSelectedOrgInfo();
    	List<TopographyNodeDTO> nodes = topographyService.getNodes("%#"+reginParams.getCompany().getOrgCode(),treeid,TopoNodeTypeEnum.动环监控.getType());
    	List<TopographyLineDTO> links = topographyService.getLinks(reginParams.getCompany().getOrgCode(),treeid,TopoNodeTypeEnum.动环监控.getType());
    	Map<String,Object> results = new HashMap<>();
    	results.put("nodeData", nodes);
    	results.put("linkData", links);
    	return CommonResponseUtil.success(results);
    }
    
    /**
     * 保存动环拓扑图
     *
     * @param type 节点类型
     * @return 
     */
    @PostMapping(value = "/donghuanNodes", produces = "application/json;charset=UTF-8")
    @ApiOperation(value = "保存动环拓扑图", notes = "保存动环拓扑图")
    public CommonResponse savedonghuanNodes(@ApiParam(value = "", required = false) @RequestBody JSONObject topography) {
    	JSONArray nodes = topography.getJSONArray("nodeData");
    	List<TopographyNodeDTO> nodeData = JSON.parseArray(JSON.toJSONString(nodes), TopographyNodeDTO.class);
    	
    	       //获取当前登录人的公司code
    			ReginParams reginParams	=getSelectedOrgInfo();
    			if(reginParams.getDepartment()!=null){
    				topographyService.saveNodes(topographyService.getSelfOrgCode(),nodeData);
    			}else{
    				topographyService.saveNodes(topographyService.getSelfOrgCode(),nodeData);
    				
    			}
    	
    	return CommonResponseUtil.success();
    }
    
    /**
     * 获取设备监控拓扑图
     *
     * @param type 节点类型
     * @return 
     */
    @GetMapping(value = "/deviceNodes", produces = "application/json;charset=UTF-8")
    @ApiOperation(value = "设备监控拓扑图", notes = "设备监控拓扑图")
    public CommonResponse deviceNodes() {
    	//获取当前登录人的公司code
    	ReginParams reginParams	=getSelectedOrgInfo();
    	List<Map> nodes = topographyService.getDeviceNodes(reginParams.getCompany().getOrgCode());    	
    	List<TopographyLineDTO> links = topographyService.getDeviceLinks(reginParams.getCompany().getOrgCode());
    	Map<String,Object> results = new HashMap<>();
    	results.put("nodeData", nodes);
    	results.put("linkData", links);
    	return CommonResponseUtil.success(results);
    }
    
    /**
     * 保存设备监控拓扑图
     *
     * @param type 节点类型
     * @return 
     */
    @PostMapping(value = "/deviceNodes", produces = "application/json;charset=UTF-8")
    @ApiOperation(value = "保存设备监控拓扑图", notes = "保存设备监控拓扑图")
    public CommonResponse saveDeviceNodes(@ApiParam(value = "", required = false) @RequestBody JSONObject topography) {
    	JSONArray nodes = topography.getJSONArray("nodeData");
    	List<TopographyNodeDTO> nodeData = JSON.parseArray(JSON.toJSONString(nodes), TopographyNodeDTO.class);
    	
    	
    	//获取当前登录人的公司code
		ReginParams reginParams	=getSelectedOrgInfo();
		if(reginParams.getDepartment()!=null){
			topographyService.saveNodes(topographyService.getSelfOrgCode(),nodeData);
		}else{
			topographyService.saveNodes(topographyService.getSelfOrgCode(),nodeData);
			
		}
    	return CommonResponseUtil.success();
    }

	/**
	 *查询-树
	 *
	 * @param type 类型
	 * @return
	 */
	@GetMapping(value = "/treeByType/{type}", produces = "application/json;charset=UTF-8")
	@ApiOperation(value = "查询-树", notes = "查询-树")
	public CommonResponse treeByType(@ApiParam(value = "查询类型：1-网络拓扑图；2-PAMS；3-动环监控；4-设备监控；5-自建系统；6-金融城域网；7-虚拟云平台监控", required = true)
										 @PathVariable int type) {
		//获取当前登录人的公司code
		ReginParams reginParams	=getSelectedOrgInfo();
		List<TopographyTreeDTO> list = topographyService.getTree(reginParams.getCompany().getOrgCode(), type);
		return CommonResponseUtil.success(list);
	}

	/**
	 * 查询拓扑图
	 *
	 * @param type 节点类型
	 * @return
	 */
	@GetMapping(value = "/getNodesByTypeAndTreeId/{type}/{treeId}", produces = "application/json;charset=UTF-8")
	@ApiOperation(value = "拓扑图", notes = "拓扑图")
	public CommonResponse getNodesByTypeAndTreeId(@ApiParam(value = "类型", required = true) @PathVariable int type,
			@ApiParam(value = "树id", required = false) @PathVariable String treeId) {
		//获取当前登录人的公司code
		ReginParams reginParams	=getSelectedOrgInfo();
		List<TopographyNodeDTO> nodes = topographyService.getNodes("%#"+reginParams.getCompany().getOrgCode(),treeId,type);
		List<TopographyLineDTO> links = topographyService.getLinks(reginParams.getCompany().getOrgCode(),treeId,type);
		Map<String,Object> results = new HashMap<>();
		results.put("nodeData", nodes);
		results.put("linkData", links);
		return CommonResponseUtil.success(results);
	}

	/**
	 * 保存自建系统
	 *
	 * @param type 节点类型
	 * @return
	 */
	@PostMapping(value = "/saveNodesByType/{type}", produces = "application/json;charset=UTF-8")
	@ApiOperation(value = "保存动环拓扑图", notes = "保存动环拓扑图")
	public CommonResponse saveNodesByType(@ApiParam(value = "类型", required = true) @PathVariable int type,
										  @ApiParam(value = "", required = false) @RequestBody JSONObject topography) {
		JSONArray nodes = topography.getJSONArray("nodeData");
		List<TopographyNodeDTO> nodeData = JSON.parseArray(JSON.toJSONString(nodes), TopographyNodeDTO.class);
		//获取当前登录人的公司code
		ReginParams reginParams	=getSelectedOrgInfo();
		if(reginParams.getDepartment()!=null){
			topographyService.saveNodes(topographyService.getSelfOrgCode(),nodeData);
		}else{
			topographyService.saveNodes(topographyService.getSelfOrgCode(),nodeData);
		}
		return CommonResponseUtil.success();
	}
}
