package com.yeejoin.amos.bank.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.bank.dao.entity.Alarm;
import com.yeejoin.amos.bank.dao.repository.IAlarmRepository;
import com.yeejoin.amos.bank.entity.AlarmExcel;
import com.yeejoin.amos.bank.entity.PageModel;
import com.yeejoin.amos.bank.params.WarnParam;
import com.yeejoin.amos.bank.service.WarnService;
import com.yeejoin.amos.op.core.common.query.DaoCriteria;
import com.yeejoin.amos.spc.core.common.request.CommonPageable;
import com.yeejoin.amos.spc.core.common.request.CommonRequest;
import com.yeejoin.amos.spc.core.enums.QueryOperatorEnum;
import com.yeejoin.amos.spc.core.util.StringUtil;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * @Author: xinglei
 * @Description: TODO()
 * @Date: 2019/12/3 19:35
 */
@Service
public class WarnServiceImpl implements WarnService {
	
	private static final Logger log = Logger.getLogger(WarnServiceImpl.class);

	@Value(value = "classpath:json/warn.json")
	private Resource resource;

	@Autowired
	private IAlarmRepository iAlarmDao;

	private String getJSON() {
		String result = null;
		try {
			BufferedReader br = new BufferedReader(new InputStreamReader(resource.getInputStream()));
			StringBuffer message = new StringBuffer();
			String line = null;
			while ((line = br.readLine()) != null) {
				message.append(line);
			}
			String defaultString = message.toString();
			result = defaultString.replace("\r\n", "").replaceAll(" +", "");

		} catch (IOException e) {
			log.error("read warn.json fail");
		}
		return result;
	}

	@Override
	public PageModel getWarningsByPage(WarnParam param) {
		String arrayStr = getJSON();
		JSONArray jsonArray = JSON.parseArray(arrayStr);

		JSONArray arr = new JSONArray();
		PageModel pageModel = new PageModel();

		if (!ObjectUtils.isEmpty(param.getName())) {
			JSONArray result = new JSONArray();
			for (Object obj : jsonArray) {
				JSONObject jobj = (JSONObject) obj;
				if (jobj.get("name").toString().contains(param.getName())) {
					result.add(obj);
				}
			}
			jsonArray = result;
		}

		if (param.getCurrent() > 1) {
			for (int i = (10 * (param.getCurrent() - 1)); i < jsonArray.size(); i++) {
				arr.add(jsonArray.get(i));
			}
		} else {
			if (jsonArray.size() > 10) {
				for (int i = 0; i < 10; i++) {
					arr.add(jsonArray.get(i));
				}
			} else {
				for (int i = 0; i < jsonArray.size(); i++) {
					arr.add(jsonArray.get(i));
				}
			}
		}

		pageModel.setCurrPage(param.getCurrent());
		pageModel.setPageSize(param.getPageSize());
		pageModel.setTotal(jsonArray.size());
		pageModel.setDataList(arr);
		return pageModel;
	}

	@Override
	public List<AlarmExcel> getAlarmExcel() {
		List<AlarmExcel> alarmExcels = new ArrayList<>();
		List<Alarm> alarms = iAlarmDao.findAll();

		alarms.forEach(x ->{
			AlarmExcel alarmExcel1 = new AlarmExcel();
			alarmExcel1.setId(x.getId());
			alarmExcel1.setSourceId(x.getSourceId());
			alarmExcel1.setAlarmLevel(x.getAlarmLevel());
			alarmExcel1.setAlarmReason(x.getAlarmReason());
			alarmExcel1.setAlarmSourceIp(x.getAlarmSourceIp());
			alarmExcel1.setAlarmSourceName(x.getAlarmSourceName());
			alarmExcel1.setAlarmSourceType(x.getAlarmSourceType());
			alarmExcel1.setCurrentState(x.getCurrentState());
			alarmExcel1.setHappenDate(x.getHappenDate());
			alarmExcel1.setContinueDate(x.getContinueDate());
			alarmExcel1.setEnsureDate(x.getEnsureDate());
			alarmExcel1.setEnsurePerson(x.getEnsurePerson());
			alarmExcel1.setClearDate(x.getClearDate());
			alarmExcel1.setClearPerson(x.getClearPerson());
			alarmExcels.add(alarmExcel1);
		});

		return alarmExcels;
	}

	@Override
	public JSONArray getWarnings() {
		String arrayStr = getJSON();
		JSONArray jsonArray = JSON.parseArray(arrayStr);
		return jsonArray;
	}

}
