package com.yeejoin.amos.spc.business.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.yeejoin.amos.bank.dao.entity.Alarm;
import com.yeejoin.amos.bank.service.IAlarmService;
import com.yeejoin.amos.op.core.common.query.DaoCriteria;
import com.yeejoin.amos.op.core.common.response.CommonResponse;
import com.yeejoin.amos.op.core.util.CommonResponseUtil;
import com.yeejoin.amos.spc.business.param.ReginParams;
//import com.yeejoin.amos.security.common.authorization.Authorization;
import com.yeejoin.amos.spc.business.service.intfc.ISpcEvaluateModelService;
import com.yeejoin.amos.spc.core.common.request.CommonPageable;
import com.yeejoin.amos.spc.core.common.request.CommonRequest;
import com.yeejoin.amos.spc.core.enums.QueryOperatorEnum;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;


@RestController
@RequestMapping(value = "/alarm")
@Api(tags = "告警信息")
public class AlarmController extends BaseController {

    @Autowired
    private IAlarmService iAlarmService;

    @ApiOperation(httpMethod = "POST", value = "模型列表页面查询", notes = "模型列表页面查询")
    @PostMapping(value = "/alarmPage", produces = "application/json;charset=UTF-8")

    public CommonResponse queryPage(
            @ApiParam(value = "查询条件")
            @RequestBody(required = false) List<CommonRequest> queryRequests,
            @ApiParam(value = "分页参数", required = true) CommonPageable commonPageable) {
          
    	//获取当前登录人的公司code
		ReginParams reginParams	=getSelectedOrgInfo();
		DaoCriteria criteria =new DaoCriteria();
		criteria.setValue( reginParams.getCompany().getOrgCode() + "%");
		criteria.setOperator(QueryOperatorEnum.LIKE.getName());
		criteria.setPropertyName("orgCode");
    	
        List<DaoCriteria> criterias = buildDaoCriterias(queryRequests);
        criterias.add(criteria);
        Sort sort = new Sort(Sort.Direction.DESC, "updateDate");
        commonPageable.setSort(sort);
        Page<Alarm> list = iAlarmService.list(criterias, commonPageable);
        return CommonResponseUtil.success(list);

    }

    @SuppressWarnings("unused")
    //@Authorization(ingore = true)
    @ApiOperation(value = "巡检点统计", notes = "首页统计")
    @PostMapping(value = "/mobile/getcountxd")
    public CommonResponse getcountxd(@RequestBody Map<String, String> maps) {
//        String code = "";
//        if (!maps.isEmpty()) {
//            code = maps.get("code");
//        }
        
        //获取当前登录人公司orgcode
        ReginParams reginParams =getSelectedOrgInfo();
        
        String code=reginParams.getCompany().getOrgCode();
        

        List<Map<String, Object>> listdate2 = new ArrayList<>();
        List<String> listd = new ArrayList<>();
        listd.add("紧急告警");
        listd.add("重要告警");
        listd.add("次要告警");
        listd.add("警告告警");
        List<Map<String, Object>> listdate1 = new ArrayList<>();
        List<Object[]> list = iAlarmService.countnum(code);
        List<Map<String, Object>> listdate = new ArrayList<>();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                Map<String, Object> map = new HashMap<>();
                Object[] h = list.get(i);
                map.put("name", h[1]);
                map.put("value", h[0]);
                listdate.add(map);
            }
        }

        if (listdate != null && listdate.size() > 0) {
            if (listdate.size() == 4) {
                for (int i = 0; i < listd.size(); i++) {
                    for (int j = 0; j < listdate.size(); j++) {
                        if (listd.get(i).equals(listdate.get(j).get("name"))) {
                            listdate2.add(listdate.get(j));
                        }
                    }
                }

                return CommonResponseUtil.success(listdate2);
            } else {
                for (int i = 0; i < listd.size(); i++) {
                    Map<String, Object> map = new HashMap<>();
                    for (int k = 0; k < listdate.size(); k++) {
                        if ((listd.get(i) + "").equals(listdate.get(k).get("name") + "")) {
                            map = listdate.get(k);
                            continue;
                        }
                    }

                    if (map.isEmpty()) {
                        map.put("value", 0);
                        if ((listd.get(i) + "").equals("紧急告警")) {
                            map.put("name", "紧急告警");
                        } else if ((listd.get(i) + "").equals("重要告警")) {
                            map.put("name", "重要告警");
                        } else if ((listd.get(i) + "").equals("警告告警")) {
                            map.put("name", "警告告警");
                        } else {
                            map.put("name", "次要告警");
                        }
                    }
                    listdate1.add(map);
                }
            }
        } else {
            for (int i = 1; i < 5; i++) {
                HashMap<String, Object> map = new HashMap<>();
                if (map.isEmpty()) {
                    map.put("value", 0);
                    if (i == 1) {
                        map.put("name", "紧急告警");
                    } else if (i == 2) {
                        map.put("name", "重要告警");
                    } else if (i == 3) {
                        map.put("name", "警告告警");
                    } else {
                        map.put("name", "次要告警");
                    }
                }

                listdate1.add(map);
            }
        }

        //排序
        if (listdate1 != null && listdate1.size() > 0) {
            for (int i = 0; i < listd.size(); i++) {
                for (int j = 0; j < listdate1.size(); j++) {
                    if (listd.get(i).equals(listdate1.get(j).get("name"))) {
                        listdate2.add(listdate1.get(j));
                    }
                }
            }
        }

        return CommonResponseUtil.success(listdate2);
    }
}