package com.yeejoin.amos.spc.business.controller;

import java.util.List;
import java.util.Map;

import org.assertj.core.util.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.yeejoin.amos.feign.privilege.model.DepartmentModel;
import com.yeejoin.amos.op.core.common.response.CommonResponse;
import com.yeejoin.amos.op.core.util.CommonResponseUtil;
import com.yeejoin.amos.spc.business.param.ReginParams;
import com.yeejoin.amos.spc.business.remote.RemoteWebSocketServer;
import com.yeejoin.amos.spc.business.service.intfc.ISpcSecurityService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

@RestController
@RequestMapping(value = "/api/spcSecurity")
@Api(tags = "安全模块相关")
public class SpcSecurityController extends BaseController {

    @Autowired
    private ISpcSecurityService iSpcSecurityService;
    
    @Autowired
    private RemoteWebSocketServer remoteWebSocketServer;
    

    @ApiOperation(value = "获取部门下属部门", notes = "获取部门下属部门")
    @GetMapping(value = "/department/listTree")
    public CommonResponse listDepartmentTree() {
    	  ReginParams reginParams = getSelectedOrgInfo();
          List<DepartmentModel> list = iSpcSecurityService.listDepartmentTree(getCompanyId(reginParams));
          List<DepartmentModel> firstDepartments = Lists.newArrayList();
        Map<String, List<DepartmentModel>> secondDepartments = Maps.newHashMap();
        Map<String, List<DepartmentModel>> thirdDepartments = Maps.newHashMap();
        list.forEach(e -> {
            DepartmentModel DepartmentModel = new DepartmentModel();
            DepartmentModel.setCompanySeq(e.getCompanySeq());
            DepartmentModel.setDepartmentDesc(e.getDepartmentDesc());
            DepartmentModel.setDepartmentName(e.getDepartmentName());
            DepartmentModel.setSequenceNbr(e.getSequenceNbr());
            firstDepartments.add(DepartmentModel);
            List<DepartmentModel> childs = (List<DepartmentModel>) e.getChildren();
            if (!CollectionUtils.isEmpty(childs) && childs.size() > 0) {
                List<DepartmentModel> childDepartments = Lists.newArrayList();
                for (DepartmentModel c : childs) {
                    DepartmentModel departmentChildBo = new DepartmentModel();
                    departmentChildBo.setCompanySeq(c.getCompanySeq());
                    departmentChildBo.setDepartmentDesc(c.getDepartmentDesc());
                    departmentChildBo.setDepartmentName(c.getDepartmentName());
                    departmentChildBo.setSequenceNbr(c.getSequenceNbr());
                    childDepartments.add(departmentChildBo);
                    
                    List<DepartmentModel> children = (List<DepartmentModel>) c.getChildren();
                    if (!CollectionUtils.isEmpty(children) && children.size() > 0) {
                    	List<DepartmentModel> thirdChildren = Lists.newArrayList();
                    	for (DepartmentModel d : children) {
                    		DepartmentModel deptChildBo = new DepartmentModel();
                    		deptChildBo.setCompanySeq(d.getCompanySeq());
                    		deptChildBo.setDepartmentDesc(d.getDepartmentDesc());
                    		deptChildBo.setDepartmentName(d.getDepartmentName());
                    		deptChildBo.setSequenceNbr(d.getSequenceNbr());
                    		thirdChildren.add(deptChildBo);
                    	}
                    	thirdDepartments.put(String.valueOf(c.getSequenceNbr()), thirdChildren);
                    }
                }
                secondDepartments.put(String.valueOf(e.getSequenceNbr()), childDepartments);
            }
        });
        JSONObject json = new JSONObject();
        json.put("firstDepartments", firstDepartments);
        json.put("secondDepartments", secondDepartments);
        json.put("thirdDepartments", thirdDepartments);
        return CommonResponseUtil.success(json);
    }

    @ApiOperation(value = "获取公司下所有人", notes = "获取公司下所有人")
    @GetMapping(value = "/user/listAll")
    public CommonResponse listAllUser() {
    	ReginParams reginParams = getSelectedOrgInfo();
        String companyId = getCompanyId(reginParams);
        return CommonResponseUtil.success(iSpcSecurityService.listUserByCompanyId(companyId));
    }

    @ApiOperation(value = "推送webstock", notes = "推送webstock")
    @GetMapping(value = "/pushMessage/{type}")
    public CommonResponse pushMessage(@PathVariable String type) {
		try {
			remoteWebSocketServer.wsDataRefresh(type);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
        return CommonResponseUtil.success();
    }

}
