package com.yeejoin.amos.spc.business.dao.repository;

import java.util.List;

import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import com.yeejoin.amos.spc.dao.entity.SpcRiskLevel;
@Repository("iSpcRiskLevelDao")
public interface ISpcRiskLevelDao extends BaseDao<SpcRiskLevel, Long>{
	
	/**
	 * 根据风险模型查找等级个数
	 * @param evaluateMethodId
	 * @return
	 */
	public int countByEvaluateModelId(Long evaluateModelId);




	@Query(value = "select * from spc_risk_level where `lower` <= ?1 and `upper` >= ?1 and evaluate_model_id = ?2 ", nativeQuery = true)
	SpcRiskLevel findByLowerAndUpper(int value, Long evaluateModelId);



	/**
	 * 根据风险模型查询等级
	 * @param evModelId
	 */
	public List<SpcRiskLevel> findByEvaluateModelId(Long evModelId);

	/**
	 * 根据等级和模型id 查询
	 * @param level
	 * @param evaluateModelId
	 * @return
	 */
	public List<SpcRiskLevel> findByLevelAndEvaluateModelId(String level, Long evaluateModelId);


}
