package com.yeejoin.amos.spc.business.dao.repository;

import java.util.List;

import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import com.yeejoin.amos.spc.dao.entity.SpcTaskworkContent;
import org.springframework.transaction.annotation.Transactional;

@Repository("iSpcTaskworkContentDao")
public interface ISpcTaskworkContentDao extends BaseDao<SpcTaskworkContent, Long> {

	List<SpcTaskworkContent> findAllByTaskworkId(Long taskworkId);

	@Modifying
	@Transactional
	@Query(value = "delete from spc_taskwork_content where taskwork_id = ?1", nativeQuery = true)
	void deleteByTaskworkId(Long taskworkId);

	@Query(value = "SELECT COUNT(1) FROM spc_taskwork_content WHERE risk_level_id = ?1", nativeQuery = true)
	int countByRiskLevelId(String id);

}
