package com.yeejoin.amos.spc.business.service.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

import org.assertj.core.util.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.CompanyModel;
import com.yeejoin.amos.feign.privilege.model.DepartmentModel;
import com.yeejoin.amos.op.core.common.response.CommonResponse;
import com.yeejoin.amos.op.core.util.CommonResponseUtil;
import com.yeejoin.amos.spc.bo.RiskFactorBo;
import com.yeejoin.amos.spc.business.constants.FasConstant;
import com.yeejoin.amos.spc.business.dao.mapper.RiskFactorMapper;
import com.yeejoin.amos.spc.business.dao.mapper.RiskJudgmentFillRecordMapper;
import com.yeejoin.amos.spc.business.dao.repository.ISpcRiskFactorDao;
import com.yeejoin.amos.spc.business.dao.repository.ISpcRiskFactorsCmDao;
import com.yeejoin.amos.spc.business.dao.repository.ISpcRiskFactorsLevelLogDao;
import com.yeejoin.amos.spc.business.dao.repository.ISpcRiskJudgmentTaskDao;
import com.yeejoin.amos.spc.business.dao.repository.ISpcRiskLevelDao;
import com.yeejoin.amos.spc.business.dao.repository.ISpcRiskSourceDao;
import com.yeejoin.amos.spc.business.dao.repository.ISpcTaskworkContentDao;
import com.yeejoin.amos.spc.business.dao.repository.ISpcTaskworkDao;
import com.yeejoin.amos.spc.business.dao.repository.ISpcTaskworkMeasureDao;
import com.yeejoin.amos.spc.business.feign.RemoteRuleServer;
import com.yeejoin.amos.spc.business.param.RiskFactorControlObjectParam;
import com.yeejoin.amos.spc.business.remote.RemoteSecurityService;
import com.yeejoin.amos.spc.business.remote.RemoteWebSocketServer;
import com.yeejoin.amos.spc.business.rulemodel.RiskFactorRo;
import com.yeejoin.amos.spc.business.service.intfc.ISpcRiskFactorService;
import com.yeejoin.amos.spc.common.enums.FactorsItemFlagEnum;
import com.yeejoin.amos.spc.common.enums.PatrolSynOperationTypeEnum;
import com.yeejoin.amos.spc.common.enums.RiskFactorsCmStatusEnum;
import com.yeejoin.amos.spc.common.enums.RiskFactorsFlowStatusEnum;
import com.yeejoin.amos.spc.common.enums.RiskFactorsTypeEnum;
import com.yeejoin.amos.spc.common.enums.RiskJudgmentStatusEnum;
import com.yeejoin.amos.spc.common.enums.RiskLevelEnum;
import com.yeejoin.amos.spc.common.enums.TaskworkStateEnum;
import com.yeejoin.amos.spc.common.enums.WorkFlowActionTypeEnum;
import com.yeejoin.amos.spc.core.common.request.ControlMeasuresRequest;
import com.yeejoin.amos.spc.core.common.request.RiskFactorImproveRequest;
import com.yeejoin.amos.spc.core.util.DateUtil;
import com.yeejoin.amos.spc.core.util.StringUtil;
import com.yeejoin.amos.spc.dao.entity.SpcRiskFactor;
import com.yeejoin.amos.spc.dao.entity.SpcRiskFactorsCm;
import com.yeejoin.amos.spc.dao.entity.SpcRiskFactorsLevelLog;
import com.yeejoin.amos.spc.dao.entity.SpcRiskJudgmentTask;
import com.yeejoin.amos.spc.dao.entity.SpcRiskLevel;
import com.yeejoin.amos.spc.dao.entity.SpcRiskSource;
import com.yeejoin.amos.spc.dao.entity.SpcTaskwork;
import com.yeejoin.amos.spc.dao.entity.SpcTaskworkContent;
import com.yeejoin.amos.spc.dao.entity.SpcTaskworkMeasure;


@Service("iSpcRiskFactorService")
public class SpcRiskFactorServiceImpl implements ISpcRiskFactorService {

    private final Logger log = LoggerFactory.getLogger(SpcRiskFactorServiceImpl.class);

    @Autowired
    private RemoteSecurityService remoteSecurityService;

//    @Autowired
//    private RemoteWorkFlowService remoteWorkFlowService;

//    @Autowired
//    private RemotePatrolService remotePatrolService;

    @Autowired
    private ISpcRiskFactorDao iSpcRiskFactorDao;

    @Autowired
    private RemoteRuleServer remoteRuleServer;

    @Autowired
    private RiskFactorMapper riskFactorMapper;

    @Autowired
    private ISpcRiskFactorsLevelLogDao iSpcRiskFactorsLevelLogDao;

    @Autowired
    private ISpcRiskFactorsCmDao iSpcRiskFactorsCmDao;

    @Autowired
    private ISpcTaskworkContentDao iSpcTaskworkContentDao;

    @Autowired
    private ISpcTaskworkDao iSpcTaskworkDao;

    @Autowired
    private ISpcRiskSourceDao iSpcRiskSourceDao;

    @Autowired
    private ISpcRiskLevelDao iSpcRiskLevelDao;

    @Autowired
    private ISpcTaskworkMeasureDao iSpcTaskworkMeasureDao;
    
    @Autowired
    private ISpcRiskJudgmentTaskDao iSpcRiskJudgmentTaskDao;
    
    @Autowired
    private RemoteWebSocketServer remoteWebSocketServer;
    @Autowired
    private RiskJudgmentFillRecordMapper riskJudgmentFillRecordMapper;

    @Override
    public void bindEquipment(List<RiskFactorControlObjectParam> params) {
        for (RiskFactorControlObjectParam param : params) {
            SpcRiskFactor riskFactor = iSpcRiskFactorDao.findById(param.getRiskFactorId()).get();
            riskFactor.setType(FasConstant.CONTROL_OBJECT_EQUIPMENT);
            riskFactor.setControlObjectId(param.getControlObjectId());
            riskFactor.setControlObjectName(param.getControlObjectName());
            iSpcRiskFactorDao.save(riskFactor);
        }
    }
    

    @Override
    public CommonResponse startBatchFlow(List<Long> ids, String userId, String companyId, String departmentId, String token) {
        Date date = new Date();
        List<String> strs = Lists.newArrayList();
//        for (Long id : ids) {
//            SpcRiskFactor spcRiskFactor = iSpcRiskFactorDao.findOne(id);
//            if (RiskFactorsFlowStatusEnum.执行中.getCode().equals(spcRiskFactor.getStatus())) {
//                strs.add(spcRiskFactor.getName() + "【" + spcRiskFactor.getId() + "】执行中");
//                continue;
//            }
//            if (spcRiskFactor.getType().equals(RiskFactorsTypeEnum.equipment.getCode())) {
//                if (spcRiskFactor.getControlObjectId().equals(0L) || spcRiskFactor.getControlObjectId() == null) {
//                    strs.add(spcRiskFactor.getName() + "【" + spcRiskFactor.getId() + "】需绑定设备");
//                    continue;
//                }
//            } else if (spcRiskFactor.getType().equals(RiskFactorsTypeEnum.taskwork.getCode())) {
//                if (spcRiskFactor.getControlObjectId().equals(0L) || spcRiskFactor.getControlObjectId() == null) {
//                    strs.add(spcRiskFactor.getName() + "【" + spcRiskFactor.getId() + "】需绑定作业活动步骤");
//                    continue;
//                }
//            } else {
//                continue;
//            }
//            WorkFlowDefinitionKeyEnum definitionKeyEnum = WorkFlowDefinitionKeyEnum.getByKey(spcRiskFactor.getType());
//            if (definitionKeyEnum == null) {
//                continue;
//            }
//            String flowOrderNo = StringUtil.buildOrderNo();
//            JSONObject request = buildRiskFactorRequestBody(flowOrderNo, definitionKeyEnum.getProcessDefinitionKey(), spcRiskFactor.getId(), companyId, departmentId);
//            JSONObject startJson = remoteWorkFlowService.start(request, token);
//            if (startJson == null) {
//                continue;
//            }
//            Long instanceId = startJson.getJSONObject("dataList").getLong("id");
//            spcRiskFactor.setStatus(RiskFactorsFlowStatusEnum.执行中.getCode());
//            spcRiskFactor.setFlowOrderNo(flowOrderNo);
//            spcRiskFactor.setEvaluateId(instanceId);
//            spcRiskFactor.setStartFlowTime(date);
//            spcRiskFactor.setStartFlowUserId(userId);
//            spcRiskFactor.setStartFlowDepartmentId(departmentId);
//            iSpcRiskFactorDao.save(spcRiskFactor);
//        }
        return CommonResponseUtil.success(strs);
    }

    private JSONObject buildRiskFactorRequestBody(String businessKey, String processDefinitionKey, Long riskFactorsId, String companyId, String departmentId) {
        JSONObject body = new JSONObject();
        body.put("businessKey", businessKey);
        body.put("processDefinitionKey", processDefinitionKey);
        JSONArray variables = new JSONArray();
        JSONObject riskFactorJson = new JSONObject();
        riskFactorJson.put("name", "risk_factors_id");
        riskFactorJson.put("value", riskFactorsId);
        JSONObject companyJson = new JSONObject();
        companyJson.put("name", "companyId");
        companyJson.put("value", companyId);
        JSONObject departmentJson = new JSONObject();
        departmentJson.put("name", "departmentId");
        departmentJson.put("value", departmentId);
        variables.add(riskFactorJson);
        variables.add(companyJson);
        variables.add(departmentJson);
        body.put("variables", variables);
        return body;
    }

    @Override
    public CommonResponse getByInstanceIdOfEquipment(Long instanceId) {
        RiskFactorBo riskFactorBo = riskFactorMapper.getByInstanceIdOfEquipment(instanceId);
        if (riskFactorBo == null) {
            return CommonResponseUtil.failure("风险因素不存在");
        }
        if (!riskFactorBo.getType().equals(RiskFactorsTypeEnum.equipment.getCode())) {
            return CommonResponseUtil.failure("管控对象类型有误");
        }
        String departmentId = riskFactorBo.getEquipmentDepartmentId();
        String regionDepartmentId = riskFactorBo.getRegionId();
        String startFlowDepartmentId = riskFactorBo.getStartFlowDepartmentId();
        String belongCompanyId = riskFactorBo.getBelongDepartmentId();
        Set<String> deptIds = Sets.newHashSet();
        deptIds.add(departmentId);
        deptIds.add(regionDepartmentId);
        deptIds.add(startFlowDepartmentId);
        AgencyUserModel startUser = remoteSecurityService.getUserById(riskFactorBo.getStartFlowUserId());
        CompanyModel companyBo = remoteSecurityService.getCompanyById(belongCompanyId);
        List<DepartmentModel> DepartmentModels = remoteSecurityService.listDepartmentByDeptIds(Joiner.on(",").join(deptIds));
        Map<Long, DepartmentModel> DepartmentModelMap = Maps.uniqueIndex(DepartmentModels, DepartmentModel::getSequenceNbr);
        DepartmentModel startFlowDepartment = DepartmentModelMap.get(startFlowDepartmentId);
        DepartmentModel euqipmentDepartment = DepartmentModelMap.get(departmentId);
        DepartmentModel euqipmentRegionDepartment = DepartmentModelMap.get(regionDepartmentId);
        JSONObject result = new JSONObject();
        JSONObject baseInfo = new JSONObject();
        baseInfo.put("orderNo", riskFactorBo.getFlowOrderNo());
        baseInfo.put("userName", startUser.getRealName());
        baseInfo.put("startTime", riskFactorBo.getStartFlowTime());
        baseInfo.put("department", startFlowDepartment.getDepartmentName());
        JSONObject riskInfo = new JSONObject();
        riskInfo.put("regionName", euqipmentRegionDepartment.getDepartmentName());
        riskInfo.put("equipmentDepartmentName", euqipmentDepartment.getDepartmentName());
        riskInfo.put("workshopSection", riskFactorBo.getWorkshopSection());
        riskInfo.put("equipmentName", riskFactorBo.getEquipmentName());
        riskInfo.put("equipmentCode", riskFactorBo.getEquipmentCode());
        riskInfo.put("riskSourceName", riskFactorBo.getRiskSourceName());
        riskInfo.put("companyName", companyBo.getCompanyName());
        riskInfo.put("identificationUserNames", riskFactorBo.getUserNames());
        riskInfo.put("identificationMethodNames", riskFactorBo.getIdentificationMethodNames());
        riskInfo.put("riskFactorName", riskFactorBo.getName());
        result.put("baseInfo", baseInfo);
        result.put("riskInfo", riskInfo);
        return CommonResponseUtil.success(result);
    }

    @Override
    public CommonResponse getByInstanceIdOfTaskwork(Long instanceId) {
        RiskFactorBo riskFactorBo = riskFactorMapper.getByInstanceIdOfTaskwork(instanceId);
        if (riskFactorBo == null) {
            return CommonResponseUtil.failure("风险因素不存在");
        }
        if (!riskFactorBo.getType().equals(RiskFactorsTypeEnum.taskwork.getCode())) {
            return CommonResponseUtil.failure("管控对象类型有误");
        }
        AgencyUserModel startUser = remoteSecurityService.getUserById(riskFactorBo.getStartFlowUserId());
        CompanyModel companyBo = remoteSecurityService.getCompanyById(riskFactorBo.getBelongDepartmentId());
        DepartmentModel DepartmentModel = remoteSecurityService.getDepartmentByDeptId(riskFactorBo.getStartFlowDepartmentId());
        List<SpcTaskworkContent> contents = iSpcTaskworkContentDao.findAllByTaskworkId(riskFactorBo.getControlObjectId());
        JSONObject result = new JSONObject();
        JSONObject baseInfo = new JSONObject();
        baseInfo.put("orderNo", riskFactorBo.getFlowOrderNo());
        baseInfo.put("userName", startUser.getRealName());
        baseInfo.put("startTime", riskFactorBo.getStartFlowTime());
        baseInfo.put("department", DepartmentModel.getDepartmentName());
        JSONObject riskInfo = new JSONObject();
        riskInfo.put("taskworkType", riskFactorBo.getTaskworkType());
        riskInfo.put("taskworkName", riskFactorBo.getTaskworkName());
        riskInfo.put("taskworkPost", riskFactorBo.getTaskworkPost());
        riskInfo.put("taskworkPart", riskFactorBo.getTaskworkPart());
        riskInfo.put("riskSourceName", riskFactorBo.getRiskSourceName());
        riskInfo.put("companyName", companyBo.getCompanyName());
        riskInfo.put("identificationUserNames", riskFactorBo.getUserNames());
        riskInfo.put("identificationMethodNames", riskFactorBo.getIdentificationMethodNames());
        riskInfo.put("riskFactorName", riskFactorBo.getName());
        riskInfo.put("contents", contents);
        result.put("baseInfo", baseInfo);
        result.put("riskInfo", riskInfo);
        return CommonResponseUtil.success(result);
    }

    @Transactional
    @Override
    public CommonResponse flowCallBackOfEquipment(RiskFactorImproveRequest request, String userId, String token) {
        WorkFlowActionTypeEnum actionType = WorkFlowActionTypeEnum.getByActionType(request.getActionType());
        if (actionType == null) {
            return CommonResponseUtil.failure("参数有误");
        }
        RiskFactorBo riskFactorBo = riskFactorMapper.getByInstanceIdOfEquipment(request.getInstanceId());
        if (riskFactorBo == null) {
            return CommonResponseUtil.failure("风险因素不存在");
        }
        if (!riskFactorBo.getType().equals(RiskFactorsTypeEnum.equipment.getCode())) {
            return CommonResponseUtil.failure("管控对象类型有误");
        }
        Long evaluateId = riskFactorBo.getEvaluateId();
        Long riskFactorId = riskFactorBo.getId();
        if (actionType.equals(WorkFlowActionTypeEnum.通过)) {
            if (!riskFactorBo.getStatus().equals(RiskFactorsFlowStatusEnum.执行中.getCode())) {
                return CommonResponseUtil.failure("执行中的流程可操作");
            }
            
            if (request.getLevelId() == null) {
            	return CommonResponseUtil.failure("风险因素等级编号不能为空");
            }
            Long count = iSpcRiskFactorsLevelLogDao.countByRiskfactorsId(riskFactorId);
            PatrolSynOperationTypeEnum operationTypeEnum = count > 0 ? PatrolSynOperationTypeEnum.修改 : PatrolSynOperationTypeEnum.新增;
            Date date = new Date();
            SpcRiskFactorsLevelLog log = new SpcRiskFactorsLevelLog();
            log.setRiskFactorsId(riskFactorId);
            SpcRiskLevel newRiskLevel = iSpcRiskLevelDao.getOne(request.getLevelId());
            if (riskFactorBo.getLevelId() != null) {
                SpcRiskLevel oldRiskLevel = iSpcRiskLevelDao.getOne(riskFactorBo.getLevelId());
                int oldLevel = Integer.valueOf(oldRiskLevel.getCode());
                int newLevel = Integer.valueOf(newRiskLevel.getCode());
                if (oldLevel > newLevel) {//上升
                    log.setType(2);
                } else if (oldLevel == newLevel) {//不变
                    log.setType(0);
                } else {//下降
                    log.setType(1);
                }
            } else {//上升
                log.setType(2);
            }
            log.setEvaluateId(evaluateId);
            log.setOldLevelId(riskFactorBo.getLevelId());
            log.setCurrentLevelId(request.getLevelId());
            log.setValue(request.getRfValue());
            log.setCreateDate(date);
            log.setIsAcceptable(request.getIsAcceptable());
            iSpcRiskFactorsLevelLogDao.save(log);
            riskFactorBo.setEvaluateModelId(newRiskLevel.getEvaluateModelId());//风险评级需要
            riskFactorBo.setLevelId(request.getLevelId());
            riskFactorBo.setRfValue(request.getRfValue());
            riskFactorBo.setEvaluateResult(request.getEvaluateResult());
            riskFactorBo.setHazardSourceClassifyId(request.getHazardSourceClassifyId());
            riskFactorBo.setAftermathIds(request.getAftermathIds());
            riskFactorBo.setStatus(RiskFactorsFlowStatusEnum.执行完成.getCode());
            riskFactorBo.setFirstEvaluateUserId(request.getFirstEvaluateUserId());
            riskFactorBo.setFirstEvaluateMothodName(request.getFirstEvaluateMothodName());
            riskFactorBo.setSecondEvaluateUserId(request.getSecondEvaluateUserId());
            riskFactorBo.setSecondEvaluateMothodName(request.getSecondEvaluateMothodName());
            riskFactorBo.setIsAcceptable(request.getIsAcceptable());
            riskFactorMapper.update(riskFactorBo);
            List<ControlMeasuresRequest> cmList = request.getControlMeasures();
            List<SpcRiskFactorsCm> riskFactorsCmList = Lists.newArrayList();
            for (ControlMeasuresRequest cm : cmList) {
                SpcRiskFactorsCm spcRiskFactorsCm = new SpcRiskFactorsCm();
                spcRiskFactorsCm.setControlMeasuresId(cm.getControlMeasuresId());
                spcRiskFactorsCm.setMeasuresContentId(cm.getMeasuresContentId());
                spcRiskFactorsCm.setEvaluateId(evaluateId);
                spcRiskFactorsCm.setStatus(RiskFactorsCmStatusEnum.Control.getCode());
                spcRiskFactorsCm.setRiskFactorsId(riskFactorId);
                spcRiskFactorsCm.setCreateDate(date);
                riskFactorsCmList.add(spcRiskFactorsCm);
            }
            iSpcRiskFactorsCmDao.saveAll(riskFactorsCmList);
//            String body = buildItemAndPointRelationRequest(riskFactorBo, riskFactorsCmList);
//            remotePatrolService.synDataToPatrol(PatrolSynUriEnum.同步巡检点和巡检项关系, operationTypeEnum, body, token);
            //风险因素评价完成以后触发规则
            this.firingRule(riskFactorBo);
        } else if (actionType.equals(WorkFlowActionTypeEnum.终止流程)) {
            riskFactorBo.setStatus(RiskFactorsFlowStatusEnum.撤销.getCode());
            riskFactorMapper.update(riskFactorBo);
        }
        
        
        
        
        
//        else if (actionType.equals(WorkFlowActionTypeEnum.唤起流程)) {
//            riskFactorBo.setStatus(RiskFactorsFlowStatusEnum.执行中.getCode());
//            riskFactorMapper.update(riskFactorBo);
//            remoteJiaodaService.wakeUpRiskFactorFlow(evaluateId.toString(), token);
//        }
//        else if (actionType.equals(WorkFlowActionTypeEnum.重启流程)) {
//            if (!riskFactorBo.getStatus().equals(RiskFactorsFlowStatusEnum.执行完成.getCode())) {
//                return CommonResponseUtil.failure("执行完成的流程可重启");
//            }
//            WorkFlowDefinitionKeyEnum definitionKeyEnum = WorkFlowDefinitionKeyEnum.getByKey(riskFactorBo.getType());
//            if (definitionKeyEnum == null) {
//                return CommonResponseUtil.failure("流程类型有误");
//            }
//            String flowOrderNo = StringUtil.buildOrderNo();
//            JSONObject startJson = remoteWorkFlowService.start(flowOrderNo, definitionKeyEnum.getProcessDefinitionKey(), riskFactorId, token);
//            if (startJson == null) {
//                return CommonResponseUtil.failure("流程启动失败");
//            }
//            Long instanceId = startJson.getJSONObject("dataList").getLong("id");
//            riskFactorBo.setStatus(RiskFactorsFlowStatusEnum.执行中.getCode());
//            riskFactorBo.setFlowOrderNo(flowOrderNo);
//            riskFactorBo.setEvaluateId(instanceId);
//            riskFactorBo.setStartFlowTime(new Date());
//            riskFactorBo.setStartFlowUserId(userId);
//            riskFactorMapper.update(riskFactorBo);
//        }
        return CommonResponseUtil.success();
    }

    private String buildItemAndPointRelationRequest(RiskFactorBo riskFactorBo, List<SpcRiskFactorsCm> cmList) {
        JSONObject json = new JSONObject();
        json.put("level", riskFactorBo.getRiskFactorLevelName());
        json.put("originalId", riskFactorBo.getRiskSourceId());
        JSONArray classifyInfo = new JSONArray();
        JSONObject classify = new JSONObject();
        classify.put("classifyOriginalId", riskFactorBo.getId());
        classify.put("name", riskFactorBo.getName());
        classifyInfo.add(classify);
        json.put("classifyInfo", classifyInfo);
        JSONArray itemInfo = new JSONArray();
        for (SpcRiskFactorsCm cm : cmList) {
            JSONObject item = new JSONObject();
            item.put("classifyOriginalIds", Lists.newArrayList(riskFactorBo.getId()));
            item.put("itemOriginalId", cm.getMeasuresContentId());
            itemInfo.add(item);
        }
        json.put("itemInfo", itemInfo);
        return json.toJSONString();
    }


    //风险因素评价完成以后触发规则
    @Async
    public boolean firingRule(RiskFactorBo riskFactorBo) {
        log.info("风险因素评级完成修改风险点等级开始+" + JSONObject.toJSONString(riskFactorBo));
        RiskFactorRo riskFactorRo = new RiskFactorRo();
        riskFactorRo.setBatchNo(UUID.randomUUID().toString());
        riskFactorRo.setComplete(true);
        riskFactorRo.setRiskFactorId(riskFactorBo.getId());
        riskFactorRo.setRiskSourceId(riskFactorBo.getRiskSourceId());
        riskFactorRo.setRiskLevelChanged(false);
        riskFactorRo.setRiskFactorName(riskFactorBo.getName());
        riskFactorRo.setEvaluationTime(DateUtil.formatDatrToStr(new Date(), "yyyy-MM-dd HH:mm:ss"));
        if (riskFactorBo.getSecondEvaluateUserId() != null) {
            AgencyUserModel AgencyUserModel = remoteSecurityService.getUserById(riskFactorBo.getSecondEvaluateUserId());
            if (AgencyUserModel != null) {
                riskFactorRo.setEvaluatorName(AgencyUserModel.getRealName());
            }
        }
        riskFactorRo.setEvaluationContent(riskFactorBo.getEvaluateResult());
        try {
            SpcRiskSource spcRiskSource = iSpcRiskSourceDao.findById(riskFactorBo.getRiskSourceId()).get();
            List<SpcRiskFactor> riskFactorList = iSpcRiskFactorDao.findByRiskSourceId(riskFactorBo.getRiskSourceId());
            log.info("风险因素评级完成修改风险点等级开始+spcRiskSource:" + JSONObject.toJSONString(spcRiskSource));
            log.info("风险因素评级完成修改风险点等级开始+riskFactorList:" + riskFactorList.size());
            if (spcRiskSource != null && !CollectionUtils.isEmpty(riskFactorList)) {


                riskFactorRo.setRiskSourceName(spcRiskSource.getName());
                //计算风险源的风险等级是否变化
                SpcRiskLevel riskLevel = this.calRiskSourceLevel(riskFactorList,riskFactorBo.getEvaluateModelId());
                if (riskLevel != null && Long.valueOf(spcRiskSource.getRiskLevel() == null ? 0 : spcRiskSource.getRiskLevel()) != riskLevel.getId()) {
                    //变更风险点的等级
                    riskFactorRo.setRiskLevelChanged(true);
                    riskFactorRo.setRiskLevel(riskLevel.getLevel());
                    spcRiskSource.setRiskLevel(riskLevel.getId());
                    iSpcRiskSourceDao.save(spcRiskSource);
                }


                //计算风险位置的风险等级是否变化
                List<SpcRiskFactor> locationRiskFactors = iSpcRiskFactorDao.findListForLocationRisk(spcRiskSource.getParentId());
                SpcRiskSource locationRisk = iSpcRiskSourceDao.findById(spcRiskSource.getParentId()).get();
                SpcRiskLevel locationRiskLevel = this.calRiskSourceLevel(locationRiskFactors,riskFactorBo.getEvaluateModelId());
                if (locationRiskLevel != null && locationRiskLevel != null && Long.valueOf(locationRisk.getRiskLevel() == null ? 0 : locationRisk.getRiskLevel()) != locationRiskLevel.getId()) {
                    riskFactorRo.setLocationLevelChanged(true);
                    locationRisk.setRiskLevel(riskLevel.getId());
                    iSpcRiskSourceDao.save(locationRisk);
                }

                //计算风险区域的风险等级是否变化
                List<SpcRiskFactor> areaRiskFactors = iSpcRiskFactorDao.findListForAreaRisk(spcRiskSource.getParentId());
                SpcRiskSource areaRisk = iSpcRiskSourceDao.findById(locationRisk.getParentId()).get();
                SpcRiskLevel areaRiskLevel = this.calRiskSourceLevel(areaRiskFactors,riskFactorBo.getEvaluateModelId());
                if (areaRiskLevel != null && Long.valueOf(areaRisk.getRiskLevel() == null ? 0 : areaRisk.getRiskLevel()) != areaRiskLevel.getId()) {
                    riskFactorRo.setAreaLevelChanged(true);
                    areaRisk.setRiskLevel(riskLevel.getId());
                    iSpcRiskSourceDao.save(areaRisk);
                }


            }
            Object result = remoteRuleServer.fireRule(riskFactorRo, "weihuaguize/riskFactor");
            //向web推送消息刷新页面
            remoteWebSocketServer.wsDataRefresh("riskSourceValue");
            this.updateSpcJudgTask();//更新风险研判统计的危险因素数量
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }


        return true;
    }


    /**
     * 更新风险研判风险点的统计
     */
    private void updateSpcJudgTask() {
    	Integer taskStatus = RiskJudgmentStatusEnum.进行中.getCode();
    	List<SpcRiskJudgmentTask> list = iSpcRiskJudgmentTaskDao.findByTaskStatusAndTaskDate(taskStatus);
    	list.forEach(task->{
    		String deptId = task.getDepartmentId();
    		Long count = 0L;
    		Map<String, Object> paramMap = new HashMap<String,Object>();
    		paramMap.put("taskId", task.getId());		
    		for(FactorsItemFlagEnum eum : FactorsItemFlagEnum.values()){
    			count = this.getCount(eum.getItemFlag(),deptId);//1.查询统计数量
    			paramMap.put("inputResult", count);
    			paramMap.put("itemFlag",eum.getItemFlag());
    			riskJudgmentFillRecordMapper.updateInputResultAndselectResult(paramMap);//2.更新统计数量 taskId + itemType
    		}
    	});
			
	}
    
	
    
    private Long getCount(String flag, String deptId) {
        Long count = null;
        switch (flag) {
            case "other_latent_danger_state_c"://重大风险-1级
                count = riskFactorMapper.countByLevelCodeAndDeptId(RiskLevelEnum.level_1.getCode(), deptId);
                break;
            case "other_latent_danger_state_d"://较大风险-2级
                count = riskFactorMapper.countByLevelCodeAndDeptId(RiskLevelEnum.level_2.getCode(), deptId);
                break;
            case "other_latent_danger_state_e"://一般风险-3级
                count = riskFactorMapper.countByLevelCodeAndDeptId(RiskLevelEnum.level_3.getCode(), deptId);
                break;
            case "other_latent_danger_state_f"://低风险-4级
                count = riskFactorMapper.countByLevelCodeAndDeptId(RiskLevelEnum.level_4.getCode(), deptId);
                break;
            default:
                break;
        }
        return count;
     }
    

	//计算风险点的风险等级是否变化
    private SpcRiskLevel calRiskSourceLevel(List<SpcRiskFactor> riskFactorList, Long evaluateModelId) throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        int maxS = 0;
        double totalL = 0;
        for (SpcRiskFactor riskFactor : riskFactorList) {

            if (StringUtils.isEmpty(riskFactor.getRfValue()))
                continue;
            Map map = objectMapper.readValue(riskFactor.getRfValue(), Map.class);
            /*if (((Integer) map.get("S")) > maxS)
                maxS = (Integer) map.get("S");

            totalL += (Integer) map.get("L");*/

            //TODO
            if (Integer.parseInt((String) map.get("S准则")) > maxS)
                maxS = Integer.parseInt((String) map.get("S准则"));

            totalL += Integer.parseInt((String) map.get("L准则"));
        }

        int valueR = new Double(maxS * (totalL / riskFactorList.size())).intValue();
        SpcRiskLevel riskLevel = iSpcRiskLevelDao.findByLowerAndUpper(valueR,evaluateModelId);
        return riskLevel;
    }

    @Override
    @Transactional
    public CommonResponse flowCallBackOfTaskwork(RiskFactorImproveRequest request, String userId, String token) {
        //0.前置校验
        WorkFlowActionTypeEnum actionType = WorkFlowActionTypeEnum.getByActionType(request.getActionType());
        if (actionType == null) {
            return CommonResponseUtil.failure("参数有误");
        }
        SpcRiskFactor riskFactor = iSpcRiskFactorDao.findByEvaluateId(request.getInstanceId());
        if (riskFactor == null) {
            return CommonResponseUtil.failure("风险因素不存在");
        }
        if (!riskFactor.getType().equals(RiskFactorsTypeEnum.taskwork.getCode())) {
            return CommonResponseUtil.failure("管控对象类型有误");
        }
        if (!StringUtil.isNotEmpty(request.getLevelId())) {
            return CommonResponseUtil.failure("风险等级编号不能为空");
        }
        Long evaluateId = riskFactor.getEvaluateId();
        Long riskFactorId = riskFactor.getId();
        if (actionType.equals(WorkFlowActionTypeEnum.通过)) {
            if (!riskFactor.getStatus().equals(RiskFactorsFlowStatusEnum.执行中.getCode())) {
                return CommonResponseUtil.failure("非执行中的流程不可操作");
            }
            
            if (request.getLevelId() == null) {
            	return CommonResponseUtil.failure("风险因素等级编号不能为空");
            }
            Date date = new Date();
            SpcRiskFactorsLevelLog log = new SpcRiskFactorsLevelLog();
            log.setRiskFactorsId(riskFactorId);
            SpcRiskLevel newRiskLevel = iSpcRiskLevelDao.findById(request.getLevelId()).get();
            if (StringUtil.isNotEmpty(riskFactor.getLevelId())) {
                SpcRiskLevel oldRiskLevel = iSpcRiskLevelDao.findById(riskFactor.getLevelId()).get();
                int oldLevel = Integer.valueOf(oldRiskLevel != null ? oldRiskLevel.getCode() : "99");
                int newLevel = Integer.valueOf(newRiskLevel.getCode());
                if (oldLevel > newLevel) {//上升
                    log.setType(2);
                } else if (oldLevel == newLevel) {//不变
                    log.setType(0);
                } else {//下降
                    log.setType(1);
                }
            } else {//上升
                log.setType(2);
            }   
            log.setEvaluateId(evaluateId);
            log.setOldLevelId(riskFactor.getLevelId());
            log.setCurrentLevelId(request.getLevelId());
            log.setValue(request.getRfValue());
            log.setCreateDate(date);
            log.setIsAcceptable(request.getIsAcceptable());
            iSpcRiskFactorsLevelLogDao.save(log);//记录等级变化日志表
            riskFactor.setEvaluateModelId(newRiskLevel.getEvaluateModelId());//风险评级需要
            riskFactor.setLevelId(request.getLevelId());
            riskFactor.setRfValue(request.getRfValue());
            riskFactor.setEvaluateResult(request.getEvaluateResult());
            riskFactor.setHazardSourceClassifyId(request.getHazardSourceClassifyId());
            riskFactor.setAftermathIds(request.getAftermathIds() == null ? "" : request.getAftermathIds());
            riskFactor.setStatus(RiskFactorsFlowStatusEnum.执行完成.getCode());
            riskFactor.setFirstEvaluateUserId(request.getFirstEvaluateUserId());
            riskFactor.setFirstEvaluateMothodName(request.getFirstEvaluateMothodName());
            riskFactor.setSecondEvaluateUserId(request.getSecondEvaluateUserId());
            riskFactor.setSecondEvaluateMothodName(request.getSecondEvaluateMothodName());
            riskFactor.setIsAcceptable(request.getIsAcceptable());
            iSpcRiskFactorDao.save(riskFactor);//更新spc_risk_factors表
            List<ControlMeasuresRequest> cmList = request.getControlMeasures();
            List<SpcRiskFactorsCm> riskFactorsCmList = Lists.newArrayList();
            for (ControlMeasuresRequest cm : cmList) {
                SpcRiskFactorsCm spcRiskFactorsCm = new SpcRiskFactorsCm();
                spcRiskFactorsCm.setControlMeasuresId(cm.getControlMeasuresId());
                spcRiskFactorsCm.setMeasuresContentId(cm.getMeasuresContentId());
                spcRiskFactorsCm.setEvaluateId(evaluateId);
                spcRiskFactorsCm.setStatus(RiskFactorsCmStatusEnum.Control.getCode());
                spcRiskFactorsCm.setRiskFactorsId(riskFactorId);
                spcRiskFactorsCm.setCreateDate(date);
                riskFactorsCmList.add(spcRiskFactorsCm);
            }
            iSpcRiskFactorsCmDao.saveAll(riskFactorsCmList);// 插入spc_risk_factors_cm
            SpcTaskworkContent taksworkContent = iSpcTaskworkContentDao.findById(riskFactor.getControlObjectId()).get();
            SpcTaskwork taskwork = iSpcTaskworkDao.findById(taksworkContent.getTaskworkId()).get();
            if (taskwork.getStatus() == TaskworkStateEnum.未启动.getCode() || taskwork.getStatus() == TaskworkStateEnum.待作业活动申请.getCode()) {//只有未启动，或者待作业活动申请，才进行控制措施同步
                List<SpcRiskFactorsCm> factorCmList = iSpcRiskFactorsCmDao.findByRiskFactorsIdAndEvaluateId(riskFactor.getId(), evaluateId);
                List<Long> measureIdList = iSpcTaskworkMeasureDao.findExistFactorMeasure(riskFactor.getId());
                if (!CollectionUtils.isEmpty(measureIdList)) {
                    iSpcTaskworkMeasureDao.deleteByIds(measureIdList);//删除在未启动前重复的评级数据
                }
                List<SpcTaskworkMeasure> measureList = Lists.newArrayList();
                for (SpcRiskFactorsCm cm : factorCmList) {
                    SpcTaskworkMeasure measure = new SpcTaskworkMeasure();
                    measure.setRiskFactorsCmId(cm.getId());
                    measure.setTaskworkContentId(taksworkContent.getId());
                    measure.setMeasuresContentId(cm.getMeasuresContentId());
                    measure.setCreateDate(new Date());
                    measureList.add(measure);
                }
                taksworkContent.setRiskLevelId(request.getLevelId());
                iSpcTaskworkContentDao.save(taksworkContent);// 更新spc_taskwork_content等级
                iSpcTaskworkMeasureDao.saveAll(measureList);// 插入spc_taskwork_measures表
                this.updateTaskworkLevel(taksworkContent,riskFactor.getEvaluateModelId());//计算危险源等级并更新危险源等级,更新spc_taskwork等级
            }
            //风险因素评价完成以后触发规则
            this.firingRuleByTakswork(riskFactor);
        } else if (actionType.equals(WorkFlowActionTypeEnum.终止流程)) {
            riskFactor.setStatus(RiskFactorsFlowStatusEnum.撤销.getCode());
            iSpcRiskFactorDao.save(riskFactor);
        }
        return CommonResponseUtil.success();
    }

    @Async
    private void firingRuleByTakswork(SpcRiskFactor riskFactor) {
        RiskFactorBo riskFactorBo = new RiskFactorBo();
        riskFactorBo.setId(riskFactor.getId());
        riskFactorBo.setRiskSourceId(riskFactor.getRiskSourceId());
        riskFactorBo.setEvaluateModelId(riskFactor.getEvaluateModelId());
        riskFactorBo.setName(riskFactor.getName());
        riskFactorBo.setSecondEvaluateUserId(riskFactor.getSecondEvaluateUserId());
        riskFactorBo.setEvaluateResult(riskFactor.getEvaluateResult());
        this.firingRule(riskFactorBo);

    }

    /**
     * 工作活动等级修改
     *
     * @param taksworkContent
     * @param evaluateModelId 
     * @return
     * @throws Exception
     */
    private Boolean updateTaskworkLevel(SpcTaskworkContent taksworkContent, Long evaluateModelId) {
        Boolean riskLevelChange = false;
        HashMap<String, Object> param = new HashMap<String, Object>();
        Long taskworkId = taksworkContent.getTaskworkId();
        param.put("type", RiskFactorsTypeEnum.taskwork.getCode());
        param.put("taskworkId", taskworkId);
        List<SpcRiskFactor> riskFactorList = riskFactorMapper.selectAllRiskFactorByTaskwork(param);
        try {
            SpcRiskLevel riskLevel = this.calRiskSourceLevel(riskFactorList,evaluateModelId);
            SpcTaskwork taskwork = iSpcTaskworkDao.findById(taskworkId).get();
            if (riskLevel != null && !riskLevel.getId().equals(taskwork.getRiskLevelId())) {
                taskwork.setRiskLevelId(riskLevel.getId());
                iSpcTaskworkDao.save(taskwork);
            }
            riskLevelChange = true;
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        return riskLevelChange;
    }

    @Override
    public void bindTaskwork(List<RiskFactorControlObjectParam> params) {
        for (RiskFactorControlObjectParam param : params) {
            SpcRiskFactor riskFactor = iSpcRiskFactorDao.findById(param.getRiskFactorId()).get();
            riskFactor.setType(FasConstant.CONTROL_OBJECT_TASKWORK);
            riskFactor.setControlObjectId(param.getControlObjectId());
            riskFactor.setControlObjectName(param.getControlObjectName());
            iSpcRiskFactorDao.save(riskFactor);
        }

    }

}
