package com.yeejoin.amos.spc.business.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.DepartmentModel;
import com.yeejoin.amos.op.core.common.response.CommonResponse;
import com.yeejoin.amos.op.core.util.CommonResponseUtil;
import com.yeejoin.amos.spc.bo.EquipmentBo;
import com.yeejoin.amos.spc.bo.RiskFactorBo;
import com.yeejoin.amos.spc.bo.RiskSourceBo;
import com.yeejoin.amos.spc.bo.RiskSourceEquipmentBo;
import com.yeejoin.amos.spc.business.dao.mapper.EquipmentMapper;
import com.yeejoin.amos.spc.business.dao.mapper.RiskFactorMapper;
import com.yeejoin.amos.spc.business.dao.mapper.RiskSourceListMapper;
import com.yeejoin.amos.spc.business.dao.mapper.RiskSourceMapper;
import com.yeejoin.amos.spc.business.param.PageParam;
import com.yeejoin.amos.spc.business.remote.RemoteSecurityService;
import com.yeejoin.amos.spc.business.service.intfc.ISpcRiskListService;
import com.yeejoin.amos.spc.common.enums.LatentDangerStateEnum;
import com.yeejoin.amos.spc.common.enums.LatentDangerTypeEnum;
import com.yeejoin.amos.spc.common.enums.PlanTypeEnum;
import com.yeejoin.amos.spc.core.common.response.DangerListResponse;
import com.yeejoin.amos.spc.core.util.DateUtil;
import com.yeejoin.amos.spc.core.util.StringUtil;

@Service
public class SpcRiskListServiceImpl implements ISpcRiskListService {

    private final Logger log = LoggerFactory.getLogger(SpcRiskListServiceImpl.class);

    @Autowired
    private RiskSourceMapper riskSourceMapper;

    @Autowired
    private RiskFactorMapper riskFactorMapper;

    @Autowired
    private EquipmentMapper equipmentMapper;

    @Autowired
    private RiskSourceListMapper riskSourceListMapper;

    @Autowired
    private RemoteSecurityService remoteSecurityService;

    @Override
    public CommonResponse listSource(PageParam pageParam) {
        List<RiskSourceBo> riskSourceBos = riskSourceMapper.listByMap(pageParam);
        if (CollectionUtils.isEmpty(riskSourceBos)) {
            return CommonResponseUtil.success(new PageImpl<>(riskSourceBos, pageParam, 0L));
        }
        Set<String> userIdsSet = Sets.newHashSet();
        riskSourceBos.forEach(riskSourceBo -> {
            userIdsSet.add(riskSourceBo.getUserId());
        });
        userIdsSet.remove(null);
        userIdsSet.remove("");
        List<AgencyUserModel> AgencyUserModels = remoteSecurityService.listUserByUserIds(Joiner.on(",").join(userIdsSet));
        Map<String, AgencyUserModel> userMap = Maps.uniqueIndex(AgencyUserModels, AgencyUserModel::getUserId);
        if (!CollectionUtils.isEmpty(AgencyUserModels)) {
            riskSourceBos.forEach(e -> {
                AgencyUserModel AgencyUserModel = userMap.get(e.getUserId());
                if (AgencyUserModel != null) {
                    e.setIdentificationUserName(AgencyUserModel.getRealName());
                }
            });
        }
        Long count = riskSourceMapper.countByMap(pageParam);
        return CommonResponseUtil.success(new PageImpl<>(riskSourceBos, pageParam, count));
    }

    @Override
    public CommonResponse listEquipment(PageParam pageParam) {
        List<EquipmentBo> equipmentBos = equipmentMapper.listByMap(pageParam);
        Long count = equipmentMapper.countByMap(pageParam);
        if (CollectionUtils.isEmpty(equipmentBos)) {
            return CommonResponseUtil.success(new PageImpl<>(equipmentBos, pageParam, 0L));
        }
        List<Long> equipmentIds = Lists.transform(equipmentBos, EquipmentBo::getId);
        List<RiskFactorBo> riskFactorBos = riskFactorMapper.listEquipmentRiskFactorByEquipmentIds(equipmentIds);
        Map<Long, List<RiskFactorBo>> stringListMap = Maps.newHashMap();
        riskFactorBos.forEach(riskFactorBo -> {
            Long equipmentId = riskFactorBo.getControlObjectId();
            if (stringListMap.containsKey(equipmentId)) {
                stringListMap.get(equipmentId).add(riskFactorBo);
            } else {
                stringListMap.put(equipmentId, Lists.newArrayList(riskFactorBo));
            }
        });
        Set<String> userIdSets = Sets.newHashSet();
        Set<String> deptIdSets = Sets.newHashSet();
        equipmentBos.forEach(e -> {
            userIdSets.add(e.getClassLeaderUserId());
            userIdSets.add(e.getCompanyLeaderUserId());
            userIdSets.add(e.getDeptLeaderUserId());
            userIdSets.add(e.getShopLeaderUserId());
            deptIdSets.add(e.getRegionId());
            deptIdSets.add(e.getDepartmentId());
        });
        userIdSets.remove(null);
        userIdSets.remove("");
        deptIdSets.remove(null);
        deptIdSets.remove("");
        List<DepartmentModel> DepartmentModels = remoteSecurityService
                .listDepartmentByDeptIds(Joiner.on(",").join(deptIdSets));
        List<AgencyUserModel> AgencyUserModels = remoteSecurityService.listUserByUserIds(Joiner.on(",").join(userIdSets));
        Map<String, AgencyUserModel> AgencyUserModelMap = Maps.uniqueIndex(AgencyUserModels, AgencyUserModel::getUserId);
        Map<Long, DepartmentModel> DepartmentModelMap = Maps.uniqueIndex(DepartmentModels, DepartmentModel::getSequenceNbr);
        List<EquipmentBo> filtered = new ArrayList<>();
        for (EquipmentBo e : equipmentBos) {
            List<RiskFactorBo> riskFactors = stringListMap.get(e.getId());
            if (!CollectionUtils.isEmpty(riskFactors)) {
                List<String> sourceNames = Lists.transform(riskFactors, RiskFactorBo::getRiskSourceName);
                List<String> levelNames = Lists.transform(riskFactors, RiskFactorBo::getRiskSourceLevel);
                e.setRiskSourceNames(Joiner.on(",").join(sourceNames));
                e.setRiskSourceLevelNames(Joiner.on(",").join(levelNames));
            }
            AgencyUserModel companyAgencyUserModel = AgencyUserModelMap.get(e.getCompanyLeaderUserId());
            if (companyAgencyUserModel != null) {
                e.setCompanyLeaderUserRealName(companyAgencyUserModel.getRealName());
            }
            AgencyUserModel deptAgencyUserModel = AgencyUserModelMap.get(e.getDeptLeaderUserId());
            if (deptAgencyUserModel != null) {
                e.setDeptLeaderUserRealName(deptAgencyUserModel.getRealName());
            }
            AgencyUserModel shopAgencyUserModel = AgencyUserModelMap.get(e.getShopLeaderUserId());
            if (shopAgencyUserModel != null) {
                e.setShopLeaderUserRealName(shopAgencyUserModel.getRealName());
            }
            AgencyUserModel classAgencyUserModel = AgencyUserModelMap.get(e.getClassLeaderUserId());
            if (classAgencyUserModel != null) {
                e.setClassLeaderUserRealName(classAgencyUserModel.getRealName());
            }
            DepartmentModel regionDepartment = DepartmentModelMap.get(e.getRegionId());
            if (regionDepartment != null) {
                e.setRegionDepartmentName(regionDepartment.getDepartmentName());
            }
            DepartmentModel department = DepartmentModelMap.get(e.getDepartmentId());
            if (department != null) {
                e.setDepartmentName(department.getDepartmentName());
            }
        }
        // equipmentBos.forEach(e -> {
        // List<RiskFactorBo> riskFactors = stringListMap.get(e.getId());
        // if (!CollectionUtils.isEmpty(riskFactors)) {
        // List<String> sourceNames = Lists.transform(riskFactors,
        // RiskFactorBo::getRiskSourceName);
        // if (!sourceNames.contains(pageParam.get("riskSourceNames"))) {
        // equipmentBos.remove(e);
        // }
        // List<String> levelNames = Lists.transform(riskFactors,
        // RiskFactorBo::getRiskSourceLevel);
        // e.setRiskSourceNames(Joiner.on(",").join(sourceNames));
        // e.setRiskSourceLevelNames(Joiner.on(",").join(levelNames));
        // }
        // AgencyUserModel AgencyUserModel = AgencyUserModelMap.get(e.getLeaderUserId());
        // if (AgencyUserModel != null) {
        // e.setLeaderUserName(AgencyUserModel.getRealName());
        // }
        // DepartmentModel regionDepartment = DepartmentModelMap.get(e.getRegionId());
        // if (regionDepartment != null) {
        // e.setRegionDepartmentName(regionDepartment.getDepartmentName());
        // }
        // DepartmentModel department = DepartmentModelMap.get(e.getDepartmentId());
        // if (department != null) {
        // e.setDepartmentName(department.getDepartmentName());
        // }
        // DepartmentModel leaderDepartment =
        // DepartmentModelMap.get(e.getLeaderDepartmentId());
        // if (leaderDepartment != null) {
        // e.setLeaderDepartmentName(leaderDepartment.getDepartmentName());
        // }
        // });
        // Long count = equipmentMapper.countByMap(pageParam);
        equipmentBos.removeAll(filtered);
        return CommonResponseUtil.success(new PageImpl<>(equipmentBos, pageParam, count));
    }

    @Override
    public CommonResponse listFactor(PageParam pageParam) {
        List<RiskFactorBo> riskFactorBos = riskFactorMapper.listByMap(pageParam);
        if (CollectionUtils.isEmpty(riskFactorBos)) {
            return CommonResponseUtil.success(new PageImpl<>(riskFactorBos, pageParam, 0L));
        }
        Set<String> deptIdSets = Sets.newHashSet();
        Set<String> userIds = Sets.newHashSet();
        riskFactorBos.forEach(e -> {
            if (StringUtil.isNotEmpty(e.getRegionId())) {
                deptIdSets.add(e.getRegionId());
            }
            if (StringUtil.isNotEmpty(e.getEquipmentDepartmentId())) {
                deptIdSets.add(e.getEquipmentDepartmentId());
            }
            if (StringUtil.isNotEmpty(e.getFirstEvaluateUserId())) {
                userIds.add(e.getFirstEvaluateUserId());
            }
            if (StringUtil.isNotEmpty(e.getSecondEvaluateUserId())) {
                userIds.add(e.getSecondEvaluateUserId());
            }
        });
        if (!deptIdSets.isEmpty()) {
            List<DepartmentModel> DepartmentModels = remoteSecurityService
                    .listDepartmentByDeptIds(Joiner.on(",").join(deptIdSets));
            List<AgencyUserModel> AgencyUserModels = remoteSecurityService.
                    listUserByUserIds(Joiner.on(",").join(userIds));
            Map<Long, DepartmentModel> DepartmentModelMap = Maps.uniqueIndex(DepartmentModels, DepartmentModel::getSequenceNbr);
            Map<String, AgencyUserModel> AgencyUserModelMap = Maps.uniqueIndex(AgencyUserModels, AgencyUserModel::getUserId);
            riskFactorBos.forEach(e -> {
                DepartmentModel regionDepartment = DepartmentModelMap.get(e.getRegionId());
                if (regionDepartment != null) {
                    e.setRegionName(regionDepartment.getDepartmentName());
                }
                DepartmentModel department = DepartmentModelMap.get(e.getEquipmentDepartmentId());
                if (department != null) {
                    e.setEquipmentDepartmentName(department.getDepartmentName());
                }
                AgencyUserModel firstUser = AgencyUserModelMap.get(e.getFirstEvaluateUserId());
                if (firstUser != null) {
                    e.setFirstEvaluateUserName(firstUser.getRealName());
                }
                AgencyUserModel secondUser = AgencyUserModelMap.get(e.getSecondEvaluateUserId());
                if (secondUser != null) {
                    e.setSecondEvaluateUserName(secondUser.getRealName());
                }
            });
        }
        Long count = riskFactorMapper.countByMap(pageParam);
        return CommonResponseUtil.success(new PageImpl<>(riskFactorBos, pageParam, count));
    }

    @Override
    public CommonResponse listSourceEquipments(PageParam pageParam) {
        List<RiskSourceEquipmentBo> riskSourceEquipmentBos = riskSourceListMapper.riskSourceListByMap(pageParam);
        Long count = riskSourceListMapper.countRiskSourceListByMap(pageParam);
        if (CollectionUtils.isEmpty(riskSourceEquipmentBos)) {
            return CommonResponseUtil.success(new PageImpl<>(riskSourceEquipmentBos, pageParam, 0L));
        }
        Set<String> userIdSets = Sets.newHashSet();
        Set<String> deptIdSets = Sets.newHashSet();
        riskSourceEquipmentBos.forEach(e -> {
            userIdSets.add(e.getIdentificationUserId());
            deptIdSets.add(e.getRegionId());
            deptIdSets.add(e.getDepartmentId());
        });
        userIdSets.remove(null);
        userIdSets.remove("");
        deptIdSets.remove(null);
        deptIdSets.remove("");
        List<DepartmentModel> DepartmentModels = remoteSecurityService
                .listDepartmentByDeptIds(Joiner.on(",").join(deptIdSets));
        List<AgencyUserModel> AgencyUserModels = remoteSecurityService.listUserByUserIds(Joiner.on(",").join(userIdSets));
        Map<String, AgencyUserModel> AgencyUserModelMap = Maps.uniqueIndex(AgencyUserModels, AgencyUserModel::getUserId);
        Map<Long, DepartmentModel> DepartmentModelMap = Maps.uniqueIndex(DepartmentModels, DepartmentModel::getSequenceNbr);
        for (RiskSourceEquipmentBo e : riskSourceEquipmentBos) {
            AgencyUserModel AgencyUserModel = AgencyUserModelMap.get(e.getIdentificationUserId());
            if (AgencyUserModel != null) {
                e.setIdentificationUserName(AgencyUserModel.getRealName());
            }
            DepartmentModel region = DepartmentModelMap.get(e.getRegionId());
            if (region != null) {
                e.setRegionName(region.getDepartmentName());
            }
            DepartmentModel department = DepartmentModelMap.get(e.getDepartmentId());
            if (department != null) {
                e.setDepartmentName(department.getDepartmentName());
            }
        }
        return CommonResponseUtil.success(new PageImpl<>(riskSourceEquipmentBos, pageParam, count));
    }

    @Override
    public Page<DangerListResponse> listDanger(PageParam pageParam) {
        List<DangerListResponse> dangerListResponseList = riskSourceListMapper.dangerListByMap(pageParam);
        Long count = riskSourceListMapper.countDangerListByMap(pageParam);
        if (CollectionUtils.isEmpty(dangerListResponseList)) {
            return new PageImpl<>(dangerListResponseList, pageParam, 0L);
        }

        return new PageImpl<>(dangerList(dangerListResponseList), pageParam, count);
    }

    private List<DangerListResponse> dangerList(List<DangerListResponse> dangerListResponseList) {
        Set<String> userIdSets = Sets.newHashSet();
        Set<String> deptIdSets = Sets.newHashSet();
        dangerListResponseList.forEach(e -> {
            userIdSets.add(e.getCheckUser());
            deptIdSets.add(e.getCheckDep());
            userIdSets.add(e.getGovernUser());
            userIdSets.add(e.getVerifyUser());
            deptIdSets.add(e.getGovernDep());
            deptIdSets.add(e.getVerifyDep());
        });
        userIdSets.remove(null);
        userIdSets.remove("");
        deptIdSets.remove(null);
        deptIdSets.remove("");
        log.info("隐患清单用户--》" + userIdSets);
        List<DepartmentModel> DepartmentModels = remoteSecurityService
                .listDepartmentByDeptIds(Joiner.on(",").join(deptIdSets));
        List<AgencyUserModel> AgencyUserModels = remoteSecurityService.listUserByUserIds(Joiner.on(",").join(userIdSets));
        Map<String, AgencyUserModel> AgencyUserModelMap = Maps.uniqueIndex(AgencyUserModels, AgencyUserModel::getUserId);
        Map<Long, DepartmentModel> DepartmentModelMap = Maps.uniqueIndex(DepartmentModels, DepartmentModel::getSequenceNbr);
        for (DangerListResponse e : dangerListResponseList) {
            AgencyUserModel checkUser = AgencyUserModelMap.get(e.getCheckUser());
            e.setCheckUser(checkUser != null ? checkUser.getRealName() : "");
            DepartmentModel checkDep = DepartmentModelMap.get(e.getCheckDep());
            e.setCheckDep(checkDep != null ? checkDep.getDepartmentName() : "");
            AgencyUserModel governUser = AgencyUserModelMap.get(e.getGovernUser());
            e.setGovernUser(governUser != null ? governUser.getRealName() : "");
            DepartmentModel governDep = DepartmentModelMap.get(e.getGovernDep());
            e.setGovernDep(governDep != null ? governDep.getDepartmentName() : "");
            AgencyUserModel verifyUser = AgencyUserModelMap.get(e.getVerifyUser());
            e.setVerifyUser(verifyUser != null ? verifyUser.getRealName() : "");
            DepartmentModel verifyDep = DepartmentModelMap.get(e.getVerifyDep());
            e.setVerifyDep(verifyDep != null ? verifyDep.getDepartmentName() : "");
            e.setDangerState(LatentDangerStateEnum.getEnumName(Integer.valueOf(e.getDangerState())));
            e.setDangerLevel("1".equals(e.getDangerLevel()) ? "一般隐患" : "重大隐患");
            e.setReformType(null == e.getReformType() ? "" : "1".equals(e.getReformType()) ? "常规整改" : "安措计划");
            e.setType("1".equals(e.getType()) ? "设备设施" : "非设备设施");
            e.setOvertimeState("0".equals(e.getOvertimeState()) ? "否" : "是");
            e.setPlanType(PlanTypeEnum.getEnumName(e.getPlanType()));
            e.setDangerType(LatentDangerTypeEnum.getEnumName(Integer.valueOf(e.getDangerType())));
            e.setDeadline(null == e.getDeadlineDate() ? "" : DateUtil.getLongDate(e.getDeadlineDate()));
            e.setGovernTime(null == e.getGovernDate() ? "" : DateUtil.getLongDate(e.getGovernDate()));
            e.setCheckTime(DateUtil.getLongDate(e.getCheckTimeDate()));
            if (StringUtil.isNotEmpty(e.getMeasures())) {
                JSONObject j = JSONObject.parseObject(e.getMeasures());
                if (StringUtil.isNotEmpty(j.get("rectMeasures"))) {
                    List<String> mesauresList = (List<String>) j.get("rectMeasures");
                    e.setMeasures(String.join(";", mesauresList));
                }

            }
        }
        return dangerListResponseList;
    }

    @Override
    public List<DangerListResponse> danger(PageParam pageParam) {
        List<DangerListResponse> dangerListResponseList = riskSourceListMapper.dangerListByMap(pageParam);
        return dangerList(dangerListResponseList);
    }

    @Override
    public CommonResponse listSourceTaskworks(PageParam pageParam) {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public CommonResponse listTaskworkFactor(PageParam pageParam) {
        // TODO Auto-generated method stub
        return null;
    }

}
