package com.yeejoin.amos.spc.business.service.intfc;

import java.util.List;

import org.springframework.data.domain.Page;

import com.yeejoin.amos.op.core.common.query.DaoCriteria;
import com.yeejoin.amos.spc.core.common.request.CommonPageable;
import com.yeejoin.amos.spc.dao.entity.SpcCameras;

public interface ISpcCameraService {
	
	/**
	 * 保存摄像机
	 * 
	 * @return
	 */
	SpcCameras saveCamera(SpcCameras cameraParam);
	
	/**
	 * 根据ID删除摄像机
	 * 
	 * @param ids
	 * @return
	 */
	List<String> deleteCameraById(List<Long> ids);
	
	/**
	 * 分页查询摄像机
	 * 
	 * @param criterias·
	 * @param commonPageable
	 * @return
	 */
	Page<SpcCameras> queryCameraByPage(List<DaoCriteria> criterias, CommonPageable commonPageable); 
}
