// @author ilex.h
import React from 'react';
import AsyncLoader from 'ray-code-split';
import TopographyView from './../view/bank/biz/topography';

// rules
const AsyncRuleConfig = (props) => <AsyncLoader load={import('amos-rules-config/lib/view')} componentProps={props} />;
const AsyncDesignCenter = (props) => <AsyncLoader load={import('amos-rules-config/lib/view/design')} componentProps={props} />;
const AsyncRuleSetting = (props) => <AsyncLoader load={import('amos-rules-config/lib/view/design/ruleSetting')} componentProps={props} />;
const AsyncRuleCondition = (props) => <AsyncLoader load={import('amos-rules-config/lib/view/design/ruleSetting/condition')} componentProps={props} />;
const AsyncRuleAction = (props) => <AsyncLoader load={import('amos-rules-config/lib/view/design/ruleSetting/action')} componentProps={props} />;
// const AsyncRootLayout = (props) => <AsyncLoader load={import('amos-rules-config/lib/view/design/rulestage')} componentProps={props} />;

const AsyncEmptyPage = props => <AsyncLoader load={import('./../view/common/page/EmptyPage')} componentProps={props} />;
const AsyncUserInfo = props => <AsyncLoader load={import('./../view/userInfo')} componentProps={props} />;
const AsyncTwoDimensionalMap = props => <AsyncLoader load={import('./../view/bank/monitor/2d')} componentProps={props} />;

const AsyncRootView = props => <AsyncLoader load={import('./../view')} componentProps={props} />;
const AsyncRootBizView = props => <AsyncLoader load={import('./../view/mainframe/BizFrame')} componentProps={props} />;
const AsyncSubConsoleView = props => <AsyncLoader load={import('./../view/mainframe/SubConsoleView')} componentProps={props} />;
const AsyncConsoleView = props => <AsyncLoader load={import('./../view/console')} componentProps={props} />;

const AsyncConfig = props => <AsyncLoader load={import('./../view/config')} componentProps={props} />;
const AsyncAutoLogin = props => <AsyncLoader load={import('./../view/autoLogin/AutoLogin')} componentProps={props} />;

const AsyncThree3dView = props => <AsyncLoader load={import('./../view/bank/3dview')} componentProps={props} />;
const AsyncRegionList = props => <AsyncLoader load={import('./../view/region')} componentProps={props} />;

const AsyncBusinessView = props => <AsyncLoader load={import('./../view/bizview/point/PointView')} componentProps={props} />;
const AsyncRiskPoint = props => <AsyncLoader load={import('./../view/bizview/riskPoint')} componentProps={props} />;
const AsyncDutyinfo = props => <AsyncLoader load={import('./../view/bizview/dutyInfo')} componentProps={props} />;
const AsyncFireequip = props => <AsyncLoader load={import('./../view/bizview/fireEquipment')} componentProps={props} />;
const AsyncPersonnel = props => <AsyncLoader load={import('./../view/bizview/personnelInfo')} componentProps={props} />;
const AsyncCheckList = props => <AsyncLoader load={import('./../view/bizview/xjcheck/CheckList')} componentProps={props} />;
const AsyncPatrol = props => <AsyncLoader load={import('./../view/bizview/point')} componentProps={props} />;
const AsyncTaskView = props => <AsyncLoader load={import('./../view/bizview/task')} componentProps={props} />;
const AsyncPointInfoView = props => <AsyncLoader load={import('./../view/bizview/pointInfo')} componentProps={props} />;


const AsyncFireResourceView = props => <AsyncLoader load={import('./../view/bizview/equipmentLedger/FireResources')} componentProps={props} />;
const AsyncEquipmentView = props => <AsyncLoader load={import('./../view/bizview/equipmentLedger/Equipment')} componentProps={props} />;
const AsyncMonitorView = props => <AsyncLoader load={import('./../view/bizview/equipmentLedger/Monitor')} componentProps={props} />;
const AsyncAlarm = props => <AsyncLoader load={import('./../view/bizview/situation/alarm/index')} componentProps={props} />;
// const AsyncRiskModel = props => <AsyncLoader load={import('./../view/bizview/preControl/riskModel')} componentProps={props} />;
// const AsyncMgtCtrlModel = props => <AsyncLoader load={import('./../view/bizview/preControl/mgtCtrlModel')} componentProps={props} />;
// const RiskModelMgt = props => <AsyncLoader load={import('./../view/bizview/safetyRiskMgt/riskModelMgt')} componentProps={props} />;
const AsyncRiskAssessment = props => <AsyncLoader load={import('./../view/bizview/situation/riskAssessment/index')} componentProps={props} />;
const AsyncFireStationMatches = props => <AsyncLoader load={import('./../view/bizview/equipmentLedger/FireResources/matchEquipment/FireStationMatches')} componentProps={props} />;
const AsyncMatchEquipment = props => <AsyncLoader load={import('./../view/bizview/equipmentLedger/Equipment/MatchEquipment')} componentProps={props} />;
const AsyncFireStrengthResourceView = props => <AsyncLoader load={import('./../view/bizview/equipmentLedger/FireResources/FireStrength')} componentProps={props} />;
const AsyncXJCtrlModel = props => <AsyncLoader load={import('../view/bizview/xunjian')} componentProps={props} />;
const AsyncDifferentiate = props => <AsyncLoader load={import('./../view/bizview/intelligentDifferentiate/DifferentiateView')} componentProps={props} />;

//风险项目插件引入
const AsyncRiskModel = props => <AsyncLoader load={import('./../view/bank/preControl/riskModel/index')} componentProps={props} />;
const AsyncMgtCtrlModel = props => <AsyncLoader load={import('./../view/bank/preControl/mgtCtrlModel/index')} componentProps={props} />;
const RiskModelMgt = props => <AsyncLoader load={import('./../view/bank/preControl/riskModelMgt/index')} componentProps={props} />;

const Cameras = props => <AsyncLoader load={import('./../view/bizview/safetyControlObj/cameras/index')} componentProps={props} />;
const CheckStandard = props => <AsyncLoader load={import('./../view/bizview/checkStandard')} componentProps={props} />;
const CheckPlan = props => <AsyncLoader load={import('./../view/bizview/checkPlan')} componentProps={props} />;
const Execute = props => <AsyncLoader load={import('./../view/bizview/execute')} componentProps={props} />;
const Identification = props => <AsyncLoader load={import('./../view/bizview/identification')} componentProps={props} />;
const Announcement = props => <AsyncLoader load={import('./../view/bizview/announcement')} componentProps={props} />;
const DailyInformation = props => <AsyncLoader load={import('./../view/bizview/dailyInformation')} componentProps={props} />;
const MytoDo = props => <AsyncLoader load={import('./../view/bizview/mytoDo')} componentProps={props} />;
const MytoHave = props => <AsyncLoader load={import('./../view/bizview/mytoHave')} componentProps={props} />;
const ProcessTo = props => <AsyncLoader load={import('./../view/bizview/processTo')} componentProps={props} />;
const JudgedSummary = props => <AsyncLoader load={import('./../view/bizview/judgedSummary')} componentProps={props} />;
const WarningCurve = props => <AsyncLoader load={import('./../view/bizview/warningCurve')} componentProps={props} />;
const WarningIndicatorConfig = props => <AsyncLoader load={import('./../view/bizview/warningIndicators')} componentProps={props} />;
const ThresholdConfig = props => <AsyncLoader load={import('./../view/bizview/thresholdConfiguration')} componentProps={props} />;
const WarningIndicatorManage = props => <AsyncLoader load={import('./../view/bizview/warningIndicatorManage')} componentProps={props} />;

const TaskWork = props => <AsyncLoader load={import('./../view/bizview/safetyControlObj/taskwork')} componentProps={props} />;
const EquipFacilities = props => <AsyncLoader load={import('./../view/bizview/safetyControlObj/equipmentsAndFacilities')} componentProps={props} />;
const RiskKnowledgeMgt = props => <AsyncLoader load={import('./../view/bizview/safetyRiskMgt/riskKnowledgeMgt')} componentProps={props} />;
const RiskList = props => <AsyncLoader load={import('./../view/bizview/preControl/riskList/index')} componentProps={props} />;
const CheckRecordList = props => <AsyncLoader load={import('./../view/bizview/check/index')} componentProps={props} />;
const PreControlSituation = props => <AsyncLoader load={import('./../view/bizview/situation/preControl/index')} componentProps={props} />;
const DangerList = props => <AsyncLoader load={import('./../view/bizview/execute/dangerList/DangerList')} componentProps={props} />;
const TileView = props => <AsyncLoader load={import('./../view/tileView')} componentProps={props} />;


// const TopographyView = props => <AsyncLoader load={import('./../view/bank/biz/topography')} componentProps={props} />;
const VideoIframeView = props => <AsyncLoader load={import('./../view/bank/monitor/video/Video')} componentProps={props} />;//<iframe>
const VideoView = props => <AsyncLoader load={import('./../view/bank/monitor/videoLabel/Video')} componentProps={props} />;//<video>
const WarningsSituation = props => <AsyncLoader load={import('./../view/bank/situation/warn/Warnings')} componentProps={props} />;
const AsyncNetTopology = props => <AsyncLoader load={import('./../view/bank/netTopology')} componentProps={props} />;
const AsyncTopology = props => <AsyncLoader load={import('./../view/bizview/pams/index')} componentProps={props} />;
const AsyncPamsTable = props => <AsyncLoader load={import('./../view/pamsTable')} componentProps={props} />;
const AsyncDynamicRing = props => <AsyncLoader load={import('./../view/bank/dynamicRing')} componentProps={props} />;

const AsyncEqpAndMovingRing = props => <AsyncLoader load={import('./../view/bank/eqpAndMovingRing/index')} componentProps={props} />;
const AsyncEquipMonitor = props => <AsyncLoader load={import('./../view/bank/equipMonitor')} componentProps={props} />;
const AsyncSelfSupport = props => <AsyncLoader load={import('./../view/bizview/selfSupport/index')} componentProps={props} />;
const AsyncVirtualCloudPlatformSupport = props => <AsyncLoader load={import('./../view/bank/virtualCloudPlatform/index')} componentProps={props} />;
const AsyncFinancialCityLanSupport = props => <AsyncLoader load={import('./../view/bank/financialCityLan/index')} componentProps={props} />;


const Routes = {
  // 添加 rules 路由
  // ruleConfig: AsyncRuleConfig,
  ruleConfig: AsyncSubConsoleView,
  rulecenter: AsyncDesignCenter,
  rulesetting: AsyncRuleSetting,
  condition: AsyncRuleCondition,
  action: AsyncRuleAction,

  main: AsyncRootView,
  biz: AsyncRootBizView,
  console: AsyncConsoleView,

  // config: AsyncConfig,
  config: AsyncSubConsoleView,

  '3dview': AsyncThree3dView,

  bizview: AsyncBusinessView,
  riskPoint: AsyncRiskPoint,
  dutyinfo: AsyncDutyinfo,
  fireequip: AsyncFireequip,
  personnel: AsyncPersonnel,
  patrolpoint: AsyncPatrol,
  checklist: AsyncCheckList,
  task: AsyncTaskView,
  pointInfo: AsyncPointInfoView,

  //设备台账
  assessment: AsyncRiskAssessment,
  fireresource: AsyncFireResourceView,
  equipment: AsyncEquipmentView,
  monitor: AsyncMonitorView,
  alarm: AsyncAlarm,
  riskModel: AsyncRiskModel,
  mgtCtrlModel: AsyncMgtCtrlModel,
  // param: AsyncParamSet,
  param: RiskList,
  riskassessment: AsyncRiskAssessment,
  waterResource: AsyncFireStationMatches,
  stationResource: AsyncMatchEquipment,
  strengthResource: AsyncFireStrengthResourceView,
  xjCtrlModel: AsyncXJCtrlModel,
  autologin: AsyncAutoLogin,
  differentiate: AsyncDifferentiate,

  modelManage: RiskModelMgt,
  knowledgeManage: RiskKnowledgeMgt,
  // riskElementManage: SubConsoleView
  equipmentFacilities: EquipFacilities,
  taskwork: TaskWork,
  camera: Cameras,
  checkStandard: CheckStandard,
  checkPlan: CheckPlan,
  execute: Execute,
  identification: Identification,
  announcement: Announcement,
  dailyInformation: DailyInformation,
  mytoDo: MytoDo,
  mytoHave: MytoHave,
  processTo: ProcessTo,
  judgedSummary: JudgedSummary,
  warningCurve: WarningCurve,
  warningIndicators: WarningIndicatorConfig,
  thresholdConfiguration: ThresholdConfig,
  warningIndicatorManage: WarningIndicatorManage,
  checkRecordList: CheckRecordList,
  preControl: PreControlSituation,
  dangerList: DangerList,
  tileview: TileView,
  topography: AsyncNetTopology,
  videoIframe: VideoIframeView,
  video: VideoView,
  warn: WarningsSituation,
  twoDimensionalMap:AsyncTwoDimensionalMap,
  defaultRoute: AsyncTopology,
  pamsTable: AsyncPamsTable,
  donghuan: AsyncDynamicRing,
  deviceMonitor: AsyncEquipMonitor,
  eqpAndMovingRing: AsyncEqpAndMovingRing,
  selfSupport: AsyncSelfSupport,
  financialCityLan: AsyncFinancialCityLanSupport,
  virtualCloudPlatform: AsyncVirtualCloudPlatformSupport

};

const pageCompontent = key => {
  return Routes[key] || AsyncEmptyPage;
};

export { AsyncRootView, AsyncUserInfo, AsyncRootBizView, AsyncConsoleView, AsyncRegionList };

export default pageCompontent;
