import {commonGet, commonPost, commonPut, commonDelete } from './../utils/request';
import {FscSerUrl} from './../consts/urlConsts';
import formatUrl from 'amos-processor/lib/utils/urlFormat';
/**
 * 根据巡检点ID获取巡检人员信息
 * @param {巡检点id} id 
 */
export const fetchXJUserInfoAction = (pd) => {
  const url = `${FscSerUrl.fetchUserByPd}/${pd}`; 
  return commonGet(url);
};

/**
 * 根据巡检点获取巡检记录
 * @param {巡检点id} pd 
 * @param {查询条件：pointID，status，checkTime} data 
 */
export const fetchXJCheckInfoAction =(pd,data)=>{
   let newCriteriasList = [];
   for(let key in data){//遍历json对象的每个key/value对,p为key
      newCriteriasList.push({ name: key,type: 1,value: data[key]});
   }
    newCriteriasList.push({ name: 'pointID',type: 1,value: pd}); 
    const url = `${FscSerUrl.fetchCheckInfoByPd}?pageNumber=${data['pageNumber']}&pageSize=${data['pageSize']}`;
    return commonPost(url,newCriteriasList);
}
/**
 * 巡检点列表查询条件初始化数据
 */

export const fetchPointQueryCriteria = () => {
  const url = `${FscSerUrl.fetchPointQueryCriteria}`; 
  return commonGet(url);
};
/**
 * 风险点信息列表查询
 * @param {*} data 
 */
export const fetchPointListAction = (data) => {
  let newCriteriasList = [];
  for(let key in data){//遍历json对象的每个key/value对,p为key
      newCriteriasList.push({ name: key,type: 1,value: data[key]});
  }
  const url = `${FscSerUrl.fetchPointList}?pageNumber=${data['pageNumber']}&pageSize=${data['pageSize']}`; 
  return commonPost(url,newCriteriasList);
};
/**
 * 获取风险点详细信息
 */
export const fetchPointDetailAction = (id) => {
  const url = `${FscSerUrl.fetchPointDetail}/${id}`; 
  return commonGet(url);
};

/**
 * 获取风险点明细
 */
export const fetchPtDetailByIdAction = (id) => {
  const url = `${FscSerUrl.fetchPointDetailById}/${id}`; 
  return commonGet(url);
};

/**
 * 获取风险点措施
 */
export const fetchPointMeasuresAction = (id) => {
  const url = `${FscSerUrl.fetchPointMeasures}/${id}`; 
  return commonGet(url);
};

export const deletePointMeasuresAction = (id) => {
  const url = `${FscSerUrl.fetchPointMeasures}/${id}`; 
  return commonGet(url);
};

export const batchDeletePointMeasuresAction = (data) => {
  const url = `${FscSerUrl.batchDeletePointMeasuresAction}`; 
  return commonPost(url, data);
};

export const savePointMeasuresAction = (data) => {
  const url = `${FscSerUrl.addPointMeasures}`; 
  return commonPost(url, data);
};

export const batchSavePointMeasuresAction = (data) => {
  const url = `${FscSerUrl.batchAddPointMeasuresAction}`; 
  return commonPost(url, data);
};


export const fetchPointStatistics = (data) => {
  const url = `${FscSerUrl.fetchPointStatistics}`;
  return commonGet(url);
};

export const fetchXJChkExecuteAction = (data) => {
  let newCriteriasList = [];
  for(let key in data){//遍历json对象的每个key/value对,p为key
      newCriteriasList.push({ name: key,type: 1,value: data[key]});
  }
  const url = `${FscSerUrl.fetchChkExecuteInfo}?pageNumber=${data['pageNumber']}&pageSize=${data['pageSize']}`;
  return commonPost(url,newCriteriasList);
};

/**
 * 月巡检情况统计
 * @param {*yyyyMMdd,查询月所在日期} data 
 */
export const fetchMonthCountChkAction = (data) => {
  const url = `${FscSerUrl.fetchMonthCountChk}/${data}`;
  return commonGet(url);
};

/**
 * 月巡检情况统计
 * @param {*yyyyMMdd,查询月所在日期} data 
 */
export const fetchTaskListAction = (data) => {
  let newCriteriasList = [];
  for(let key in data){//遍历json对象的每个key/value对,p为key
      newCriteriasList.push({ name: key,type: 1,value: data[key]});
  }
  const url = `${FscSerUrl.fetchTaskList}?pageNumber=${data['pageNumber']}&pageSize=${data['pageSize']}`;
  return commonPost(url,newCriteriasList);
};
/**
 * 任务统计
 * @param {*yyyyMMdd,查询月所在日期} data 
 */
export const fetchHidDangerCountAction = (data) => {
  const url = `${FscSerUrl.fetchHidDangerCount}/${data}`;
  return commonGet(url);
};

/**
 * 任务列表查询条件初始化数据
 */

export const fetchTaskQueryCriteria = () => {
  const url = `${FscSerUrl.fetchTaskQueryCriteria}`; 
  return commonGet(url);
};

/**
 * 保存用户选择公司
 */
export const fetchRegionSelectAction = (orgCode) => {
  return commonGet(formatUrl(FscSerUrl.fetchRegionSelectUrl, { orgCode }));
};


/**
 * 获取日期点所在月是否有巡检记录
 * @param {string,String} pointId,date
 */
export const fetchCalCountPanelAction = (data) => { 
  return commonPost(FscSerUrl.fetchCalCountPanelUrl, data);
};

export const queryUserByDeptIdAction = (deptId) => {
  return commonGet(formatUrl(FscSerUrl.userInfoByDeptIdUrl, { deptId }));
};


export const queryRoutePlanPointAction = (filter) => {
  return commonPost(formatUrl(FscSerUrl.routePlanPointPageUrl), filter);
};
