import formatUrl from 'amos-processor/lib/utils/urlFormat';
import { commonGet, commonPost, commonPut, commonDelete } from './../utils/request';
import { FscSerUrl, FasSerUrl } from './../consts/urlConsts';

/**
 * 根据ID获取巡检记录详情
 */
export const fetchCheckDetailById = (data) => {
  const url =  `${FscSerUrl.fetchCheckDetailById}/`;
  return commonPost(FscSerUrl.fetchCheckDetailById, data);
};

export const fetchCheckInputById = (data) => {
  const url = `${FscSerUrl.fetchCheckInputById}/`;
  return commonPost(FscSerUrl.fetchCheckInputById, data);
};

/**
 * 三维地图中各种点详情
 */
export const dialogDetailsAction = (dialogId, type) => {
  return commonGet(formatUrl(FasSerUrl.dialogPointDetailUrl, { dialogId, type }));
}; 



/**
 * 风险点预警信息
 */
export const queryRiskSoureWarningAction = (riskSourceId) => {
  return commonGet(formatUrl(FasSerUrl.riskSoureWarningUrl, { riskSourceId }));
}