import { SpcSerUrl } from './../consts/urlConsts';
import { commonPost, commonGet, commonDelete } from './../utils/request';

// 动环 树
export const getDyTreeAction = () => {
  let url = SpcSerUrl.getDyTreeUrl;
  return commonGet(url);
};

// 动环 拓扑图
export const getDyTopoAction = (treeid) => {
  let url = `${SpcSerUrl.getDyTopoUrl}/${treeid}`;
  return commonGet(url);
};

// 动环 拓扑图更新数据
export const updateDyTopoAction = (params) => {
  let url = SpcSerUrl.updateDyTopoUrl;
  return commonPost(url,params);
};

// 动环 拓扑图节点详情
export const nodeDetailTopoAction = (id) => {
  let url = `${SpcSerUrl.nodeDetailDyTopoUrl}/${id}`;
  return commonGet(url);
};
