import formatUrl from 'amos-processor/lib/utils/urlFormat';
import { FasSerUrl } from './../consts/urlConsts';
import { commonGet, commonPost, commonDelete, commonPut } from './../utils/request';

/**
 * 获取消防车列表
 */
export const getFireTruckListAction = (filter, page, size) => {
  return commonPost(formatUrl(FasSerUrl.fireTruckListUrl, { page, size }), filter);
};

/**
 * 获取消防车详情
 */
export const getFireTruckDetailAction = (id) => {
  return commonGet(formatUrl(FasSerUrl.fireTruckDetailUrl, { id }));
};

/**
 * 获取消防设备列表
 *
 * @param {*} filter
 * @param {*} page
 * @param {*} size
 */
export const getFireEquipmentListAction = (filter, page, size) => {
  let { name, code, equipClassify } = filter;
  name = name === undefined ? '' : name;
  code = code === undefined ? '' : code;
  equipClassify = equipClassify === undefined ? '0,1,3' : equipClassify;
  let url = formatUrl(FasSerUrl.fireEquipmentListUrl, { name, code, equipClassify, page, size });
  return commonGet(url);
};

/**
 * 已配置点位列表
 *
 * @param {*} filter
 * @param {*} page
 * @param {*} size
 */
export const getMonitorPointListAction = (filter, fireEqumtId, page, size) => {
  return commonGet(formatUrl(FasSerUrl.monitorPointListUrl, { fireEqumtId, page, size }), filter);
};

/**
 * 新增/编辑消防设备监测点
 *
 * @param {*} monitorPoint
 */
export const saveMonitorPointAction = (monitorPoint) => {
  return commonPost(FasSerUrl.monitorPointEditUrl, monitorPoint);
};

/**
 * 删除消防设备监测点
 *
 * @param {*} ids
 */
export const deleteMonitorPointAction = (ids) => {
  return commonDelete(formatUrl(FasSerUrl.monitorPointDeleteUrl, { ids }));
};

/**
 * 编辑监测点
 *
 * @param {*} id
 */
export const editMonitorPointAction = (id, monitorPoint) => {
  return commonPut(formatUrl(FasSerUrl.monitorPointQryEditUrl, { id }), monitorPoint);
};

/**
 * 查询监测点
 *
 * @param {*} id
 */
export const queryMonitorPointAction = (id) => {
  return commonGet(formatUrl(FasSerUrl.monitorPointQryEditUrl, { id }));
};

/**
 * 查询重点设备列表
 *
 * @param {*} id
 */
export const getEquipmentListAction = (filter, page, size) => {
  return commonPost(formatUrl(FasSerUrl.equipmentListQryUrl, { page, size }), filter);
};

/**
 * 配套装备列表
 *
 * @param {*} filter
 * @param {*} equipmentId
 * @param {*} page
 * @param {*} size
 */
export const getMatchEquipmentListAction = (filter, equipmentId, page, size) => {
  return commonGet(formatUrl(FasSerUrl.matchEquipmentListUrl, { equipmentId, page, size }), filter);
};

/**
 * 生产区域查询，不分页
 */
export const areaPlistNoPageAction = () => {
  return commonGet(formatUrl(FasSerUrl.areaPlistUrl), {});
};

/**
 * 保护对象查询，不分页
 */
export const equipNoPageAction = () => {
  return commonGet(formatUrl(FasSerUrl.equipNoPageListUrl), {});
};

/**
 * 删除重点设备的配套设备
 *
 * @param {*} equipmentId
 * @param {*} fireEquipmentId
 */
export const deleteMatchEquipmentAction = (equipmentId, fireEquipmentId) => {
  return commonDelete(formatUrl(FasSerUrl.matchEquipmentUnBindUrl, { equipmentId, fireEquipmentId }));
};

/**
 * 重点设备绑定配套装备
 *
 * @param {*} id
 * @param {*} bindObj
 */
export const bindMatchEquipmentAction = (id, bindObjList) => {
  return commonPost(formatUrl(FasSerUrl.matchEquipmentBindUrl, { id }), bindObjList);
};

/**
 * 获取重点设备相关图片
 *
 * @param {*} searchParam
 */
export const getPrePlanPictureAction = (equipmentId, type) => {
  let url = formatUrl(FasSerUrl.equipmentPrePlanPictureUrl, { equipmentId, type });
  return commonGet(url);
};

/**
 * 消防小室列表查询
 * @param {*} filter
 * @param {*} page
 * @param {*} size
 */
export const getFireStationAction = (params, page, size) => {
  let paramsUrl = '';
  for (let i = 0; i < params.length; i++ ) {
    let param = params[i];
    paramsUrl = paramsUrl + '&' + param.name + '=' + param.value;
  }
  return commonGet(formatUrl(FasSerUrl.fireStationPageUrl, { page, size })  + paramsUrl);
};


/**
 * 消防小室详情
 * @param {*} filter
 * @param {*} page
 * @param {*} size
 */
export const getFireStationDetailAction = (id) => {
  return commonGet(formatUrl(FasSerUrl.fireStationDetailUrl, { id }));
};

/**
 * 删除重点设备
 *
 * @param {*} ids
 */
export const deleteEquipmentAction = (ids) => {
  return commonDelete(formatUrl(FasSerUrl.equipmentDeleteUrl, { ids }));
};

/**
 * 获取重点设备信息
 *
 * @param {*} searchParam
 */
export const getEquipmentDataAction = (id) => {
  let url = formatUrl(FasSerUrl.equipmentGetUrl, { id });
  return commonGet(url);
};

/**
 * 获取消防小室信息
 *
 * @param {*} searchParam
 */
export const getFireStationDataAction = (id) => {
  let url = formatUrl(FasSerUrl.fireStationGetUrl, { id });
  return commonGet(url);
};

/**
 * 删除消防小室信息
 *
 * @param {*} searchParam
 */
export const deleteFireStationDataAction = (ids) => {
  let url = formatUrl(FasSerUrl.fireStationDeleteUrl, { ids });
  return commonDelete(url);
};

/**
 * 新增消防小室信息
 *
 * @param {*} searchParam
 */
export const newFireStationDataAction = (data) => {
  let url = formatUrl(FasSerUrl.fireStationNewUrl);
  return commonPost(url, data);
};

/**
 * 修改消防小室信息
 *
 * @param {*} searchParam
 */
export const editFireStationDataAction = (id, data) => {
  let url = formatUrl(FasSerUrl.fireStationEditUrl, { id });
  return commonPut(url, data);
};

/**
 * 消防水资源列表查询
 * @param {*} filter
 * @param {*} page
 * @param {*} size
 */
export const getFireWaterAction = (params, page, size) => {
  let paramsUrl = '';
  for (let i = 0; i < params.length; i++ ) {
    let param = params[i];
    paramsUrl = paramsUrl + '&' + param.name + '=' + param.value;
  }
  return commonGet(formatUrl(FasSerUrl.fireWaterPageUrl, { page, size })  + paramsUrl);
};


/**
 * 获取水资源信息
 *
 * @param {*} searchParam
 */
export const getFireWaterDataAction = (id) => {
  let url = formatUrl(FasSerUrl.fireWaterDetailUrl, { id });
  return commonGet(url);
};

/**
 * 删除水资源信息
 *
 * @param {*} searchParam
 */
export const deleteFireWaterDataAction = (ids) => {
  let url = formatUrl(FasSerUrl.fireWaterDeleteUrl, { ids });
  return commonDelete(url);
};

/**
 * 新增水资源信息
 *
 * @param {*} searchParam
 */
export const newFireWaterDataAction = (data) => {
  let url = formatUrl(FasSerUrl.fireWaterNewUrl);
  return commonPost(url, data);
};

/**
 * 修改消防水资源信息
 *
 * @param {*} searchParam
 */
export const editFireWaterDataAction = (id, data) => {
  let url = formatUrl(FasSerUrl.fireWaterEditUrl, { id });
  return commonPut(url, data);
};

/**
 * 添加重点设备
 *
 * @param {*} equipment
 */
export const addEquipmentAction = (equipment) => {
  let url = formatUrl(FasSerUrl.equipmentAddUrl);
  return commonPost(url, equipment);
};

/**
 * 删除消防设备
 *
 * @param {*} ids
 */
export const deleteFireEquipmentAction = (ids) => {
  let url = formatUrl(FasSerUrl.fireEquipmentDeleteUrl, { ids });
  return commonDelete(url);
};

/**
 * 获取消防装备信息
 *
 * @param {*}
 */
export const getFireEquipmentAction = (id) => {
  let url = formatUrl(FasSerUrl.fireEquipmentGetUrl, { id });
  return commonGet(url);
};

/**
 * 增加消防装备
 *
 * @param {*}
 */
export const addFireEquipmentAction = (fireEquipment) => {
  let url = formatUrl(FasSerUrl.fireEquipmentAddUrl);
  return commonPost(url, fireEquipment);
};

/**
 * 删除消防车
 *
 * @param {*} ids
 */
export const deleteFireTruckAction = (ids) => {
  let url = formatUrl(FasSerUrl.fireTruckDeleteUrl, { ids });
  return commonDelete(url);
};

/**
 * 增加消防车
 *
 * @param {*}
 */
export const addFireTruckAction = (fireTruck) => {
  let url = formatUrl(FasSerUrl.fireTruckAddUrl);
  return commonPost(url, fireTruck);
};







/**
 * 消防力量列表查询
 * @param {*} filter
 * @param {*} page
 * @param {*} size
 */
export const getFireStrengthAction = (params, page, size) => {
  let paramsUrl = '';
  for (let i = 0; i < params.length; i++ ) {
    let param = params[i];
    paramsUrl = paramsUrl + '&' + param.name + '=' + param.value;
  }
  return commonGet(formatUrl(FasSerUrl.fireStrengthPageUrl, { page, size })  + paramsUrl);
};

/**
 * 获取消防力量信息
 *
 * @param {*} searchParam
 */
export const getFireStrengthDataAction = (id) => {
  let url = formatUrl(FasSerUrl.fireStrengthDetailUrl, { id });
  return commonGet(url);
};

/**
 * 删除消防力量信息
 *
 * @param {*} searchParam
 */
export const deleteFireStrengthDataAction = (ids) => {
  let url = formatUrl(FasSerUrl.fireStrengthDeleteUrl, { ids });
  return commonDelete(url);
};

/**
 * 新增消防力量信息
 *
 * @param {*} searchParam
 */
export const newFireStrengthDataAction = (data) => {
  let url = formatUrl(FasSerUrl.fireStrengthNewUrl);
  return commonPost(url, data);
};

/**
 * 修改消防力量信息
 *
 * @param {*} searchParam
 */
export const editFireStrengthDataAction = (id, data) => {
  let url = formatUrl(FasSerUrl.fireStrengthEditUrl, { id });
  return commonPut(url, data);
};

/**
 * 消防站添加配套消防装备
 *
 * @param {*} data 消防站和消防装备关系
 */
export const bindFireStationMatchesAction = (data) => {
  let url = formatUrl(FasSerUrl.fireStationMatchesAddUrl);
  return commonPost(url, data);
};

/**
 * 配套消防装备列表
 *
 * @param {*} filter
 * @param {*} fireStationId
 * @param {*} page
 * @param {*} size
 */
export const getMatchesFireEquipmentListAction = (filter, fireStationId, page, size) => {
  let url = formatUrl(FasSerUrl.fireStationMatchesListUrl, { fireStationId, page, size });
  return commonGet(url, filter);
};

/**
 * 删除消防站的配套设备
 *
 * @param {*} equipmentId
 * @param {*} fireEquipmentId
 */
export const deleteFireStationMatchesAction = (data) => {
  let url = formatUrl(FasSerUrl.fireStationMatchesDeleteUrl);
  return commonDelete(url, data);
};

/**
 * 增加消防车
 *
 * @param {*}
 */
export const updateFireStationAction = (fireStation) => {
  let url = formatUrl(FasSerUrl.getFireStationInfoUrl);
  return commonPost(url, fireStation);
};
