import amosRequest, { singleFetch } from 'amos-processor/lib/fetch/amosRequest';
import { utils } from 'amos-tool';
import formatUrl from 'amos-processor/lib/utils/urlFormat';
import { Store } from 'amos-tool';
import { message } from 'amos-framework';
import sysConsts from 'amos-processor/lib/config';
import payload from './payload';

const lsTool = Store.lsTool;

const defaultPageable = {
  page: 0,
  size: 10
};

const defaultHeaders = {
  appKey: 'AMOS_BANK',
  product: 'AMOS_BANK_WEB'
};

/**
 * 删除全局变量requests中的地址
 * @param {*} url 
 * @param {*} method 
 */
const delRequest = (url, method) => {
  if (window.requests && window.requests.length > 0) {
    window.requests = window.requests.filter(e => e.url !== url && e.method !== method);
  }
};

/**
 * 构建分页
 */
const buildPageable = (url, pageable = defaultPageable) => {
  let { page, size } = pageable;
  return `${url}?page=${page}&size=${size}`;
};

/**
 * 转换指定值为 JSON
 * @param {array} dataList
 * @param {string} key
 */
const convertDatalist = (dataList = [], key = 'content') => {
  const newDL = dataList.map(d => {
    if (!utils.isNil(d[key]) && utils.isString(d[key])) {
      d[key] = JSON.parse(d[key]);
    }
    return d;
  });
  return newDL;
};

const getWithCookie = (url) => {
  return commonGet(url, {
    hasCookie: true
  });
};

const commonGet = (url) => {
  window.setLoading && window.setLoading(true);
  return amosRequest(url, { 
    timeout: 10000000 , method: 'GET',
    headers: compleHeaders(),
    reject(error){
      window.setLoading && window.setLoading(false);
      delRequest(url, 'GET');
      //message.danger(error.message || '请求失败，服务器错误！');
    }
  }).then(data => payload(data));
}


const commonPost = (url, data, params) => {
  window.setLoading && window.setLoading(true);
  return amosRequest(url, {
    timeout: 10000000,
    method: 'POST',
    headers: compleHeaders(),
    body: data,
    reject(error){
      delRequest(url, 'POST');
      window.setLoading && window.setLoading(false);
      //message.danger(error.message || '请求失败，服务器错误！');
    }
  }).then(data => payload(data));
}

const commonPut = (url, data, params) => {
  window.setLoading && window.setLoading(true);
  return amosRequest(url, {
    timeout: 10000000,
    method: 'PUT',
    headers: compleHeaders(),
    body: data,
    reject(error){
      delRequest(url, 'PUT');
      window.setLoading && window.setLoading(false);
      //message.danger(error.message || '请求失败，服务器错误！');
    }
  }).then(data => payload(data));
}

const commonDelete = (url, data, params) => {
  window.setLoading && window.setLoading(true);
  return amosRequest(url, {
    timeout: 10000000 ,
    method: 'DELETE',
    headers: compleHeaders(),
    body: data,
    reject(error){

      window.setLoading && window.setLoading(false);
      //message.danger(error.message || '请求失败，服务器错误！');
    }
  }).then(data => payload(data));
}

const compleHeaders = () => {
  return {
    ...defaultHeaders,
    token: getToken()
  };
};

export function getToken(){
  return lsTool.read(sysConsts.token);
}

export function getUser(){
  return lsTool.read(sysConsts.userId);
}

export function setToken(token){
  return lsTool.write(sysConsts.token, token);
}

export function setUserId(userId){
  return lsTool.write(sysConsts.userId, userId);
}

export { amosRequest, commonGet, getWithCookie, singleFetch, commonPost, commonPut, commonDelete, convertDatalist, buildPageable, formatUrl };
