import { utils } from 'amos-tool';

export const controlItemClickType = {
  cancel: 'cancel',
  init: 'init'
};

export const markerTypeMapping = {
  risk: {
    blue: 0,
    normal: 1,
    miss: 2,
    warning: 3,
    alarm: 4
  }
};

/**
 * 手动操作类型
 */
export const operateTypes = {
  // 操作或者选中线路
  LINK: 'link',
  POINT: 'point',
  // marker 点数据源变化
  POINT_CHANGE: 'point_change',
  // 批量 marker 点数据源变化
  BATCH_POINT_CHANGE: 'batch_point_change',

  POINT_SEARCH: 'search'
};

export const pointTopicMapping = {
  riskSource: 'riskSource-point',
  risk: 'risk-point',
  taskWork: 'taskWork'
};

export const eventTopics = {
  // 双屏通信主题
  transtopic: 'transtopic',

  base3d: 'base3d',
  base3d_view: 'base3d.view',

  level_filter_risk: 'base3d.view.level_filter_risk', // 风险点 级别过滤
  manual_operate: 'base3d.view.manual_operate', // 手动操作
  point_change: 'base3d.view.point_change', // marker 点变化
  batch_point_change: 'base3d.view.batch_point_change', // 批量 marker 点变化
  linkdata_change: 'base3d.view.linkdata_change', // marker 点变化

  point_patrol: 'base3d.view.point_patrol', // 巡检点
  point_risk: 'base3d.view.point_risk', // 风险点
  point_video: 'base3d.view.point_video', // 视频点
  point_person: 'base3d.view.point_person', // 人员点
  point_data: 'base3d.view.point_data', // 数据点
  point_croom: 'base3d.view.point_croom', // 控制室
  point_trajectory: 'base3d.view.point_trajectory', // 轨迹

  innate_layer: 'base3d.view.controller_layer', // 楼层操作
  innate_operater: 'base3d.view.controller_operater', // 三维内置操作

  fromws: 'base3d.fromws',

  datapane_msg: 'base3d.fromws.datapane_msg', // datapane 消息

  broad_msg: 'base3d.fromws.broad_msg', // 播报消息

  global_msg: 'base3d.fromws.global_msg', // 全局消息
  map_bubble: 'base3d.fromws.map_bubble', // 监控屏气泡
  riskSituation_bubble: 'base3d.fromws.riskSituation_bubble', //  业务屏风险态势图气泡
  riskSituation_colour: 'base3d.fromws.riskSituation_colour' //  业务屏态势图颜色更改
};

export const isPointEvent = (topic) => topic.indexOf('.point_') > -1;
export const isControllerEvent = (topic) => topic.indexOf('.controller_') > -1;
export const isLevelFilter = (topic) => topic.indexOf('.level_filter_') > -1;
export const isManualOperate = (topic) => topic.indexOf('.manual_operate') > -1;
export const isGlobalMsg = (topic) => topic.indexOf('global_msg') > -1;
export const isSearchManualOperate = (topic) => topic.indexOf('.search_manual_operate') > -1;
export const isFireResource = (markerType) => markerType.indexOf('fireResource') > -1;

const buildTopic = ({ iFDomain, group, template }) => {
  let topic = '';
  if (utils.isEmpty(group)){
    topic = `base3d.${iFDomain}.${template}`;
  } else {
    topic = `base3d.${iFDomain}.${group}.${template || 'default'}`;
  }

  return topic;
};

/**
 * 组装数据，转为 { topic, content }
 * @param {object} data
 */
export const rulesDataFactory = (data) => {
  const { iFDomain, group, template, dataList, bizObj, actionId } = data || {};
  const topic = buildTopic({ iFDomain, group, template });
  const content = {
    group,
    type: template,
    data: dataList,
    bizObj,
    actionId
  };

  return {
    topic,
    content
  };
};
