import React, { Component } from 'react';
import PropTypes from 'prop-types';
import Close from '../common/Close';
import Footer from '../common/Footer';

class MinInfo extends Component {
  render() {
    const { onClose, content, table, footers, onFooterItemClick, activeKey, isFooter } = this.props;
    return (
      <div className="dialog-body-min">
        <div className="body-min-header">
          <Close onClose={onClose} />
        </div>
        <div className="body-min-content">
          {content}
        </div>
        <div className="body-min-table">
          {table}
        </div>
        <Footer footers={footers} onItemClick={onFooterItemClick} activeKey={activeKey} />
      </div>
    );
  }
}

MinInfo.propTypes = {
  activeKey: PropTypes.string,
  onClose: PropTypes.func,
  content: PropTypes.node,
  footers: PropTypes.array,
  onFooterItemClick: PropTypes.func
};

export default MinInfo;
