import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { utils, consts } from 'amos-tool';
import classNames from 'classnames';
import imgStatic from './../../../consts/imgStatic';
import BizIcon from '../../common/icon/BizIcon';

const PointStatusEnum = { unplanned: '未计划', miss: '漏检', offGrade: '不合格', pass: '合格', task: '超时' };

const markerIoncMapper = imgStatic.markers;
const markerIoncColorMapper = imgStatic.color;
// 显示巡检点状态、任务
const pointIcon = imgStatic.pointIcon;

const getIcon = (markerType, level) => {
  if (markerType === 'riskSource' || markerType === 'danger' || markerType === 'taskWork') {
    return markerIoncMapper[`${markerType}_${level}`];
  }
  return markerIoncMapper[`${markerType}`];
};

const getBKIconColor = markerType => {
  return markerIoncColorMapper[markerType];
};

const disableLabel = markerType => {
  return !['person'].includes(markerType);
};

class MarkerIcon extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showInfo: props.showInfo,
      showRiskName: false
    };
  }

  componentWillMount = () => {
    const { title, type } = this.props;
    this.setState({ title, type });
  };

  componentWillReceiveProps = nextProps => {
    const { showInfo } = nextProps;
    this.setState(showInfo);
  };

  onMouseOver = () => {
    this.setState({ showRiskName: true, showInfo: true });
  };

  // display:none;
  onMouseLeave = () => {
    const { title, type } = this.state;
    if (type === 'risk' && (title.includes('miss') > 0 || title.includes('offGrade') > 0)) {
      this.setState({ showRiskName: false });
    } else if ((type === 'riskSource' || type === 'taskwork') && this.props.showInfo) {
      this.setState({ showRiskName: false });
    } else {
      this.setState({ showInfo: false, showRiskName: false });
    }
  };

  renderTitle = (title, label, showRiskName, type, showInfo, twinkle) => {
    if (type === 'risk') {
      // 多图标方式
      if (showInfo) {
        return (
          <div className="marker-icon-title">
            {title.map(t => {
              if (showRiskName) {
                return (
                  <div key={t} className="title-child">
                    {/* <img src={pointIcon[t]} alt="" /> */}
                    <div className="title-text">{label}</div>
                  </div>
                );
              } else {
                return (
                  <div key={t} className="title-child">
                    <img src={pointIcon[t]} alt="" />
                    <div className="title-text">{PointStatusEnum[t]}</div>
                  </div>
                );
              }
            })}
          </div>
        );
      } else {
        return (
          <div>
            {title.map(t => {
              if (t === 'miss' || t === 'offGrade') {
                <div className="marker-icon-title">
                  <div key={t} className="title-child">
                    <img src={pointIcon[t]} alt="" />
                    <div className="title-text">{PointStatusEnum[t]}</div>
                  </div>
                </div>;
              }
            })}
          </div>
        );
      }
    } else if (type === 'riskSource') {
      if (showInfo) {
        if (showRiskName) {
          return (
            <div className="marker-icon-title" style={{ zIndex: 1000 }}>
              <div className="title-text">{label}</div>
            </div>
          );
        } else {
          twinkle = true;
          return (
            <div className="marker-icon-title" style={{ zIndex: 1000 }}>
              <div className="title-text">{'风险值' + parseInt(title)}</div>
            </div>
          );
        }
      }
    // } else if (type === 'majorHazard') {
    //   if (showInfo && utils.isString(label)) {
    //     return (
    //       <div className="marker-icon-title" style={{ zIndex: 1000 }}>
    //         <div className="title-text">{label}</div>
    //       </div>
    //     );
    //   }
    // } else if (type === 'taskwork') {
    //   if (showInfo) {
    //     if (showRiskName) {
    //       return (
    //         <div className="marker-icon-title" style={{ zIndex: 1000 }}>
    //           <div className="title-text">{label}</div>
    //         </div>
    //       );
    //     } else {
    //       return (
    //         <div className="marker-icon-title" style={{ zIndex: 1000 }}>
    //           <div className="title-text">{title}</div>
    //         </div>
    //       );
    //     }
    //   }
    } else {
      if (utils.isString(title) && showInfo) {
        // let style = { color: '#000000', backgroundColor: '#edeff1', background: '#edeff1' };
        return (
          <div className="marker-icon-title" style={{ zIndex: 1000 }}>
            <div className="title-text">{title}</div>
          </div>
        );
      }
    }
  };

  render() {
    const { markerType, title, level, twinkle, label, type,rate = 0 } = this.props;
    const { showInfo, showRiskName } = this.state;
    const second = rate === 0 ? 0 : 1 / rate;
    const style = {
      background: `url(${getIcon(markerType, level)}) no-repeat`,
      backgroundSize: 'contain'
    };
    const cls = classNames('marker-icon', {
      'marker-anim': second > 0 ? true : twinkle
    });
    // const showLabel = disableLabel(markerType);
    // {showLabel && markerType === 'riskSource' && level}
    if (showInfo) {
      return (
        <div className={cls} style={style} onMouseLeave={this.onMouseLeave} onMouseOver={this.onMouseOver}>
          {this.renderTitle(title, label, showRiskName, type, showInfo, twinkle)}
          {(second > 0 || twinkle) && <div className="pulse-spread" style={{ animationDuration: `${second}s` }} />}
        </div>
      );
    }
    return (
      <div className={cls} style={style} onMouseOver={this.onMouseOver}>
        {this.renderTitle(title, label, showRiskName, type, showInfo, twinkle)}
        {(second > 0 || twinkle) && <div className="pulse-spread" style={{ animationDuration: `${second}s` }} />}
      </div>
    );
  }
}

MarkerIcon.propTypes = {
  markerType: PropTypes.string,
  showInfo: PropTypes.bool,
  subscribe: PropTypes.func,
  title: PropTypes.oneOfType([PropTypes.string, PropTypes.arrayOf(PropTypes.string)]),
  level: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),
  twinkle: PropTypes.bool,
  label: PropTypes.string,
  type: PropTypes.string,
  rate: PropTypes.number
};

export default MarkerIcon;
