import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { connect3D } from 'amos-3d/lib/designer';
import { Connect } from 'amos-framework';
import PickDialog from './pickDialog';

export const eventConnect = Connect.eventConnect;
export const Shuttle = (props) => props.children;

/**
 * 坐标拾取
 *
 * @export
 * @class CoordinatePickup
 * @extends {Component}
 */
@connect3D
@eventConnect
export class CoordinatePickup extends Component {
  constructor(props) {
    super(props);
  }
  componentDidMount() {
  }

  onClose = () => {
    this.props.onClose();
  }

  render() {
    const { visible, ...rest } = this.props;
    return (
      <Shuttle>
        <PickDialog visible={visible} {...rest} onClose={this.onClose} />
      </Shuttle>
    );
  }
}

CoordinatePickup.propTypes = {
  data: PropTypes.object,
  visible: PropTypes.bool,
  onClose: PropTypes.func
};

export default CoordinatePickup;
